/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz;

import eos.moe.dragoncore.lib.xz.ArrayCache;
import eos.moe.dragoncore.lib.xz.BCJCoder;
import eos.moe.dragoncore.lib.xz.FilterDecoder;
import eos.moe.dragoncore.lib.xz.SimpleInputStream;
import eos.moe.dragoncore.lib.xz.UnsupportedOptionsException;
import eos.moe.dragoncore.lib.xz.simple.ARM;
import eos.moe.dragoncore.lib.xz.simple.ARM64;
import eos.moe.dragoncore.lib.xz.simple.ARMThumb;
import eos.moe.dragoncore.lib.xz.simple.IA64;
import eos.moe.dragoncore.lib.xz.simple.PowerPC;
import eos.moe.dragoncore.lib.xz.simple.RISCVDecoder;
import eos.moe.dragoncore.lib.xz.simple.SPARC;
import eos.moe.dragoncore.lib.xz.simple.SimpleFilter;
import eos.moe.dragoncore.lib.xz.simple.X86;
import java.io.InputStream;

class BCJDecoder
extends BCJCoder
implements FilterDecoder {
    private final long filterID;
    private final int startOffset;

    BCJDecoder(long filterID, byte[] props) throws UnsupportedOptionsException {
        assert (BCJDecoder.isBCJFilterID(filterID));
        this.filterID = filterID;
        if (props.length == 0) {
            this.startOffset = 0;
        } else if (props.length == 4) {
            int n2 = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                n2 |= (props[i2] & 0xFF) << i2 * 8;
            }
            this.startOffset = n2;
        } else {
            throw new UnsupportedOptionsException("Unsupported BCJ filter properties");
        }
    }

    @Override
    public int getMemoryUsage() {
        return SimpleInputStream.getMemoryUsage();
    }

    @Override
    public InputStream getInputStream(InputStream in2, ArrayCache arrayCache) {
        SimpleFilter simpleFilter = null;
        if (this.filterID == 4L) {
            simpleFilter = new X86(false, this.startOffset);
        } else if (this.filterID == 5L) {
            simpleFilter = new PowerPC(false, this.startOffset);
        } else if (this.filterID == 6L) {
            simpleFilter = new IA64(false, this.startOffset);
        } else if (this.filterID == 7L) {
            simpleFilter = new ARM(false, this.startOffset);
        } else if (this.filterID == 8L) {
            simpleFilter = new ARMThumb(false, this.startOffset);
        } else if (this.filterID == 9L) {
            simpleFilter = new SPARC(false, this.startOffset);
        } else if (this.filterID == 10L) {
            simpleFilter = new ARM64(false, this.startOffset);
        } else if (this.filterID == 11L) {
            simpleFilter = new RISCVDecoder(this.startOffset);
        } else assert (false);
        return new SimpleInputStream(in2, simpleFilter);
    }
}

