/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.lang3.time;

import eos.moe.dragoncore.lib.apache.lang3.time.GmtTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FastTimeZone {
    private static final Pattern GMT_PATTERN = Pattern.compile("^(?:(?i)GMT)?([+-])?(\\d\\d?)?(:?(\\d\\d?))?$");
    private static final TimeZone GREENWICH = new GmtTimeZone(false, 0, 0);

    public static TimeZone getGmtTimeZone() {
        return GREENWICH;
    }

    public static TimeZone getGmtTimeZone(String pattern) {
        if ("Z".equals(pattern) || "UTC".equals(pattern)) {
            return GREENWICH;
        }
        Matcher m2 = GMT_PATTERN.matcher(pattern);
        if (m2.matches()) {
            int hours = FastTimeZone.parseInt(m2.group(2));
            int minutes = FastTimeZone.parseInt(m2.group(4));
            if (hours == 0 && minutes == 0) {
                return GREENWICH;
            }
            return new GmtTimeZone(FastTimeZone.parseSign(m2.group(1)), hours, minutes);
        }
        return null;
    }

    public static TimeZone getTimeZone(String id2) {
        TimeZone tz2 = FastTimeZone.getGmtTimeZone(id2);
        if (tz2 != null) {
            return tz2;
        }
        return TimeZone.getTimeZone(id2);
    }

    private static int parseInt(String group) {
        return group != null ? Integer.parseInt(group) : 0;
    }

    private static boolean parseSign(String group) {
        return group != null && group.charAt(0) == '-';
    }

    private FastTimeZone() {
    }
}

