/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.io.input;

import eos.moe.dragoncore.lib.apache.io.TaggedIOException;
import eos.moe.dragoncore.lib.apache.io.input.ProxyReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.UUID;

public class TaggedReader
extends ProxyReader {
    private final Serializable tag = UUID.randomUUID();

    public TaggedReader(Reader proxy) {
        super(proxy);
    }

    @Override
    protected void handleIOException(IOException e2) throws IOException {
        throw new TaggedIOException(e2, this.tag);
    }

    public boolean isCauseOf(Throwable exception) {
        return TaggedIOException.isTaggedWith(exception, this.tag);
    }

    public void throwIfCauseOf(Throwable throwable) throws IOException {
        TaggedIOException.throwCauseIfTaggedWith(throwable, this.tag);
    }
}

