/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.io.input;

import eos.moe.dragoncore.lib.apache.io.build.AbstractStreamBuilder;
import eos.moe.dragoncore.lib.apache.io.input.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;

public final class ChecksumInputStream
extends CountingInputStream {
    private final long expectedChecksumValue;
    private final long countThreshold;

    public static Builder builder() {
        return new Builder();
    }

    private ChecksumInputStream(InputStream in2, Checksum checksum, long expectedChecksumValue, long countThreshold) {
        super(new CheckedInputStream(in2, checksum));
        this.countThreshold = countThreshold;
        this.expectedChecksumValue = expectedChecksumValue;
    }

    @Override
    protected synchronized void afterRead(int n2) throws IOException {
        super.afterRead(n2);
        if ((this.countThreshold > 0L && this.getByteCount() >= this.countThreshold || n2 == -1) && this.expectedChecksumValue != this.getChecksum().getValue()) {
            throw new IOException("Checksum verification failed.");
        }
    }

    private Checksum getChecksum() {
        return ((CheckedInputStream)this.in).getChecksum();
    }

    public long getRemaining() {
        return this.countThreshold - this.getByteCount();
    }

    public static class Builder
    extends AbstractStreamBuilder<ChecksumInputStream, Builder> {
        private Checksum checksum;
        private long countThreshold = -1L;
        private long expectedChecksumValue;

        @Override
        public ChecksumInputStream get() throws IOException {
            return new ChecksumInputStream(this.getInputStream(), this.checksum, this.expectedChecksumValue, this.countThreshold);
        }

        public Builder setChecksum(Checksum checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder setCountThreshold(long countThreshold) {
            this.countThreshold = countThreshold;
            return this;
        }

        public Builder setExpectedChecksumValue(long expectedChecksumValue) {
            this.expectedChecksumValue = expectedChecksumValue;
            return this;
        }
    }
}

