/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.io.input;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.function.IntPredicate;

public abstract class AbstractCharacterFilterReader
extends FilterReader {
    protected static final IntPredicate SKIP_NONE = ch2 -> false;
    private final IntPredicate skip;

    protected AbstractCharacterFilterReader(Reader reader) {
        this(reader, SKIP_NONE);
    }

    protected AbstractCharacterFilterReader(Reader reader, IntPredicate skip) {
        super(reader);
        this.skip = skip == null ? SKIP_NONE : skip;
    }

    protected boolean filter(int ch2) {
        return this.skip.test(ch2);
    }

    @Override
    public int read() throws IOException {
        int ch2;
        while ((ch2 = this.in.read()) != -1 && this.filter(ch2)) {
        }
        return ch2;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = super.read(cbuf, off, len);
        if (read == -1) {
            return -1;
        }
        int pos = off - 1;
        for (int readPos = off; readPos < off + read; ++readPos) {
            if (this.filter(cbuf[readPos]) || ++pos >= readPos) continue;
            cbuf[pos] = cbuf[readPos];
        }
        return pos - off + 1;
    }
}

