/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.io.function;

import eos.moe.dragoncore.lib.apache.io.function.IOBiFunction;
import eos.moe.dragoncore.lib.apache.io.function.IOComparator;
import eos.moe.dragoncore.lib.apache.io.function.Uncheck;
import java.util.Objects;
import java.util.function.BinaryOperator;

@FunctionalInterface
public interface IOBinaryOperator<T>
extends IOBiFunction<T, T, T> {
    public static <T> IOBinaryOperator<T> maxBy(IOComparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a2, b2) -> comparator.compare(a2, b2) >= 0 ? a2 : b2;
    }

    public static <T> IOBinaryOperator<T> minBy(IOComparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a2, b2) -> comparator.compare(a2, b2) <= 0 ? a2 : b2;
    }

    default public BinaryOperator<T> asBinaryOperator() {
        return (t2, u2) -> Uncheck.apply(this, t2, u2);
    }
}

