/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.io.filefilter;

import eos.moe.dragoncore.lib.apache.io.file.PathVisitor;
import eos.moe.dragoncore.lib.apache.io.filefilter.IOFileFilter;
import eos.moe.dragoncore.lib.apache.io.function.IOSupplier;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;

public abstract class AbstractFileFilter
implements IOFileFilter,
PathVisitor {
    private final FileVisitResult onAccept;
    private final FileVisitResult onReject;

    static FileVisitResult toDefaultFileVisitResult(boolean accept) {
        return accept ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
    }

    public AbstractFileFilter() {
        this(FileVisitResult.CONTINUE, FileVisitResult.TERMINATE);
    }

    protected AbstractFileFilter(FileVisitResult onAccept, FileVisitResult onReject) {
        this.onAccept = onAccept;
        this.onReject = onReject;
    }

    @Override
    public boolean accept(File file) {
        Objects.requireNonNull(file, "file");
        return this.accept(file.getParentFile(), file.getName());
    }

    @Override
    public boolean accept(File dir, String name) {
        Objects.requireNonNull(name, "name");
        return this.accept(new File(dir, name));
    }

    void append(List<?> list, StringBuilder buffer) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (i2 > 0) {
                buffer.append(",");
            }
            buffer.append(list.get(i2));
        }
    }

    void append(Object[] array, StringBuilder buffer) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (i2 > 0) {
                buffer.append(",");
            }
            buffer.append(array[i2]);
        }
    }

    FileVisitResult get(IOSupplier<FileVisitResult> supplier) {
        try {
            return supplier.get();
        }
        catch (IOException e2) {
            return this.handle(e2);
        }
    }

    protected FileVisitResult handle(Throwable t2) {
        return FileVisitResult.TERMINATE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attributes) throws IOException {
        return this.accept(dir, attributes);
    }

    FileVisitResult toFileVisitResult(boolean accept) {
        return accept ? this.onAccept : this.onReject;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
        return this.accept(file, attributes);
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

