/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.forms;

import eos.moe.dragoncore.lib.apache.compress.harmony.pack200.Pack200Exception;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.SegmentConstantPool;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.ByteCode;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.ClassFileEntry;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.OperandManager;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.forms.SingleByteReferenceForm;

public class StringRefForm
extends SingleByteReferenceForm {
    public StringRefForm(int opcode, String name, int[] rewrite) {
        super(opcode, name, rewrite);
    }

    public StringRefForm(int opcode, String name, int[] rewrite, boolean widened) {
        this(opcode, name, rewrite);
        this.widened = widened;
    }

    @Override
    protected int getOffset(OperandManager operandManager) {
        return operandManager.nextStringRef();
    }

    @Override
    protected int getPoolID() {
        return 6;
    }

    @Override
    protected void setNestedEntries(ByteCode byteCode, OperandManager operandManager, int offset) throws Pack200Exception {
        SegmentConstantPool globalPool = operandManager.globalConstantPool();
        ClassFileEntry[] nested = new ClassFileEntry[]{globalPool.getValue(this.getPoolID(), offset)};
        byteCode.setNested(nested);
        if (this.widened) {
            byteCode.setNestedPositions(new int[][]{{0, 2}});
        } else {
            byteCode.setNestedPositions(new int[][]{{0, 1}});
        }
    }
}

