/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.compress.harmony.unpack200;

import eos.moe.dragoncore.lib.apache.compress.harmony.pack200.Codec;
import eos.moe.dragoncore.lib.apache.compress.harmony.pack200.Pack200Exception;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.AttributeLayout;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.AttributeLayoutMap;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.BandSet;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.MetadataBandGroup;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.NewAttributeBands;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.Segment;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.AnnotationDefaultAttribute;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.CodeAttribute;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.ConstantValueAttribute;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.DeprecatedAttribute;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.EnclosingMethodAttribute;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.ExceptionsAttribute;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.InnerClassesAttribute;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.LineNumberTableAttribute;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.LocalVariableTableAttribute;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.LocalVariableTypeTableAttribute;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.SignatureAttribute;
import eos.moe.dragoncore.lib.apache.compress.harmony.unpack200.bytecode.SourceFileAttribute;
import java.io.IOException;
import java.io.InputStream;

public class AttrDefinitionBands
extends BandSet {
    private int[] attributeDefinitionHeader;
    private String[] attributeDefinitionLayout;
    private String[] attributeDefinitionName;
    private AttributeLayoutMap attributeDefinitionMap;
    private final String[] cpUTF8;

    public AttrDefinitionBands(Segment segment) {
        super(segment);
        this.cpUTF8 = segment.getCpBands().getCpUTF8();
    }

    public AttributeLayoutMap getAttributeDefinitionMap() {
        return this.attributeDefinitionMap;
    }

    @Override
    public void read(InputStream in2) throws IOException, Pack200Exception {
        int attributeDefinitionCount = this.header.getAttributeDefinitionCount();
        this.attributeDefinitionHeader = this.decodeBandInt("attr_definition_headers", in2, Codec.BYTE1, attributeDefinitionCount);
        this.attributeDefinitionName = this.parseReferences("attr_definition_name", in2, Codec.UNSIGNED5, attributeDefinitionCount, this.cpUTF8);
        this.attributeDefinitionLayout = this.parseReferences("attr_definition_layout", in2, Codec.UNSIGNED5, attributeDefinitionCount, this.cpUTF8);
        this.attributeDefinitionMap = new AttributeLayoutMap();
        int overflowIndex = 32;
        if (this.segment.getSegmentHeader().getOptions().hasClassFlagsHi()) {
            overflowIndex = 63;
        }
        for (int i2 = 0; i2 < attributeDefinitionCount; ++i2) {
            int context = this.attributeDefinitionHeader[i2] & 3;
            int index = (this.attributeDefinitionHeader[i2] >> 2) - 1;
            if (index == -1) {
                index = overflowIndex++;
            }
            AttributeLayout layout = new AttributeLayout(this.attributeDefinitionName[i2], context, this.attributeDefinitionLayout[i2], index, false);
            NewAttributeBands newBands = new NewAttributeBands(this.segment, layout);
            this.attributeDefinitionMap.add(layout, newBands);
        }
        this.attributeDefinitionMap.checkMap();
        this.setupDefaultAttributeNames();
    }

    private void setupDefaultAttributeNames() {
        AnnotationDefaultAttribute.setAttributeName(this.segment.getCpBands().cpUTF8Value("AnnotationDefault"));
        CodeAttribute.setAttributeName(this.segment.getCpBands().cpUTF8Value("Code"));
        ConstantValueAttribute.setAttributeName(this.segment.getCpBands().cpUTF8Value("ConstantValue"));
        DeprecatedAttribute.setAttributeName(this.segment.getCpBands().cpUTF8Value("Deprecated"));
        EnclosingMethodAttribute.setAttributeName(this.segment.getCpBands().cpUTF8Value("EnclosingMethod"));
        ExceptionsAttribute.setAttributeName(this.segment.getCpBands().cpUTF8Value("Exceptions"));
        InnerClassesAttribute.setAttributeName(this.segment.getCpBands().cpUTF8Value("InnerClasses"));
        LineNumberTableAttribute.setAttributeName(this.segment.getCpBands().cpUTF8Value("LineNumberTable"));
        LocalVariableTableAttribute.setAttributeName(this.segment.getCpBands().cpUTF8Value("LocalVariableTable"));
        LocalVariableTypeTableAttribute.setAttributeName(this.segment.getCpBands().cpUTF8Value("LocalVariableTypeTable"));
        SignatureAttribute.setAttributeName(this.segment.getCpBands().cpUTF8Value("Signature"));
        SourceFileAttribute.setAttributeName(this.segment.getCpBands().cpUTF8Value("SourceFile"));
        MetadataBandGroup.setRvaAttributeName(this.segment.getCpBands().cpUTF8Value("RuntimeVisibleAnnotations"));
        MetadataBandGroup.setRiaAttributeName(this.segment.getCpBands().cpUTF8Value("RuntimeInvisibleAnnotations"));
        MetadataBandGroup.setRvpaAttributeName(this.segment.getCpBands().cpUTF8Value("RuntimeVisibleParameterAnnotations"));
        MetadataBandGroup.setRipaAttributeName(this.segment.getCpBands().cpUTF8Value("RuntimeInvisibleParameterAnnotations"));
    }

    @Override
    public void unpack() throws Pack200Exception, IOException {
    }
}

