/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.compress.harmony.pack200;

import eos.moe.dragoncore.lib.apache.compress.harmony.pack200.BHSDCodec;
import eos.moe.dragoncore.lib.apache.compress.harmony.pack200.Pack200Exception;
import eos.moe.dragoncore.lib.apache.io.input.BoundedInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class Codec {
    public static final BHSDCodec BCI5 = new BHSDCodec(5, 4);
    public static final BHSDCodec BRANCH5 = new BHSDCodec(5, 4, 2);
    public static final BHSDCodec BYTE1 = new BHSDCodec(1, 256);
    public static final BHSDCodec CHAR3 = new BHSDCodec(3, 128);
    public static final BHSDCodec DELTA5 = new BHSDCodec(5, 64, 1, 1);
    public static final BHSDCodec MDELTA5 = new BHSDCodec(5, 64, 2, 1);
    public static final BHSDCodec SIGNED5 = new BHSDCodec(5, 64, 1);
    public static final BHSDCodec UDELTA5 = new BHSDCodec(5, 64, 0, 1);
    public static final BHSDCodec UNSIGNED5 = new BHSDCodec(5, 64);
    public int lastBandLength;

    int check(int n2, InputStream in2) throws Pack200Exception {
        if (in2 instanceof BoundedInputStream) {
            BoundedInputStream bin = (BoundedInputStream)in2;
            long count = bin.getCount();
            long maxLength = bin.getMaxCount();
            if (maxLength > -1L) {
                long remaining = maxLength - count;
                String format = "Can't read beyond end of stream (n = %,d, count = %,d, maxLength = %,d, remaining = %,d)";
                if (count < -1L) {
                    throw new Pack200Exception(String.format("Can't read beyond end of stream (n = %,d, count = %,d, maxLength = %,d, remaining = %,d)", n2, count, maxLength, remaining));
                }
                if ((long)n2 > remaining) {
                    throw new Pack200Exception(String.format("Can't read beyond end of stream (n = %,d, count = %,d, maxLength = %,d, remaining = %,d)", n2, count, maxLength, remaining));
                }
            }
        }
        return n2;
    }

    public abstract int decode(InputStream var1) throws IOException, Pack200Exception;

    public abstract int decode(InputStream var1, long var2) throws IOException, Pack200Exception;

    public int[] decodeInts(int n2, InputStream in2) throws IOException, Pack200Exception {
        this.lastBandLength = 0;
        int[] result = new int[this.check(n2, in2)];
        int last = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            result[i2] = last = this.decode(in2, last);
        }
        return result;
    }

    public int[] decodeInts(int n2, InputStream in2, int firstValue) throws IOException, Pack200Exception {
        int[] result = new int[this.check(n2, in2) + 1];
        result[0] = firstValue;
        int last = firstValue;
        for (int i2 = 1; i2 < n2 + 1; ++i2) {
            result[i2] = last = this.decode(in2, last);
        }
        return result;
    }

    public abstract byte[] encode(int var1) throws Pack200Exception;

    public abstract byte[] encode(int var1, int var2) throws Pack200Exception;

    public byte[] encode(int[] ints) throws Pack200Exception {
        int total = 0;
        byte[][] bytes = new byte[ints.length][];
        for (int i2 = 0; i2 < ints.length; ++i2) {
            bytes[i2] = this.encode(ints[i2], i2 > 0 ? ints[i2 - 1] : 0);
            total += bytes[i2].length;
        }
        byte[] encoded = new byte[total];
        int index = 0;
        for (byte[] element : bytes) {
            System.arraycopy(element, 0, encoded, index, element.length);
            index += element.length;
        }
        return encoded;
    }
}

