/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.compress.compressors.zstandard;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.ZstdInputStream;
import eos.moe.dragoncore.lib.apache.compress.compressors.CompressorInputStream;
import eos.moe.dragoncore.lib.apache.compress.utils.InputStreamStatistics;
import eos.moe.dragoncore.lib.apache.io.IOUtils;
import eos.moe.dragoncore.lib.apache.io.input.BoundedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZstdCompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    private final BoundedInputStream countingStream;
    private final ZstdInputStream decIS;

    public ZstdCompressorInputStream(InputStream in2) throws IOException {
        this.countingStream = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(in2)).get();
        this.decIS = new ZstdInputStream((InputStream)this.countingStream);
    }

    public ZstdCompressorInputStream(InputStream in2, BufferPool bufferPool) throws IOException {
        this.countingStream = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(in2)).get();
        this.decIS = new ZstdInputStream((InputStream)this.countingStream, bufferPool);
    }

    @Override
    public int available() throws IOException {
        return this.decIS.available();
    }

    @Override
    public void close() throws IOException {
        this.decIS.close();
    }

    @Override
    public long getCompressedCount() {
        return this.countingStream.getCount();
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.decIS.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return this.decIS.markSupported();
    }

    @Override
    public int read() throws IOException {
        int ret = this.decIS.read();
        this.count(ret == -1 ? 0 : 1);
        return ret;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int ret = this.decIS.read(buf, off, len);
        this.count(ret);
        return ret;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.decIS.reset();
    }

    @Override
    public long skip(long n2) throws IOException {
        return IOUtils.skip((InputStream)this.decIS, n2);
    }

    public String toString() {
        return this.decIS.toString();
    }
}

