/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.compress.compressors.snappy;

import eos.moe.dragoncore.lib.apache.compress.compressors.lz77support.AbstractLZ77CompressorInputStream;
import eos.moe.dragoncore.lib.apache.compress.utils.ByteUtils;
import java.io.IOException;
import java.io.InputStream;

public class SnappyCompressorInputStream
extends AbstractLZ77CompressorInputStream {
    private static final int TAG_MASK = 3;
    public static final int DEFAULT_BLOCK_SIZE = 32768;
    private final int size;
    private int uncompressedBytesRemaining;
    private State state = State.NO_BLOCK;
    private boolean endReached;

    public SnappyCompressorInputStream(InputStream is2) throws IOException {
        this(is2, 32768);
    }

    public SnappyCompressorInputStream(InputStream is2, int blockSize) throws IOException {
        super(is2, blockSize);
        this.uncompressedBytesRemaining = this.size = (int)this.readSize();
    }

    private void fill() throws IOException {
        if (this.uncompressedBytesRemaining == 0) {
            this.endReached = true;
            return;
        }
        int b2 = this.readOneByte();
        if (b2 == -1) {
            throw new IOException("Premature end of stream reading block start");
        }
        int length = 0;
        int offset = 0;
        switch (b2 & 3) {
            case 0: {
                length = this.readLiteralLength(b2);
                if (length < 0) {
                    throw new IOException("Illegal block with a negative literal size found");
                }
                this.uncompressedBytesRemaining -= length;
                this.startLiteral(length);
                this.state = State.IN_LITERAL;
                break;
            }
            case 1: {
                length = 4 + (b2 >> 2 & 7);
                this.uncompressedBytesRemaining -= length;
                offset = (b2 & 0xE0) << 3;
                b2 = this.readOneByte();
                if (b2 == -1) {
                    throw new IOException("Premature end of stream reading back-reference length");
                }
                offset |= b2;
                try {
                    this.startBackReference(offset, length);
                }
                catch (IllegalArgumentException ex2) {
                    throw new IOException("Illegal block with bad offset found", ex2);
                }
                this.state = State.IN_BACK_REFERENCE;
                break;
            }
            case 2: {
                length = (b2 >> 2) + 1;
                if (length < 0) {
                    throw new IOException("Illegal block with a negative match length found");
                }
                this.uncompressedBytesRemaining -= length;
                offset = (int)ByteUtils.fromLittleEndian(this.supplier, 2);
                try {
                    this.startBackReference(offset, length);
                }
                catch (IllegalArgumentException ex3) {
                    throw new IOException("Illegal block with bad offset found", ex3);
                }
                this.state = State.IN_BACK_REFERENCE;
                break;
            }
            case 3: {
                length = (b2 >> 2) + 1;
                if (length < 0) {
                    throw new IOException("Illegal block with a negative match length found");
                }
                this.uncompressedBytesRemaining -= length;
                offset = (int)ByteUtils.fromLittleEndian(this.supplier, 4) & Integer.MAX_VALUE;
                try {
                    this.startBackReference(offset, length);
                }
                catch (IllegalArgumentException ex4) {
                    throw new IOException("Illegal block with bad offset found", ex4);
                }
                this.state = State.IN_BACK_REFERENCE;
                break;
            }
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.endReached) {
            return -1;
        }
        switch (this.state) {
            case NO_BLOCK: {
                this.fill();
                return this.read(b2, off, len);
            }
            case IN_LITERAL: {
                int litLen = this.readLiteral(b2, off, len);
                if (!this.hasMoreDataInBlock()) {
                    this.state = State.NO_BLOCK;
                }
                return litLen > 0 ? litLen : this.read(b2, off, len);
            }
            case IN_BACK_REFERENCE: {
                int backReferenceLen = this.readBackReference(b2, off, len);
                if (!this.hasMoreDataInBlock()) {
                    this.state = State.NO_BLOCK;
                }
                return backReferenceLen > 0 ? backReferenceLen : this.read(b2, off, len);
            }
        }
        throw new IOException("Unknown stream state " + (Object)((Object)this.state));
    }

    private int readLiteralLength(int b2) throws IOException {
        int length;
        switch (b2 >> 2) {
            case 60: {
                length = this.readOneByte();
                if (length != -1) break;
                throw new IOException("Premature end of stream reading literal length");
            }
            case 61: {
                length = (int)ByteUtils.fromLittleEndian(this.supplier, 2);
                break;
            }
            case 62: {
                length = (int)ByteUtils.fromLittleEndian(this.supplier, 3);
                break;
            }
            case 63: {
                length = (int)ByteUtils.fromLittleEndian(this.supplier, 4);
                break;
            }
            default: {
                length = b2 >> 2;
            }
        }
        return length + 1;
    }

    private long readSize() throws IOException {
        int index = 0;
        long sz2 = 0L;
        int b2 = 0;
        do {
            if ((b2 = this.readOneByte()) == -1) {
                throw new IOException("Premature end of stream reading size");
            }
            sz2 |= (long)((b2 & 0x7F) << index++ * 7);
        } while (0 != (b2 & 0x80));
        return sz2;
    }

    private static enum State {
        NO_BLOCK,
        IN_LITERAL,
        IN_BACK_REFERENCE;

    }
}

