/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.compress.compressors.pack200;

import eos.moe.dragoncore.lib.apache.compress.compressors.CompressorOutputStream;
import eos.moe.dragoncore.lib.apache.compress.compressors.pack200.AbstractStreamBridge;
import eos.moe.dragoncore.lib.apache.compress.compressors.pack200.Pack200Strategy;
import eos.moe.dragoncore.lib.apache.compress.java.util.jar.Pack200;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.JarInputStream;

public class Pack200CompressorOutputStream
extends CompressorOutputStream<OutputStream> {
    private boolean finished;
    private final AbstractStreamBridge abstractStreamBridge;
    private final Map<String, String> properties;

    public Pack200CompressorOutputStream(OutputStream out) throws IOException {
        this(out, Pack200Strategy.IN_MEMORY);
    }

    public Pack200CompressorOutputStream(OutputStream out, Map<String, String> props) throws IOException {
        this(out, Pack200Strategy.IN_MEMORY, props);
    }

    public Pack200CompressorOutputStream(OutputStream out, Pack200Strategy mode) throws IOException {
        this(out, mode, null);
    }

    public Pack200CompressorOutputStream(OutputStream out, Pack200Strategy mode, Map<String, String> props) throws IOException {
        super(out);
        this.abstractStreamBridge = mode.newStreamBridge();
        this.properties = props;
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            try {
                this.abstractStreamBridge.stop();
            }
            finally {
                this.out.close();
            }
        }
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.finished = true;
            Pack200.Packer p2 = Pack200.newPacker();
            if (this.properties != null) {
                p2.properties().putAll(this.properties);
            }
            try (JarInputStream ji2 = new JarInputStream(this.abstractStreamBridge.getInputStream());){
                p2.pack(ji2, this.out);
            }
        }
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.abstractStreamBridge.write(b2);
    }

    @Override
    public void write(byte[] b2, int from, int length) throws IOException {
        this.abstractStreamBridge.write(b2, from, length);
    }

    @Override
    public void write(int b2) throws IOException {
        this.abstractStreamBridge.write(b2);
    }
}

