/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.compress.compressors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FileNameUtil {
    private final Map<String, String> compressSuffix = new HashMap<String, String>();
    private final Map<String, String> uncompressSuffix;
    private final int longestCompressedSuffix;
    private final int shortestCompressedSuffix;
    private final int longestUncompressedSuffix;
    private final int shortestUncompressedSuffix;
    private final String defaultExtension;

    public FileNameUtil(Map<String, String> uncompressSuffix, String defaultExtension) {
        this.uncompressSuffix = Collections.unmodifiableMap(uncompressSuffix);
        int lc2 = Integer.MIN_VALUE;
        int sc2 = Integer.MAX_VALUE;
        int lu2 = Integer.MIN_VALUE;
        int su2 = Integer.MAX_VALUE;
        for (Map.Entry<String, String> ent : uncompressSuffix.entrySet()) {
            String u2;
            int ul2;
            int cl2 = ent.getKey().length();
            if (cl2 > lc2) {
                lc2 = cl2;
            }
            if (cl2 < sc2) {
                sc2 = cl2;
            }
            if ((ul2 = (u2 = ent.getValue()).length()) <= 0) continue;
            this.compressSuffix.computeIfAbsent(u2, k2 -> (String)ent.getKey());
            if (ul2 > lu2) {
                lu2 = ul2;
            }
            if (ul2 >= su2) continue;
            su2 = ul2;
        }
        this.longestCompressedSuffix = lc2;
        this.longestUncompressedSuffix = lu2;
        this.shortestCompressedSuffix = sc2;
        this.shortestUncompressedSuffix = su2;
        this.defaultExtension = defaultExtension;
    }

    @Deprecated
    public String getCompressedFilename(String fileName) {
        return this.getCompressedFileName(fileName);
    }

    public String getCompressedFileName(String fileName) {
        String lower = fileName.toLowerCase(Locale.ROOT);
        int n2 = lower.length();
        for (int i2 = this.shortestUncompressedSuffix; i2 <= this.longestUncompressedSuffix && i2 < n2; ++i2) {
            String suffix = this.compressSuffix.get(lower.substring(n2 - i2));
            if (suffix == null) continue;
            return fileName.substring(0, n2 - i2) + suffix;
        }
        return fileName + this.defaultExtension;
    }

    @Deprecated
    public String getUncompressedFilename(String fileName) {
        return this.getUncompressedFileName(fileName);
    }

    public String getUncompressedFileName(String fileName) {
        String lower = fileName.toLowerCase(Locale.ROOT);
        int n2 = lower.length();
        for (int i2 = this.shortestCompressedSuffix; i2 <= this.longestCompressedSuffix && i2 < n2; ++i2) {
            String suffix = this.uncompressSuffix.get(lower.substring(n2 - i2));
            if (suffix == null) continue;
            return fileName.substring(0, n2 - i2) + suffix;
        }
        return fileName;
    }

    @Deprecated
    public boolean isCompressedFilename(String fileName) {
        return this.isCompressedFileName(fileName);
    }

    public boolean isCompressedFileName(String fileName) {
        String lower = fileName.toLowerCase(Locale.ROOT);
        int n2 = lower.length();
        for (int i2 = this.shortestCompressedSuffix; i2 <= this.longestCompressedSuffix && i2 < n2; ++i2) {
            if (!this.uncompressSuffix.containsKey(lower.substring(n2 - i2))) continue;
            return true;
        }
        return false;
    }
}

