/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.compress.changes;

import eos.moe.dragoncore.lib.apache.compress.archivers.ArchiveEntry;
import eos.moe.dragoncore.lib.apache.compress.changes.Change;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class ChangeSet<E extends ArchiveEntry> {
    private final Set<Change<E>> changes = new LinkedHashSet<Change<E>>();

    public void add(E entry, InputStream input) {
        this.add(entry, input, true);
    }

    public void add(E entry, InputStream input, boolean replace) {
        this.addAddition(new Change<E>(entry, input, replace));
    }

    private void addAddition(Change<E> addChange) {
        if (Change.ChangeType.ADD != addChange.getType() || addChange.getInputStream() == null) {
            return;
        }
        if (!this.changes.isEmpty()) {
            Iterator<Change<E>> it2 = this.changes.iterator();
            while (it2.hasNext()) {
                E entry;
                Change<E> change = it2.next();
                if (change.getType() != Change.ChangeType.ADD || change.getEntry() == null || !(entry = change.getEntry()).equals(addChange.getEntry())) continue;
                if (addChange.isReplaceMode()) {
                    it2.remove();
                    this.changes.add(addChange);
                }
                return;
            }
        }
        this.changes.add(addChange);
    }

    private void addDeletion(Change<E> deleteChange) {
        if (Change.ChangeType.DELETE != deleteChange.getType() && Change.ChangeType.DELETE_DIR != deleteChange.getType() || deleteChange.getTargetFileName() == null) {
            return;
        }
        String source = deleteChange.getTargetFileName();
        Pattern pattern = Pattern.compile(source + "/.*");
        if (source != null && !this.changes.isEmpty()) {
            Iterator<Change<E>> it2 = this.changes.iterator();
            while (it2.hasNext()) {
                String target;
                Change<E> change = it2.next();
                if (change.getType() != Change.ChangeType.ADD || change.getEntry() == null || (target = change.getEntry().getName()) == null || (Change.ChangeType.DELETE != deleteChange.getType() || !source.equals(target)) && (Change.ChangeType.DELETE_DIR != deleteChange.getType() || !pattern.matcher(target).matches())) continue;
                it2.remove();
            }
        }
        this.changes.add(deleteChange);
    }

    public void delete(String fileName) {
        this.addDeletion(new Change(fileName, Change.ChangeType.DELETE));
    }

    public void deleteDir(String dirName) {
        this.addDeletion(new Change(dirName, Change.ChangeType.DELETE_DIR));
    }

    Set<Change<E>> getChanges() {
        return new LinkedHashSet<Change<E>>(this.changes);
    }
}

