/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.compress.archivers.sevenz;

import eos.moe.dragoncore.lib.apache.compress.MemoryLimitException;
import eos.moe.dragoncore.lib.apache.compress.archivers.sevenz.AbstractCoder;
import eos.moe.dragoncore.lib.apache.compress.archivers.sevenz.Coder;
import eos.moe.dragoncore.lib.xz.FinishableWrapperOutputStream;
import eos.moe.dragoncore.lib.xz.LZMA2InputStream;
import eos.moe.dragoncore.lib.xz.LZMA2Options;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class LZMA2Decoder
extends AbstractCoder {
    LZMA2Decoder() {
        super(LZMA2Options.class, Number.class);
    }

    @Override
    InputStream decode(String archiveName, InputStream in2, long uncompressedLength, Coder coder, byte[] password, int maxMemoryLimitInKb) throws IOException {
        try {
            int dictionarySize = this.getDictionarySize(coder);
            int memoryUsageInKb = LZMA2InputStream.getMemoryUsage(dictionarySize);
            if (memoryUsageInKb > maxMemoryLimitInKb) {
                throw new MemoryLimitException(memoryUsageInKb, maxMemoryLimitInKb);
            }
            return new LZMA2InputStream(in2, dictionarySize);
        }
        catch (IllegalArgumentException ex2) {
            throw new IOException(ex2);
        }
    }

    @Override
    OutputStream encode(OutputStream out, Object opts) throws IOException {
        return this.getOptions(opts).getOutputStream(new FinishableWrapperOutputStream(out));
    }

    private int getDictionarySize(Coder coder) throws IOException {
        if (coder.properties == null) {
            throw new IOException("Missing LZMA2 properties");
        }
        if (coder.properties.length < 1) {
            throw new IOException("LZMA2 properties too short");
        }
        int dictionarySizeBits = 0xFF & coder.properties[0];
        if ((dictionarySizeBits & 0xFFFFFFC0) != 0) {
            throw new IOException("Unsupported LZMA2 property bits");
        }
        if (dictionarySizeBits > 40) {
            throw new IOException("Dictionary larger than 4GiB maximum size");
        }
        if (dictionarySizeBits == 40) {
            return -1;
        }
        return (2 | dictionarySizeBits & 1) << dictionarySizeBits / 2 + 11;
    }

    private int getDictSize(Object opts) {
        if (opts instanceof LZMA2Options) {
            return ((LZMA2Options)opts).getDictSize();
        }
        return this.numberOptionOrDefault(opts);
    }

    private LZMA2Options getOptions(Object opts) throws IOException {
        if (opts instanceof LZMA2Options) {
            return (LZMA2Options)opts;
        }
        LZMA2Options options = new LZMA2Options();
        options.setDictSize(this.numberOptionOrDefault(opts));
        return options;
    }

    @Override
    byte[] getOptionsAsProperties(Object opts) {
        int dictSize = this.getDictSize(opts);
        int lead = Integer.numberOfLeadingZeros(dictSize);
        int secondBit = (dictSize >>> 30 - lead) - 2;
        return new byte[]{(byte)((19 - lead) * 2 + secondBit)};
    }

    @Override
    Object getOptionsFromCoder(Coder coder, InputStream in2) throws IOException {
        return this.getDictionarySize(coder);
    }

    private int numberOptionOrDefault(Object opts) {
        return LZMA2Decoder.toInt(opts, 0x800000);
    }
}

