/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.compress.archivers.sevenz;

import eos.moe.dragoncore.lib.apache.compress.archivers.sevenz.AbstractCoder;
import eos.moe.dragoncore.lib.apache.compress.archivers.sevenz.Coder;
import eos.moe.dragoncore.lib.xz.DeltaOptions;
import eos.moe.dragoncore.lib.xz.FinishableWrapperOutputStream;
import eos.moe.dragoncore.lib.xz.UnsupportedOptionsException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class DeltaDecoder
extends AbstractCoder {
    DeltaDecoder() {
        super(Number.class);
    }

    @Override
    InputStream decode(String archiveName, InputStream in2, long uncompressedLength, Coder coder, byte[] password, int maxMemoryLimitInKb) throws IOException {
        return new DeltaOptions(this.getOptionsFromCoder(coder)).getInputStream(in2);
    }

    @Override
    OutputStream encode(OutputStream out, Object options) throws IOException {
        int distance = DeltaDecoder.toInt(options, 1);
        try {
            return new DeltaOptions(distance).getOutputStream(new FinishableWrapperOutputStream(out));
        }
        catch (UnsupportedOptionsException ex2) {
            throw new IOException(ex2.getMessage());
        }
    }

    @Override
    byte[] getOptionsAsProperties(Object options) {
        return new byte[]{(byte)(DeltaDecoder.toInt(options, 1) - 1)};
    }

    private int getOptionsFromCoder(Coder coder) {
        if (coder.properties == null || coder.properties.length == 0) {
            return 1;
        }
        return (0xFF & coder.properties[0]) + 1;
    }

    @Override
    Object getOptionsFromCoder(Coder coder, InputStream in2) {
        return this.getOptionsFromCoder(coder);
    }
}

