/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.compress.archivers.sevenz;

import eos.moe.dragoncore.lib.apache.compress.archivers.sevenz.AES256SHA256Decoder;
import eos.moe.dragoncore.lib.apache.compress.archivers.sevenz.AbstractCoder;
import eos.moe.dragoncore.lib.apache.compress.archivers.sevenz.Coder;
import eos.moe.dragoncore.lib.apache.compress.archivers.sevenz.DeltaDecoder;
import eos.moe.dragoncore.lib.apache.compress.archivers.sevenz.LZMA2Decoder;
import eos.moe.dragoncore.lib.apache.compress.archivers.sevenz.LZMADecoder;
import eos.moe.dragoncore.lib.apache.compress.archivers.sevenz.SevenZMethod;
import eos.moe.dragoncore.lib.apache.compress.compressors.bzip2.BZip2CompressorInputStream;
import eos.moe.dragoncore.lib.apache.compress.compressors.bzip2.BZip2CompressorOutputStream;
import eos.moe.dragoncore.lib.apache.compress.compressors.deflate64.Deflate64CompressorInputStream;
import eos.moe.dragoncore.lib.apache.compress.utils.FlushShieldFilterOutputStream;
import eos.moe.dragoncore.lib.xz.ARMOptions;
import eos.moe.dragoncore.lib.xz.ARMThumbOptions;
import eos.moe.dragoncore.lib.xz.FilterOptions;
import eos.moe.dragoncore.lib.xz.FinishableWrapperOutputStream;
import eos.moe.dragoncore.lib.xz.IA64Options;
import eos.moe.dragoncore.lib.xz.PowerPCOptions;
import eos.moe.dragoncore.lib.xz.SPARCOptions;
import eos.moe.dragoncore.lib.xz.X86Options;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

final class Coders {
    private static final Map<SevenZMethod, AbstractCoder> CODER_MAP = new HashMap<SevenZMethod, AbstractCoder>(){
        private static final long serialVersionUID = 1664829131806520867L;
        {
            this.put(SevenZMethod.COPY, new CopyDecoder());
            this.put(SevenZMethod.LZMA, new LZMADecoder());
            this.put(SevenZMethod.LZMA2, new LZMA2Decoder());
            this.put(SevenZMethod.DEFLATE, new DeflateDecoder());
            this.put(SevenZMethod.DEFLATE64, new Deflate64Decoder());
            this.put(SevenZMethod.BZIP2, new BZIP2Decoder());
            this.put(SevenZMethod.AES256SHA256, new AES256SHA256Decoder());
            this.put(SevenZMethod.BCJ_X86_FILTER, new BCJDecoder(new X86Options()));
            this.put(SevenZMethod.BCJ_PPC_FILTER, new BCJDecoder(new PowerPCOptions()));
            this.put(SevenZMethod.BCJ_IA64_FILTER, new BCJDecoder(new IA64Options()));
            this.put(SevenZMethod.BCJ_ARM_FILTER, new BCJDecoder(new ARMOptions()));
            this.put(SevenZMethod.BCJ_ARM_THUMB_FILTER, new BCJDecoder(new ARMThumbOptions()));
            this.put(SevenZMethod.BCJ_SPARC_FILTER, new BCJDecoder(new SPARCOptions()));
            this.put(SevenZMethod.DELTA_FILTER, new DeltaDecoder());
        }
    };

    Coders() {
    }

    static InputStream addDecoder(String archiveName, InputStream is2, long uncompressedLength, Coder coder, byte[] password, int maxMemoryLimitInKb) throws IOException {
        AbstractCoder cb2 = Coders.findByMethod(SevenZMethod.byId(coder.decompressionMethodId));
        if (cb2 == null) {
            throw new IOException("Unsupported compression method " + Arrays.toString(coder.decompressionMethodId) + " used in " + archiveName);
        }
        return cb2.decode(archiveName, is2, uncompressedLength, coder, password, maxMemoryLimitInKb);
    }

    static OutputStream addEncoder(OutputStream out, SevenZMethod method, Object options) throws IOException {
        AbstractCoder cb2 = Coders.findByMethod(method);
        if (cb2 == null) {
            throw new IOException("Unsupported compression method " + (Object)((Object)method));
        }
        return cb2.encode(out, options);
    }

    static AbstractCoder findByMethod(SevenZMethod method) {
        return CODER_MAP.get((Object)method);
    }

    static class DeflateDecoder
    extends AbstractCoder {
        private static final byte[] ONE_ZERO_BYTE = new byte[1];

        DeflateDecoder() {
            super(Number.class);
        }

        @Override
        InputStream decode(String archiveName, InputStream in2, long uncompressedLength, Coder coder, byte[] password, int maxMemoryLimitInKb) throws IOException {
            Inflater inflater = new Inflater(true);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(new SequenceInputStream(in2, new ByteArrayInputStream(ONE_ZERO_BYTE)), inflater);
            return new DeflateDecoderInputStream(inflaterInputStream, inflater);
        }

        @Override
        OutputStream encode(OutputStream out, Object options) {
            int level = DeflateDecoder.toInt(options, 9);
            Deflater deflater = new Deflater(level, true);
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(out, deflater);
            return new DeflateDecoderOutputStream(deflaterOutputStream, deflater);
        }

        static class DeflateDecoderInputStream
        extends FilterInputStream {
            Inflater inflater;

            DeflateDecoderInputStream(InflaterInputStream inflaterInputStream, Inflater inflater) {
                super(inflaterInputStream);
                this.inflater = inflater;
            }

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    this.inflater.end();
                }
            }
        }

        static class DeflateDecoderOutputStream
        extends OutputStream {
            final DeflaterOutputStream deflaterOutputStream;
            Deflater deflater;

            DeflateDecoderOutputStream(DeflaterOutputStream deflaterOutputStream, Deflater deflater) {
                this.deflaterOutputStream = deflaterOutputStream;
                this.deflater = deflater;
            }

            @Override
            public void close() throws IOException {
                try {
                    this.deflaterOutputStream.close();
                }
                finally {
                    this.deflater.end();
                }
            }

            @Override
            public void write(byte[] b2) throws IOException {
                this.deflaterOutputStream.write(b2);
            }

            @Override
            public void write(byte[] b2, int off, int len) throws IOException {
                this.deflaterOutputStream.write(b2, off, len);
            }

            @Override
            public void write(int b2) throws IOException {
                this.deflaterOutputStream.write(b2);
            }
        }
    }

    static class Deflate64Decoder
    extends AbstractCoder {
        Deflate64Decoder() {
            super(Number.class);
        }

        @Override
        InputStream decode(String archiveName, InputStream in2, long uncompressedLength, Coder coder, byte[] password, int maxMemoryLimitInKb) throws IOException {
            return new Deflate64CompressorInputStream(in2);
        }
    }

    static class CopyDecoder
    extends AbstractCoder {
        CopyDecoder() {
            super(new Class[0]);
        }

        @Override
        InputStream decode(String archiveName, InputStream in2, long uncompressedLength, Coder coder, byte[] password, int maxMemoryLimitInKb) throws IOException {
            return in2;
        }

        @Override
        OutputStream encode(OutputStream out, Object options) {
            return out;
        }
    }

    static class BZIP2Decoder
    extends AbstractCoder {
        BZIP2Decoder() {
            super(Number.class);
        }

        @Override
        InputStream decode(String archiveName, InputStream in2, long uncompressedLength, Coder coder, byte[] password, int maxMemoryLimitInKb) throws IOException {
            return new BZip2CompressorInputStream(in2);
        }

        @Override
        OutputStream encode(OutputStream out, Object options) throws IOException {
            int blockSize = BZIP2Decoder.toInt(options, 9);
            return new BZip2CompressorOutputStream(out, blockSize);
        }
    }

    static class BCJDecoder
    extends AbstractCoder {
        private final FilterOptions opts;

        BCJDecoder(FilterOptions opts) {
            super(new Class[0]);
            this.opts = opts;
        }

        @Override
        InputStream decode(String archiveName, InputStream in2, long uncompressedLength, Coder coder, byte[] password, int maxMemoryLimitInKb) throws IOException {
            try {
                return this.opts.getInputStream(in2);
            }
            catch (AssertionError e2) {
                throw new IOException("BCJ filter used in " + archiveName + " needs XZ for Java > 1.4 - see https://commons.apache.org/proper/commons-compress/limitations.html#7Z", (Throwable)((Object)e2));
            }
        }

        @Override
        OutputStream encode(OutputStream out, Object options) {
            return new FlushShieldFilterOutputStream(this.opts.getOutputStream(new FinishableWrapperOutputStream(out)));
        }
    }
}

