/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.apache.codec.net;

import eos.moe.dragoncore.lib.apache.codec.BinaryDecoder;
import eos.moe.dragoncore.lib.apache.codec.BinaryEncoder;
import eos.moe.dragoncore.lib.apache.codec.DecoderException;
import eos.moe.dragoncore.lib.apache.codec.EncoderException;
import eos.moe.dragoncore.lib.apache.codec.net.Utils;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class PercentCodec
implements BinaryEncoder,
BinaryDecoder {
    private static final byte ESCAPE_CHAR = 37;
    private final BitSet alwaysEncodeChars = new BitSet();
    private final boolean plusForSpace;
    private int alwaysEncodeCharsMin = Integer.MAX_VALUE;
    private int alwaysEncodeCharsMax = Integer.MIN_VALUE;

    public PercentCodec() {
        this.plusForSpace = false;
        this.insertAlwaysEncodeChar((byte)37);
    }

    public PercentCodec(byte[] alwaysEncodeChars, boolean plusForSpace) {
        this.plusForSpace = plusForSpace;
        this.insertAlwaysEncodeChars(alwaysEncodeChars);
    }

    private boolean canEncode(byte c2) {
        return !this.isAsciiChar(c2) || this.inAlwaysEncodeCharsRange(c2) && this.alwaysEncodeChars.get(c2);
    }

    private boolean containsSpace(byte[] bytes) {
        for (byte b2 : bytes) {
            if (b2 != 32) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] decode(byte[] bytes) throws DecoderException {
        if (bytes == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.expectedDecodingBytes(bytes));
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            byte b2 = bytes[i2];
            if (b2 == 37) {
                try {
                    int u2 = Utils.digit16(bytes[++i2]);
                    int l2 = Utils.digit16(bytes[++i2]);
                    buffer.put((byte)((u2 << 4) + l2));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e2) {
                    throw new DecoderException("Invalid percent decoding: ", e2);
                }
            }
            if (this.plusForSpace && b2 == 43) {
                buffer.put((byte)32);
                continue;
            }
            buffer.put(b2);
        }
        return buffer.array();
    }

    @Override
    public Object decode(Object obj) throws DecoderException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return this.decode((byte[])obj);
        }
        throw new DecoderException("Objects of type " + obj.getClass().getName() + " cannot be Percent decoded");
    }

    private byte[] doEncode(byte[] bytes, int expectedLength, boolean willEncode) {
        ByteBuffer buffer = ByteBuffer.allocate(expectedLength);
        for (byte b2 : bytes) {
            if (willEncode && this.canEncode(b2)) {
                byte bb2 = b2;
                if (bb2 < 0) {
                    bb2 = (byte)(256 + bb2);
                }
                char hex1 = Utils.hexDigit(bb2 >> 4);
                char hex2 = Utils.hexDigit(bb2);
                buffer.put((byte)37);
                buffer.put((byte)hex1);
                buffer.put((byte)hex2);
                continue;
            }
            if (this.plusForSpace && b2 == 32) {
                buffer.put((byte)43);
                continue;
            }
            buffer.put(b2);
        }
        return buffer.array();
    }

    @Override
    public byte[] encode(byte[] bytes) throws EncoderException {
        boolean willEncode;
        if (bytes == null) {
            return null;
        }
        int expectedEncodingBytes = this.expectedEncodingBytes(bytes);
        boolean bl2 = willEncode = expectedEncodingBytes != bytes.length;
        if (willEncode || this.plusForSpace && this.containsSpace(bytes)) {
            return this.doEncode(bytes, expectedEncodingBytes, willEncode);
        }
        return bytes;
    }

    @Override
    public Object encode(Object obj) throws EncoderException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return this.encode((byte[])obj);
        }
        throw new EncoderException("Objects of type " + obj.getClass().getName() + " cannot be Percent encoded");
    }

    private int expectedDecodingBytes(byte[] bytes) {
        int byteCount = 0;
        int i2 = 0;
        while (i2 < bytes.length) {
            byte b2;
            i2 += (b2 = bytes[i2]) == 37 ? 3 : 1;
            ++byteCount;
        }
        return byteCount;
    }

    private int expectedEncodingBytes(byte[] bytes) {
        int byteCount = 0;
        for (byte b2 : bytes) {
            byteCount += this.canEncode(b2) ? 3 : 1;
        }
        return byteCount;
    }

    private boolean inAlwaysEncodeCharsRange(byte c2) {
        return c2 >= this.alwaysEncodeCharsMin && c2 <= this.alwaysEncodeCharsMax;
    }

    private void insertAlwaysEncodeChar(byte b2) {
        if (b2 < 0) {
            throw new IllegalArgumentException("byte must be >= 0");
        }
        this.alwaysEncodeChars.set(b2);
        if (b2 < this.alwaysEncodeCharsMin) {
            this.alwaysEncodeCharsMin = b2;
        }
        if (b2 > this.alwaysEncodeCharsMax) {
            this.alwaysEncodeCharsMax = b2;
        }
    }

    private void insertAlwaysEncodeChars(byte[] alwaysEncodeCharsArray) {
        if (alwaysEncodeCharsArray != null) {
            for (byte b2 : alwaysEncodeCharsArray) {
                this.insertAlwaysEncodeChar(b2);
            }
        }
        this.insertAlwaysEncodeChar((byte)37);
    }

    private boolean isAsciiChar(byte c2) {
        return c2 >= 0;
    }
}

