/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityUtils {
    public static Entity entityByUUID(World world, String id) {
        return EntityUtils.entityByUUID(world, UUID.fromString(id));
    }

    public static Entity entityByUUID(World world, UUID target) {
        for (Entity entity : world.field_72996_f) {
            if (!entity.func_110124_au().equals(target)) continue;
            return entity;
        }
        return null;
    }

    public static Entity getTargetEntity(Entity input, double maxReach) {
        double blockDistance = maxReach;
        RayTraceResult result = input.func_174822_a(maxReach, 1.0f);
        Vec3d eyes = input.func_174824_e(1.0f);
        if (result != null) {
            blockDistance = result.field_72307_f.func_72438_d(eyes);
        }
        Vec3d look = input.func_70676_i(1.0f);
        Vec3d max = eyes.func_72441_c(look.field_72450_a * maxReach, look.field_72448_b * maxReach, look.field_72449_c * maxReach);
        Entity target = null;
        float area = 1.0f;
        List list = input.field_70170_p.func_175674_a(input, input.func_174813_aQ().func_72321_a(look.field_72450_a * maxReach, look.field_72448_b * maxReach, look.field_72449_c * maxReach).func_72314_b((double)area, (double)area, (double)area), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity != null && entity.func_70067_L();
            }
        }));
        double entityDistance = blockDistance;
        for (int i = 0; i < list.size(); ++i) {
            double eyesDistance;
            Entity entity = (Entity)list.get(i);
            if (entity == input) continue;
            AxisAlignedBB aabb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            RayTraceResult intercept = aabb.func_72327_a(eyes, max);
            if (aabb.func_72318_a(eyes)) {
                if (!(entityDistance >= 0.0)) continue;
                target = entity;
                entityDistance = 0.0;
                continue;
            }
            if (intercept == null || !((eyesDistance = eyes.func_72438_d(intercept.field_72307_f)) < entityDistance) && entityDistance != 0.0) continue;
            if (entity.func_184208_bv() == input.func_184208_bv() && !input.canRiderInteract()) {
                if (entityDistance != 0.0) continue;
                target = entity;
                continue;
            }
            target = entity;
            entityDistance = eyesDistance;
        }
        return target;
    }
}

