/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntitySelector {
    private static final Pattern TOKEN_PATTERN = Pattern.compile("^@([pare])(?:\\[([^ ]*)\\])?$");
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings();
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);
    private static final Set<String> VALID_ARGUMENTS = Sets.newHashSet();
    private static final String ARGUMENT_RANGE_MAX = EntitySelector.addArgument("r");
    private static final String ARGUMENT_RANGE_MIN = EntitySelector.addArgument("rm");
    private static final String ARGUMENT_LEVEL_MAX = EntitySelector.addArgument("l");
    private static final String ARGUMENT_LEVEL_MIN = EntitySelector.addArgument("lm");
    private static final String ARGUMENT_COORDINATE_X = EntitySelector.addArgument("x");
    private static final String ARGUMENT_COORDINATE_Y = EntitySelector.addArgument("y");
    private static final String ARGUMENT_COORDINATE_Z = EntitySelector.addArgument("z");
    private static final String ARGUMENT_DELTA_X = EntitySelector.addArgument("dx");
    private static final String ARGUMENT_DELTA_Y = EntitySelector.addArgument("dy");
    private static final String ARGUMENT_DELTA_Z = EntitySelector.addArgument("dz");
    private static final String ARGUMENT_ROTX_MAX = EntitySelector.addArgument("rx");
    private static final String ARGUMENT_ROTX_MIN = EntitySelector.addArgument("rxm");
    private static final String ARGUMENT_ROTY_MAX = EntitySelector.addArgument("ry");
    private static final String ARGUMENT_ROTY_MIN = EntitySelector.addArgument("rym");
    private static final String ARGUMENT_COUNT = EntitySelector.addArgument("c");
    private static final String ARGUMENT_MODE = EntitySelector.addArgument("m");
    private static final String ARGUMENT_TEAM_NAME = EntitySelector.addArgument("team");
    private static final String ARGUMENT_PLAYER_NAME = EntitySelector.addArgument("name");
    private static final String ARGUMENT_ENTITY_TYPE = EntitySelector.addArgument("type");
    private static final String ARGUMENT_ENTITY_TAG = EntitySelector.addArgument("tag");
    private static final Predicate<String> IS_VALID_ARGUMENT = new Predicate<String>(){

        public boolean apply(@Nullable String p_apply_1_) {
            return p_apply_1_ != null && (VALID_ARGUMENTS.contains(p_apply_1_) || p_apply_1_.length() > "score_".length() && p_apply_1_.startsWith("score_"));
        }
    };

    private static String addArgument(String argument) {
        VALID_ARGUMENTS.add(argument);
        return argument;
    }

    @Nullable
    public static EntityPlayerMP matchOnePlayer(ICommandSender sender, String token) throws CommandException {
        return EntitySelector.matchOneEntity(sender, token, EntityPlayerMP.class);
    }

    @Nullable
    public static <T extends Entity> T matchOneEntity(ICommandSender sender, String token, Class<? extends T> targetClass) throws CommandException {
        List<T> list = EntitySelector.matchEntities(sender, token, targetClass);
        return (T)(list.isEmpty() ? null : (Entity)list.get(0));
    }

    public static <T extends Entity> List<T> matchEntities(ICommandSender sender, String token, Class<? extends T> targetClass) throws CommandException {
        Matcher matcher = TOKEN_PATTERN.matcher(token);
        if (matcher.matches()) {
            Map<String, String> map = EntitySelector.getArgumentMap(matcher.group(2));
            if (!EntitySelector.isEntityTypeValid(sender, map)) {
                return Collections.emptyList();
            }
            String s = matcher.group(1);
            BlockPos blockpos = EntitySelector.getBlockPosFromArguments(map, sender.func_180425_c());
            Vec3d vec3d = EntitySelector.getPosFromArguments(map, sender.func_174791_d());
            ArrayList list1 = Lists.newArrayList();
            World world = sender.func_130014_f_();
            if (world != null) {
                ArrayList list2 = Lists.newArrayList();
                list2.addAll(EntitySelector.getTypePredicates(map, s));
                list2.addAll(EntitySelector.getXpLevelPredicates(map));
                list2.addAll(EntitySelector.getGamemodePredicates(map));
                list2.addAll(EntitySelector.getTeamPredicates(map));
                list2.addAll(EntitySelector.getNamePredicates(map));
                list2.addAll(EntitySelector.getTagPredicates(map));
                list2.addAll(EntitySelector.getRadiusPredicates(map, vec3d));
                list2.addAll(EntitySelector.getRotationsPredicates(map));
                list2.addAll(GameRegistry.createEntitySelectors(map, (String)s, (ICommandSender)sender, (Vec3d)vec3d));
                list1.addAll(EntitySelector.filterResults(map, targetClass, list2, s, world, blockpos));
            }
            return EntitySelector.getEntitiesFromPredicates(list1, map, sender, targetClass, s, vec3d);
        }
        return Collections.emptyList();
    }

    private static <T extends Entity> boolean isEntityTypeValid(ICommandSender commandSender, Map<String, String> params) {
        String s = EntitySelector.getArgument(params, ARGUMENT_ENTITY_TYPE);
        if (s == null) {
            return true;
        }
        ResourceLocation resourcelocation = new ResourceLocation(s.startsWith("!") ? s.substring(1) : s);
        if (EntityList.func_180125_b((ResourceLocation)resourcelocation)) {
            return true;
        }
        TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("commands.generic.entity.invalidType", new Object[]{resourcelocation});
        textcomponenttranslation.func_150256_b().func_150238_a(TextFormatting.RED);
        commandSender.func_145747_a((ITextComponent)textcomponenttranslation);
        return false;
    }

    private static List<Predicate<Entity>> getTypePredicates(Map<String, String> params, String type) {
        String s = EntitySelector.getArgument(params, ARGUMENT_ENTITY_TYPE);
        if (s == null || !type.equals("e") && !type.equals("r")) {
            return !type.equals("e") ? Collections.singletonList(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    return p_apply_1_ instanceof EntityPlayer;
                }
            }) : Collections.emptyList();
        }
        final boolean flag = s.startsWith("!");
        final ResourceLocation resourcelocation = new ResourceLocation(flag ? s.substring(1) : s);
        return Collections.singletonList(new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                return EntityList.func_180123_a((Entity)p_apply_1_, (ResourceLocation)resourcelocation) != flag;
            }
        });
    }

    private static List<Predicate<Entity>> getXpLevelPredicates(Map<String, String> params) {
        ArrayList list = Lists.newArrayList();
        final int i = EntitySelector.getInt(params, ARGUMENT_LEVEL_MIN, -1);
        final int j = EntitySelector.getInt(params, ARGUMENT_LEVEL_MAX, -1);
        if (i > -1 || j > -1) {
            list.add(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    if (!(p_apply_1_ instanceof EntityPlayerMP)) {
                        return false;
                    }
                    EntityPlayerMP entityplayermp = (EntityPlayerMP)p_apply_1_;
                    return !(i > -1 && entityplayermp.field_71068_ca < i || j > -1 && entityplayermp.field_71068_ca > j);
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getGamemodePredicates(Map<String, String> params) {
        GameType gametype;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(params, ARGUMENT_MODE);
        if (s == null) {
            return list;
        }
        final boolean flag = s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        try {
            int i = Integer.parseInt(s);
            gametype = GameType.func_185329_a((int)i, (GameType)GameType.NOT_SET);
        }
        catch (Throwable var6) {
            gametype = GameType.func_185328_a((String)s, (GameType)GameType.NOT_SET);
        }
        final GameType type = gametype;
        list.add(new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                if (!(p_apply_1_ instanceof EntityPlayerMP)) {
                    return false;
                }
                EntityPlayerMP entityplayermp = (EntityPlayerMP)p_apply_1_;
                GameType gametype1 = entityplayermp.field_71134_c.func_73081_b();
                return flag ? gametype1 != type : gametype1 == type;
            }
        });
        return list;
    }

    private static List<Predicate<Entity>> getTeamPredicates(Map<String, String> params) {
        boolean flag;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(params, ARGUMENT_TEAM_NAME);
        boolean bl = flag = s != null && s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        if (s != null) {
            final String s_f = s;
            list.add(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    if (!(p_apply_1_ instanceof EntityLivingBase)) {
                        return false;
                    }
                    EntityLivingBase entitylivingbase = (EntityLivingBase)p_apply_1_;
                    Team team = entitylivingbase.func_96124_cp();
                    String s1 = team == null ? "" : team.func_96661_b();
                    return s1.equals(s_f) != flag;
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getNamePredicates(Map<String, String> params) {
        boolean flag;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(params, ARGUMENT_PLAYER_NAME);
        boolean bl = flag = s != null && s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        if (s != null) {
            final String s_f = s;
            list.add(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    return p_apply_1_ != null && p_apply_1_.func_70005_c_().equals(s_f) != flag;
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getTagPredicates(Map<String, String> params) {
        boolean flag;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(params, ARGUMENT_ENTITY_TAG);
        boolean bl = flag = s != null && s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        if (s != null) {
            final String s_f = s;
            list.add(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    return p_apply_1_ == null ? false : ("".equals(s_f) ? p_apply_1_.func_184216_O().isEmpty() != flag : p_apply_1_.func_184216_O().contains(s_f) != flag);
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getRadiusPredicates(Map<String, String> params, final Vec3d pos) {
        boolean flag1;
        double d0 = EntitySelector.getInt(params, ARGUMENT_RANGE_MIN, -1);
        double d1 = EntitySelector.getInt(params, ARGUMENT_RANGE_MAX, -1);
        final boolean flag = d0 < -0.5;
        boolean bl = flag1 = d1 < -0.5;
        if (flag && flag1) {
            return Collections.emptyList();
        }
        double d2 = Math.max(d0, 1.0E-4);
        final double d3 = d2 * d2;
        double d4 = Math.max(d1, 1.0E-4);
        final double d5 = d4 * d4;
        return Lists.newArrayList((Object[])new Predicate[]{new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                if (p_apply_1_ == null) {
                    return false;
                }
                double d6 = pos.func_186679_c(p_apply_1_.field_70165_t, p_apply_1_.field_70163_u, p_apply_1_.field_70161_v);
                return (flag || d6 >= d3) && (flag1 || d6 <= d5);
            }
        }});
    }

    private static List<Predicate<Entity>> getRotationsPredicates(Map<String, String> params) {
        ArrayList list = Lists.newArrayList();
        if (params.containsKey(ARGUMENT_ROTY_MIN) || params.containsKey(ARGUMENT_ROTY_MAX)) {
            final int i = MathHelper.func_188209_b((int)EntitySelector.getInt(params, ARGUMENT_ROTY_MIN, 0));
            final int j = MathHelper.func_188209_b((int)EntitySelector.getInt(params, ARGUMENT_ROTY_MAX, 359));
            list.add(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    if (p_apply_1_ == null) {
                        return false;
                    }
                    int i1 = MathHelper.func_188209_b((int)MathHelper.func_76141_d((float)p_apply_1_.field_70177_z));
                    return i > j ? i1 >= i || i1 <= j : i1 >= i && i1 <= j;
                }
            });
        }
        if (params.containsKey(ARGUMENT_ROTX_MIN) || params.containsKey(ARGUMENT_ROTX_MAX)) {
            final int k = MathHelper.func_188209_b((int)EntitySelector.getInt(params, ARGUMENT_ROTX_MIN, 0));
            final int l = MathHelper.func_188209_b((int)EntitySelector.getInt(params, ARGUMENT_ROTX_MAX, 359));
            list.add(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    if (p_apply_1_ == null) {
                        return false;
                    }
                    int i1 = MathHelper.func_188209_b((int)MathHelper.func_76141_d((float)p_apply_1_.field_70125_A));
                    return k > l ? i1 >= k || i1 <= l : i1 >= k && i1 <= l;
                }
            });
        }
        return list;
    }

    private static <T extends Entity> List<T> filterResults(Map<String, String> params, Class<? extends T> entityClass, List<Predicate<Entity>> inputList, String type, World worldIn, BlockPos position) {
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(params, ARGUMENT_ENTITY_TYPE);
        s = s != null && s.startsWith("!") ? s.substring(1) : s;
        boolean flag = !type.equals("e");
        boolean flag1 = type.equals("r") && s != null;
        int i = EntitySelector.getInt(params, ARGUMENT_DELTA_X, 0);
        int j = EntitySelector.getInt(params, ARGUMENT_DELTA_Y, 0);
        int k = EntitySelector.getInt(params, ARGUMENT_DELTA_Z, 0);
        int l = EntitySelector.getInt(params, ARGUMENT_RANGE_MAX, -1);
        Predicate predicate = Predicates.and(inputList);
        Predicate predicate1 = Predicates.and((Predicate)EntitySelectors.field_94557_a, (Predicate)predicate);
        if (!(params.containsKey(ARGUMENT_DELTA_X) || params.containsKey(ARGUMENT_DELTA_Y) || params.containsKey(ARGUMENT_DELTA_Z))) {
            if (l >= 0) {
                AxisAlignedBB axisalignedbb1 = new AxisAlignedBB((double)(position.func_177958_n() - l), (double)(position.func_177956_o() - l), (double)(position.func_177952_p() - l), (double)(position.func_177958_n() + l + 1), (double)(position.func_177956_o() + l + 1), (double)(position.func_177952_p() + l + 1));
                if (flag && !flag1) {
                    list.addAll(worldIn.func_175661_b(entityClass, predicate1));
                } else {
                    list.addAll(worldIn.func_175647_a(entityClass, axisalignedbb1, predicate1));
                }
            } else if (type.equals("a")) {
                list.addAll(worldIn.func_175661_b(entityClass, predicate));
            } else if (!(type.equals("p") || type.equals("r") && !flag1)) {
                list.addAll(worldIn.func_175644_a(entityClass, predicate1));
            } else {
                list.addAll(worldIn.func_175661_b(entityClass, predicate1));
            }
        } else {
            final AxisAlignedBB axisalignedbb = EntitySelector.getAABB(position, i, j, k);
            if (flag && !flag1) {
                Predicate<Entity> predicate2 = new Predicate<Entity>(){

                    public boolean apply(@Nullable Entity p_apply_1_) {
                        return p_apply_1_ != null && axisalignedbb.func_72326_a(p_apply_1_.func_174813_aQ());
                    }
                };
                list.addAll(worldIn.func_175661_b(entityClass, Predicates.and((Predicate)predicate1, (Predicate)predicate2)));
            } else {
                list.addAll(worldIn.func_175647_a(entityClass, axisalignedbb, predicate1));
            }
        }
        return list;
    }

    private static <T extends Entity> List<T> getEntitiesFromPredicates(List<T> matchingEntities, Map<String, String> params, ICommandSender sender, Class<? extends T> targetClass, String type, final Vec3d pos) {
        Entity entity;
        int i = EntitySelector.getInt(params, ARGUMENT_COUNT, !type.equals("a") && !type.equals("e") ? 1 : 0);
        if (!(type.equals("p") || type.equals("a") || type.equals("e"))) {
            if (type.equals("r")) {
                Collections.shuffle(matchingEntities);
            }
        } else {
            Collections.sort(matchingEntities, new Comparator<Entity>(){

                @Override
                public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                    return ComparisonChain.start().compare(p_compare_1_.func_70092_e(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c), p_compare_2_.func_70092_e(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c)).result();
                }
            });
        }
        if ((entity = sender.func_174793_f()) != null && targetClass.isAssignableFrom(entity.getClass()) && i == 1 && matchingEntities.contains(entity) && !"r".equals(type)) {
            matchingEntities = Lists.newArrayList((Object[])new Entity[]{entity});
        }
        if (i != 0) {
            if (i < 0) {
                Collections.reverse(matchingEntities);
            }
            matchingEntities = matchingEntities.subList(0, Math.min(Math.abs(i), matchingEntities.size()));
        }
        return matchingEntities;
    }

    private static AxisAlignedBB getAABB(BlockPos pos, int x, int y, int z) {
        boolean flag = x < 0;
        boolean flag1 = y < 0;
        boolean flag2 = z < 0;
        int i = pos.func_177958_n() + (flag ? x : 0);
        int j = pos.func_177956_o() + (flag1 ? y : 0);
        int k = pos.func_177952_p() + (flag2 ? z : 0);
        int l = pos.func_177958_n() + (flag ? 0 : x) + 1;
        int i1 = pos.func_177956_o() + (flag1 ? 0 : y) + 1;
        int j1 = pos.func_177952_p() + (flag2 ? 0 : z) + 1;
        return new AxisAlignedBB((double)i, (double)j, (double)k, (double)l, (double)i1, (double)j1);
    }

    private static BlockPos getBlockPosFromArguments(Map<String, String> params, BlockPos pos) {
        return new BlockPos(EntitySelector.getInt(params, ARGUMENT_COORDINATE_X, pos.func_177958_n()), EntitySelector.getInt(params, ARGUMENT_COORDINATE_Y, pos.func_177956_o()), EntitySelector.getInt(params, ARGUMENT_COORDINATE_Z, pos.func_177952_p()));
    }

    private static Vec3d getPosFromArguments(Map<String, String> params, Vec3d pos) {
        return new Vec3d(EntitySelector.getCoordinate(params, ARGUMENT_COORDINATE_X, pos.field_72450_a, true), EntitySelector.getCoordinate(params, ARGUMENT_COORDINATE_Y, pos.field_72448_b, false), EntitySelector.getCoordinate(params, ARGUMENT_COORDINATE_Z, pos.field_72449_c, true));
    }

    private static double getCoordinate(Map<String, String> params, String key, double defaultD, boolean offset) {
        return params.containsKey(key) ? (double)MathHelper.func_82715_a((String)params.get(key), (int)MathHelper.func_76128_c((double)defaultD)) + (offset ? 0.5 : 0.0) : defaultD;
    }

    private static int getInt(Map<String, String> params, String key, int defaultI) {
        return params.containsKey(key) ? MathHelper.func_82715_a((String)params.get(key), (int)defaultI) : defaultI;
    }

    @Nullable
    private static String getArgument(Map<String, String> params, String key) {
        return params.get(key);
    }

    public static Map<String, Integer> getScoreMap(Map<String, String> params) {
        HashMap map = Maps.newHashMap();
        for (String s : params.keySet()) {
            if (!s.startsWith("score_") || s.length() <= "score_".length()) continue;
            map.put(s.substring("score_".length()), MathHelper.func_82715_a((String)params.get(s), (int)1));
        }
        return map;
    }

    public static boolean matchesMultiplePlayers(String selectorStr) throws CommandException {
        Matcher matcher = TOKEN_PATTERN.matcher(selectorStr);
        if (!matcher.matches()) {
            return false;
        }
        Map<String, String> map = EntitySelector.getArgumentMap(matcher.group(2));
        String s = matcher.group(1);
        int i = !"a".equals(s) && !"e".equals(s) ? 1 : 0;
        return EntitySelector.getInt(map, ARGUMENT_COUNT, i) != 1;
    }

    public static boolean isSelector(String selectorStr) {
        return TOKEN_PATTERN.matcher(selectorStr).matches();
    }

    private static Map<String, String> getArgumentMap(@Nullable String argumentString) throws CommandException {
        HashMap map = Maps.newHashMap();
        if (argumentString == null) {
            return map;
        }
        for (String s : COMMA_SPLITTER.split((CharSequence)argumentString)) {
            Iterator iterator = EQUAL_SPLITTER.split((CharSequence)s).iterator();
            String s1 = (String)iterator.next();
            if (!IS_VALID_ARGUMENT.apply((Object)s1)) {
                throw new CommandException("commands.generic.selector_argument", new Object[]{s});
            }
            map.put(s1, iterator.hasNext() ? (String)iterator.next() : "");
        }
        return map;
    }
}

