/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.core.transformers;

import mchorse.aperture.utils.mclib.coremod.ClassTransformer;
import mchorse.aperture.utils.mclib.coremod.CoreClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class WorldTransformer
extends ClassTransformer {
    @Override
    public void process(String name, ClassNode node) {
        for (MethodNode method : node.methods) {
            if (this.checkName(method, "a", "(Lvg;F)Lbhe;", "getSkyColor", "(Lnet/minecraft/entity/Entity;F)Lnet/minecraft/util/math/Vec3d;") == null && this.checkName(method, "c", "(F)F", "getCelestialAngle", "(F)F") == null && this.checkName(method, "e", "(F)Lbhe;", "getCloudColour", "(F)Lnet/minecraft/util/math/Vec3d;") == null && this.checkName(method, "f", "(F)Lbhe;", "getFogColor", "(F)Lnet/minecraft/util/math/Vec3d;") == null) continue;
            this.process(method);
        }
    }

    private void process(MethodNode method) {
        String worldProvider = CoreClassTransformer.get("aym", "net/minecraft/world/WorldProvider");
        InsnList list = method.instructions;
        for (AbstractInsnNode node : list) {
            if (node.getOpcode() != 182 || !worldProvider.equals(((MethodInsnNode)node).owner)) continue;
            MethodInsnNode mnode = (MethodInsnNode)node;
            mnode.setOpcode(184);
            mnode.desc = "(L" + mnode.owner + ";" + mnode.desc.substring(1);
            mnode.owner = "mchorse/aperture/client/AsmRenderingHandler";
            switch (method.name) {
                case "a": {
                    mnode.name = "getSkyColor";
                    break;
                }
                case "c": {
                    mnode.name = "getCelestialAngle";
                    break;
                }
                case "e": {
                    mnode.name = "getCloudColor";
                    break;
                }
                case "f": {
                    mnode.name = "getFogColor";
                    break;
                }
                default: {
                    mnode.name = method.name;
                }
            }
            return;
        }
    }
}

