/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.core.transformers;

import java.util.ListIterator;
import mchorse.aperture.utils.mclib.coremod.ClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ShadersTransformer
extends ClassTransformer {
    @Override
    public void process(String name, ClassNode node) {
        for (MethodNode method : node.methods) {
            if (method.name.startsWith("setProgramUniform1")) {
                this.processSetProgramUniform(method);
                continue;
            }
            if (method.name.equals("useProgram")) {
                this.processUseProgram(method);
                continue;
            }
            if (method.name.matches("^create(?:Vert|Geom|Frag|Comp)Shader$")) {
                this.processCreateShader(method);
                continue;
            }
            if (method.name.equals("init")) {
                this.processInit(method);
                continue;
            }
            if (!method.name.equals("loadShaderPack")) continue;
            this.processLoadShaderPack(method);
        }
    }

    public void processSetProgramUniform(MethodNode method) {
        InsnList list = method.instructions;
        for (AbstractInsnNode node : list) {
            if (node.getOpcode() != 182) continue;
            MethodInsnNode mnode = (MethodInsnNode)node;
            mnode.setOpcode(184);
            mnode.name = method.name;
            mnode.desc = method.desc;
            mnode.owner = "mchorse/aperture/client/AsmShaderHandler";
            return;
        }
    }

    public void processUseProgram(MethodNode method) {
        InsnList list = method.instructions;
        ListIterator it = list.iterator();
        AbstractInsnNode target = null;
        while (it.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            if (node.getOpcode() != 18 || !"end useProgram".equals(((LdcInsnNode)node).cst)) continue;
            target = node;
            break;
        }
        if (target != null) {
            list.insertBefore(target, (AbstractInsnNode)new MethodInsnNode(184, "mchorse/aperture/client/AsmShaderHandler", "updateOptionUniforms", "()V", false));
        }
    }

    public void processCreateShader(MethodNode method) {
        InsnList list = method.instructions;
        ListIterator it = list.iterator();
        MethodInsnNode target = null;
        while (it.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            if (node.getOpcode() != 184 || !"resolveIncludes".equals(((MethodInsnNode)node).name)) continue;
            target = (MethodInsnNode)node;
            break;
        }
        if (target != null) {
            if (!target.desc.equals("(Ljava/io/BufferedReader;Ljava/lang/String;Lnet/optifine/shaders/IShaderPack;ILjava/util/List;I)Ljava/io/BufferedReader;")) {
                list.insert((AbstractInsnNode)target, (AbstractInsnNode)new MethodInsnNode(184, "net/optifine/util/LineBuffer", "readAll", "(Ljava/io/Reader;)Lnet/optifine/util/LineBuffer;", false));
            }
            target.name = "getCachedShader";
            target.desc = "(Ljava/lang/Object;Ljava/lang/String;Lnet/optifine/shaders/IShaderPack;ILjava/util/List;I)Ljava/io/BufferedReader;";
            target.owner = "mchorse/aperture/client/AsmShaderHandler";
        }
    }

    public void processInit(MethodNode method) {
        InsnList list = method.instructions;
        ListIterator it = list.iterator();
        AbstractInsnNode target = null;
        while (it.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            if (node.getOpcode() != 177) continue;
            target = node;
            break;
        }
        if (target != null) {
            list.insertBefore(target, (AbstractInsnNode)new MethodInsnNode(184, "mchorse/aperture/client/AsmShaderHandler", "afterInit", "()V", false));
        }
    }

    public void processLoadShaderPack(MethodNode method) {
        method.instructions.insert(method.instructions.getFirst(), (AbstractInsnNode)new MethodInsnNode(184, "mchorse/aperture/client/AsmShaderHandler", "loadShaderPack", "()V", false));
    }
}

