/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.commands.camera.control;

import com.google.common.primitives.Doubles;
import mchorse.aperture.Aperture;
import mchorse.aperture.ClientProxy;
import mchorse.mclib.commands.McCommandBase;
import mchorse.mclib.commands.utils.L10n;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;

public class SubCommandCameraRotate
extends McCommandBase {
    public String func_71517_b() {
        return "rotate";
    }

    public String func_71518_a(ICommandSender sender) {
        return "aperture.commands.camera.rotate";
    }

    public String getSyntax() {
        return "{l}{6}/{r}camera {8}rotate{r} {7}[yaw] [pitch]{r}";
    }

    public L10n getL10n() {
        return Aperture.l10n;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayer player = (EntityPlayer)sender;
        double x = args.length > 0 ? SubCommandCameraRotate.parseRelativeDouble(args[0], player.field_70177_z) : (double)player.field_70177_z;
        double y = args.length > 1 ? SubCommandCameraRotate.parseRelativeDouble(args[1], player.field_70125_A) : (double)player.field_70125_A;
        player.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, (float)x, (float)y);
        player.func_70016_h(0.0, 0.0, 0.0);
        ClientProxy.renderer.smooth.set((float)x, (float)y);
    }

    public static double parseRelativeDouble(String input, double base) throws CommandException {
        if (input.equals("~")) {
            return base;
        }
        String first = input.substring(0, 1);
        boolean relative = first.equals("~");
        try {
            double number;
            if (relative) {
                input = input.substring(1);
            }
            if (!Doubles.isFinite((double)(number = Double.parseDouble(input)))) {
                throw new NumberInvalidException("commands.generic.num.invalid", new Object[]{input});
            }
            return relative ? base + number : number;
        }
        catch (NumberFormatException var3) {
            throw new NumberInvalidException("commands.generic.num.invalid", new Object[]{input});
        }
    }

    public static long parseRelativeLong(String input, long base) throws CommandException {
        String first = input.substring(0, 1);
        boolean relative = first.equals("~");
        try {
            if (relative) {
                input = input.substring(1);
            }
            long number = Long.parseLong(input);
            return relative ? base + number : number;
        }
        catch (NumberFormatException var3) {
            throw new NumberInvalidException("commands.generic.num.invalid", new Object[]{input});
        }
    }
}

