/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui.utils;

import java.util.ArrayList;
import java.util.List;
import mchorse.aperture.Aperture;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.values.ValueKeyframeChannel;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.panels.GuiAbstractFixturePanel;
import mchorse.aperture.utils.TimeUtils;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiKeyframeElement;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiKeyframesEditor;
import mchorse.mclib.client.gui.framework.elements.keyframes.IAxisConverter;
import mchorse.mclib.client.gui.framework.elements.keyframes.Selection;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.keyframes.Keyframe;
import mchorse.mclib.utils.keyframes.KeyframeInterpolation;
import mchorse.mclib.utils.undo.CompoundUndo;
import mchorse.mclib.utils.undo.IUndo;
import net.minecraft.client.Minecraft;

public abstract class GuiCameraEditorKeyframesEditor<E extends GuiKeyframeElement>
extends GuiKeyframesEditor<E> {
    public static final AxisConverter CONVERTER = new AxisConverter();
    protected GuiCameraEditor editor;
    protected List<Value> valueChannels = new ArrayList<Value>();
    private List<Object> cachedData = new ArrayList<Object>();
    private int type = -1;
    private long lastUpdate;

    public GuiCameraEditorKeyframesEditor(Minecraft mc, GuiCameraEditor editor) {
        super(mc);
        this.editor = editor;
        this.interp.keys().register(IKey.lang((String)"aperture.gui.panels.keys.graph_interp"), 26, () -> ((GuiCameraEditorKeyframesEditor)this).toggleInterpolation()).held(new int[]{29}).category(GuiAbstractFixturePanel.CATEGORY).active(editor::isFlightDisabled);
        this.easing.keys().register(IKey.lang((String)"aperture.gui.panels.keys.graph_easing"), 27, () -> ((GuiCameraEditorKeyframesEditor)this).toggleEasing()).held(new int[]{29}).category(GuiAbstractFixturePanel.CATEGORY).active(editor::isFlightDisabled);
    }

    protected ValueKeyframeChannel get(Value value) {
        return value instanceof ValueKeyframeChannel ? (ValueKeyframeChannel)value : null;
    }

    public int getUndo() {
        return this.type;
    }

    public void updateConverter() {
        this.setConverter(CONVERTER);
    }

    public void markUndo(int type) {
        if (this.type == -1 || this.type == type) {
            this.lastUpdate = System.currentTimeMillis() + 400L;
        }
        if (this.type != type) {
            if (this.type >= 0) {
                this.submitUndo();
            }
            this.cachedData.clear();
            for (Value channel : this.valueChannels) {
                this.cachedData.add(channel.getValue());
            }
        }
        this.type = type;
    }

    private void submitUndo() {
        int oldValue = this.type;
        this.type = -1;
        ArrayList<Object> newCachedData = new ArrayList<Object>();
        for (Value channel : this.valueChannels) {
            newCachedData.add(channel.getValue());
        }
        if (newCachedData.size() > 1) {
            IUndo[] undos = new IUndo[newCachedData.size()];
            for (int i = 0; i < undos.length; ++i) {
                undos[i] = GuiAbstractFixturePanel.undo(this.editor, this.valueChannels.get(i), this.cachedData.get(i), newCachedData.get(i));
            }
            this.editor.postUndo((IUndo<CameraProfile>)new CompoundUndo(undos).noMerging(), false);
        } else {
            Value channel = this.valueChannels.get(0);
            this.editor.postUndo((IUndo<CameraProfile>)GuiAbstractFixturePanel.undo(this.editor, channel, this.cachedData.get(0), newCachedData.get(0)).noMerging(), false);
        }
        this.cachedData.clear();
    }

    public void cancelUndo() {
        this.type = -1;
        this.cachedData.clear();
    }

    protected void doubleClick(int mouseX, int mouseY) {
        this.markUndo(0);
        super.doubleClick(mouseX, mouseY);
    }

    public void removeSelectedKeyframes() {
        this.markUndo(1);
        super.removeSelectedKeyframes();
    }

    public void setTick(double value) {
        this.markUndo(2);
        super.setTick(value);
    }

    public void setValue(double value) {
        this.markUndo(3);
        super.setValue(value);
    }

    public void changeEasing() {
        this.markUndo(4);
        super.changeEasing();
    }

    public void pickInterpolation(KeyframeInterpolation interp) {
        this.markUndo(5);
        super.pickInterpolation(interp);
    }

    public void draw(GuiContext context) {
        super.draw(context);
        if (this.type >= 0 && this.lastUpdate < System.currentTimeMillis()) {
            this.submitUndo();
        }
    }

    public static class AxisConverter
    implements IAxisConverter {
        public String format(double value) {
            return TimeUtils.formatTime((long)value);
        }

        public double from(double v) {
            return TimeUtils.fromTime(v);
        }

        public double to(double v) {
            return TimeUtils.toTime((long)v);
        }

        public void updateField(GuiTrackpadElement element) {
            TimeUtils.configure(element, 0L);
            element.limit(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }

        public boolean forceInteger(Keyframe keyframe, Selection selection, boolean forceInteger) {
            return (Boolean)Aperture.editorSeconds.get() == false && forceInteger;
        }
    }
}

