/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui.panels.modules;

import java.util.List;
import java.util.function.Consumer;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.fixtures.PathFixture;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.panels.modules.GuiAbstractModule;
import mchorse.aperture.client.gui.utils.undo.FixturePointsChangeUndo;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.ScrollArea;
import mchorse.mclib.client.gui.utils.ScrollDirection;
import mchorse.mclib.utils.undo.IUndo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;

public class GuiPointsModule
extends GuiAbstractModule {
    public PathFixture path;
    public Consumer<Integer> picker;
    public ScrollArea scroll = new ScrollArea(20);
    public int index = 0;

    public GuiPointsModule(Minecraft mc, GuiCameraEditor editor, Consumer<Integer> picker) {
        super(mc, editor);
        this.picker = picker;
        GuiIconElement back = new GuiIconElement(mc, Icons.SHIFT_BACKWARD, b -> this.moveBack());
        GuiIconElement forward = new GuiIconElement(mc, Icons.SHIFT_FORWARD, b -> this.moveForward());
        GuiIconElement add = new GuiIconElement(mc, Icons.ADD, b -> this.addPoint());
        GuiIconElement remove = new GuiIconElement(mc, Icons.REMOVE, b -> this.removePoint());
        back.flex().relative((GuiElement)this).x(-40);
        remove.flex().relative((GuiElement)this).x(-20);
        add.flex().relative((GuiElement)this).x(1.0f);
        forward.flex().relative((GuiElement)this).x(1.0f, 20);
        this.add(new IGuiElement[]{back, add, remove, forward});
        this.scroll.direction = ScrollDirection.HORIZONTAL;
    }

    private IUndo<CameraProfile> undo(GuiCameraEditor editor, int index, int nextIndex, List<Position> positions) {
        CameraProfile profile = editor.getProfile();
        AbstractFixture fixture = editor.getFixture();
        int fixtureIndex = profile.fixtures.indexOf(fixture);
        return new FixturePointsChangeUndo(fixtureIndex, this.path.points.getPath(), index, nextIndex, this.path.points.getValue(), positions).view(this.editor.timeline).noMerging();
    }

    public void setIndex(int index) {
        this.index = index;
        this.scroll.scrollIntoView(index * this.scroll.scrollItemSize);
    }

    public void moveBack() {
        if (this.index == 0) {
            return;
        }
        List positions = (List)this.path.points.getValue();
        positions.add(this.index, positions.remove(this.index - 1));
        int nextIndex = this.index - 1;
        this.editor.postUndo(this.undo(this.editor, this.index, nextIndex, positions));
        this.index = nextIndex;
    }

    public void moveForward() {
        if (this.index >= this.path.size() - 1) {
            return;
        }
        List positions = (List)this.path.points.getValue();
        positions.add(this.index, positions.remove(this.index + 1));
        int nextIndex = this.index - 1;
        this.editor.postUndo(this.undo(this.editor, this.index, nextIndex, positions));
        this.index = nextIndex;
    }

    public void addPoint() {
        List positions = (List)this.path.points.getValue();
        if (this.index + 1 >= this.path.size()) {
            positions.add(this.editor.getPosition());
            int nextIndex = MathHelper.func_76125_a((int)(this.index + 1), (int)0, (int)(positions.size() - 1));
            this.editor.postUndo(this.undo(this.editor, this.index, nextIndex, positions));
            this.index = nextIndex;
        } else {
            positions.add(this.index + 1, this.editor.getPosition());
            int nextIndex = this.index + 1;
            this.editor.postUndo(this.undo(this.editor, this.index, nextIndex, positions));
            this.index = nextIndex;
        }
        this.scroll.setSize(this.path.size());
        this.scroll.scrollTo(this.index * this.scroll.scrollItemSize);
        if (this.picker != null) {
            this.picker.accept(this.index);
        }
    }

    public void removePoint() {
        if (this.path.points.size() == 1 && this.index >= 0) {
            return;
        }
        List positions = (List)this.path.points.getValue();
        positions.remove(this.index);
        int nextIndex = this.index > 0 ? this.index - 1 : this.index;
        this.editor.postUndo(this.undo(this.editor, this.index, nextIndex, positions));
        this.index = nextIndex;
        this.scroll.setSize(this.path.size());
        this.scroll.scrollTo(this.index * this.scroll.scrollItemSize);
        if (this.picker != null) {
            this.picker.accept(this.index);
        }
    }

    public void fill(PathFixture path) {
        this.path = path;
        this.index = 0;
        this.scroll.setSize(path.size());
        this.scroll.clamp();
    }

    public void resize() {
        super.resize();
        this.scroll.copy(this.area);
    }

    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context)) {
            return true;
        }
        int mouseX = context.mouseX;
        int mouseY = context.mouseY;
        if (this.scroll.isInside(context)) {
            if (context.mouseButton == 1) {
                this.scroll.dragging = true;
                return true;
            }
            if (context.mouseButton == 0) {
                int index = this.scroll.getIndex(mouseX, mouseY);
                int size = this.path.size();
                if (index >= 0 && index < size) {
                    this.index = index;
                    if (this.picker != null) {
                        this.picker.accept(index);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(GuiContext context) {
        return super.mouseScrolled(context) || this.scroll.mouseScroll(context);
    }

    public void mouseReleased(GuiContext context) {
        super.mouseReleased(context);
        this.scroll.mouseReleased(context);
    }

    public void draw(GuiContext context) {
        int w;
        this.scroll.drag(context);
        int x = this.scroll.x;
        int y = this.scroll.y;
        int c = this.path.size();
        Gui.func_73734_a((int)x, (int)y, (int)(x + this.scroll.w), (int)(y + this.scroll.h), (int)-2013265920);
        GuiDraw.scissor((int)this.scroll.x, (int)this.scroll.y, (int)this.scroll.w, (int)this.scroll.h, (GuiContext)context);
        for (int i = 0; i < c; ++i) {
            String label = String.valueOf(i);
            int xx = this.scroll.x + i * this.scroll.scrollItemSize - this.scroll.scroll;
            w = this.font.func_78256_a(label);
            Gui.func_73734_a((int)xx, (int)y, (int)(xx + 20), (int)(y + 20), (int)(this.index == i ? -3403408 : -56704));
            Gui.func_73734_a((int)(xx + 19), (int)y, (int)(xx + 20), (int)(y + 20), (int)0x22000000);
            this.font.func_175063_a(label, (float)(xx + 10 - w / 2), (float)(y + 6), 0xFFFFFF);
        }
        GuiDraw.unscissor((GuiContext)context);
        int mw = this.scroll.w;
        int scroll = this.scroll.getScrollBar(mw);
        if (scroll != 0) {
            int bx = this.scroll.x + (int)((float)this.scroll.scroll / (float)(this.scroll.scrollSize - this.scroll.w) * (float)(mw - scroll));
            int by = y + this.scroll.h + 2;
            Gui.func_73734_a((int)bx, (int)by, (int)(bx + scroll), (int)(by + 2), (int)-2013265920);
        }
        if (this.scroll.scroll > 0 && this.scroll.scrollSize >= this.scroll.w - 40) {
            GuiDraw.drawHorizontalGradientRect((int)x, (int)y, (int)(x + 4), (int)(y + this.scroll.h), (int)-2013265920, (int)0, (float)0.0f);
        }
        if (this.scroll.scroll < this.scroll.scrollSize - this.scroll.w && this.scroll.scrollSize >= this.scroll.w) {
            GuiDraw.drawHorizontalGradientRect((int)(x + this.scroll.w - 4), (int)y, (int)(x + this.scroll.w), (int)(y + this.scroll.h), (int)0, (int)-2013265920, (float)0.0f);
        }
        super.draw(context);
        String label = I18n.func_135052_a((String)"aperture.gui.panels.path_points", (Object[])new Object[0]);
        w = this.font.func_78256_a(label);
        this.font.func_175063_a(label, (float)(this.scroll.x + this.scroll.w / 2 - w / 2), (float)(this.scroll.y - 14), 0xFFFFFF);
    }
}

