/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui.panels.modules;

import mchorse.aperture.camera.data.InterpolationType;
import mchorse.aperture.camera.fixtures.PathFixture;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.panels.GuiAbstractFixturePanel;
import mchorse.aperture.client.gui.panels.GuiPathFixturePanel;
import mchorse.aperture.client.gui.panels.modules.GuiAbstractModule;
import mchorse.aperture.client.gui.utils.GuiInterpolationTypeList;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.tooltips.ITooltip;
import mchorse.mclib.client.gui.framework.tooltips.InterpolationTooltip;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.IInterpolation;
import mchorse.mclib.utils.Interpolation;
import mchorse.mclib.utils.MathUtils;
import mchorse.mclib.utils.keyframes.KeyframeInterpolations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class GuiInterpModule
extends GuiAbstractModule {
    public GuiButtonElement pos;
    public GuiButtonElement angle;
    public GuiInterpolationTypeList interps;
    public PathFixture fixture;
    public boolean pickPos = false;
    private GuiPathFixturePanel panel;

    private IInterpolation getInterp(InterpolationType type) {
        Interpolation function = type.function;
        if (type == InterpolationType.HERMITE) {
            function = KeyframeInterpolations.HERMITE;
        }
        return function;
    }

    public GuiInterpModule(Minecraft mc, GuiCameraEditor editor, GuiPathFixturePanel panel) {
        super(mc, editor);
        this.panel = panel;
        this.pos = new GuiButtonElement(mc, IKey.lang((String)""), b -> {
            if (this.interps.hasParent() && this.pickPos) {
                this.interps.removeFromParent();
            } else {
                this.interps.removeFromParent();
                this.pickPos = true;
                this.interps.setCurrentScroll((Object)this.fixture.interpolation.get());
                this.getParentContainer().add((IGuiElement)this.interps);
                this.interps.flex().relative((GuiElement)this.pos);
                this.interps.resize();
            }
        });
        this.pos.tooltip((ITooltip)new InterpolationTooltip(1.0f, 0.0f, () -> this.getInterp(this.fixture.interpolation.get()), null));
        this.angle = new GuiButtonElement(mc, IKey.lang((String)""), b -> {
            if (this.interps.hasParent() && !this.pickPos) {
                this.interps.removeFromParent();
            } else {
                this.interps.removeFromParent();
                this.pickPos = false;
                this.interps.setCurrentScroll((Object)this.fixture.interpolationAngle.get());
                this.getParentContainer().add((IGuiElement)this.interps);
                this.interps.flex().relative((GuiElement)this.angle);
                this.interps.resize();
            }
        });
        this.angle.tooltip((ITooltip)new InterpolationTooltip(1.0f, 0.0f, () -> this.getInterp(this.fixture.interpolationAngle.get()), null));
        this.interps = new GuiInterpolationTypeList(mc, interp -> {
            if (this.pickPos) {
                this.editor.postUndo(GuiAbstractFixturePanel.undo(this.editor, this.fixture.interpolation, interp.get(0)));
                this.pos.label.set(((InterpolationType)((Object)((Object)interp.get(0)))).getKey());
            } else {
                this.editor.postUndo(GuiAbstractFixturePanel.undo(this.editor, this.fixture.interpolationAngle, interp.get(0)));
                this.angle.label.set(((InterpolationType)((Object)((Object)interp.get(0)))).getKey());
            }
            this.panel.interpolationWasUpdated(this.pickPos);
        });
        this.interps.tooltip((ITooltip)new InterpolationTooltip(1.0f, 0.0f, () -> this.getInterp(this.pickPos ? this.fixture.interpolation.get() : this.fixture.interpolationAngle.get()), null)).markIgnored();
        this.interps.flex().y(1.0f).w(1.0f).h(96);
        this.flex().column(5).vertical().stretch().height(20);
        this.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"aperture.gui.panels.position")).background(), this.pos});
        this.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"aperture.gui.panels.angle")).background(), this.angle});
        this.keys().register(IKey.lang((String)"aperture.gui.panels.keys.path_position"), 25, this::togglePosition).held(new int[]{29}).active(editor::isFlightDisabled).category(GuiAbstractFixturePanel.CATEGORY);
        this.keys().register(IKey.lang((String)"aperture.gui.panels.keys.path_angle"), 30, this::toggleAngle).held(new int[]{29}).active(editor::isFlightDisabled).category(GuiAbstractFixturePanel.CATEGORY);
    }

    private void togglePosition() {
        InterpolationType type = this.next(this.fixture.interpolation.get(), this.pos);
        this.editor.postUndo(GuiAbstractFixturePanel.undo(this.editor, this.fixture.interpolation, (Object)type));
    }

    private void toggleAngle() {
        InterpolationType type = this.next(this.fixture.interpolation.get(), this.pos);
        this.editor.postUndo(GuiAbstractFixturePanel.undo(this.editor, this.fixture.interpolationAngle, (Object)type));
    }

    private InterpolationType next(InterpolationType interp, GuiButtonElement button) {
        int factor = GuiScreen.func_146272_n() ? -1 : 1;
        int index = MathUtils.cycler((int)(interp.ordinal() + factor), (int)0, (int)(InterpolationType.values().length - 1));
        interp = InterpolationType.values()[index];
        button.label.set(interp.getKey());
        this.interps.setCurrent((Object)interp);
        this.editor.updateProfile();
        GuiUtils.playClick();
        return interp;
    }

    public void fill(PathFixture fixture) {
        this.fixture = fixture;
        this.interps.removeFromParent();
        this.interps.setCurrent((Object)fixture.interpolation.get());
        this.pos.label.set(((InterpolationType)((Object)this.interps.getCurrentFirst())).getKey());
        this.interps.setCurrent((Object)fixture.interpolationAngle.get());
        this.angle.label.set(((InterpolationType)((Object)this.interps.getCurrentFirst())).getKey());
    }
}

