/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui.panels.modules;

import mchorse.aperture.camera.data.Angle;
import mchorse.aperture.camera.values.ValueAngle;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.panels.GuiAbstractFixturePanel;
import mchorse.aperture.client.gui.panels.modules.GuiAbstractModule;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;

public class GuiAngleModule
extends GuiAbstractModule {
    public GuiTrackpadElement yaw;
    public GuiTrackpadElement pitch;
    public GuiTrackpadElement roll;
    public GuiTrackpadElement fov;
    public ValueAngle angle;

    public GuiAngleModule(Minecraft mc, GuiCameraEditor editor) {
        super(mc, editor);
        this.yaw = new GuiTrackpadElement(mc, value -> {
            Angle point = this.angle.get().copy();
            point.yaw = value.floatValue();
            this.editor.postUndo(GuiAbstractFixturePanel.undo(this.editor, this.angle, point));
        });
        this.yaw.tooltip(IKey.lang((String)"aperture.gui.panels.yaw"));
        this.pitch = new GuiTrackpadElement(mc, value -> {
            Angle point = this.angle.get().copy();
            point.pitch = value.floatValue();
            this.editor.postUndo(GuiAbstractFixturePanel.undo(this.editor, this.angle, point));
        });
        this.pitch.tooltip(IKey.lang((String)"aperture.gui.panels.pitch"));
        this.roll = new GuiTrackpadElement(mc, value -> {
            Angle point = this.angle.get().copy();
            point.roll = value.floatValue();
            this.editor.postUndo(GuiAbstractFixturePanel.undo(this.editor, this.angle, point));
        });
        this.roll.tooltip(IKey.lang((String)"aperture.gui.panels.roll"));
        this.fov = new GuiTrackpadElement(mc, value -> {
            Angle point = this.angle.get().copy();
            point.fov = value.floatValue();
            this.editor.postUndo(GuiAbstractFixturePanel.undo(this.editor, this.angle, point));
        });
        this.fov.tooltip(IKey.lang((String)"aperture.gui.panels.fov"));
        this.flex().column(5).vertical().stretch().height(20);
        this.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"aperture.gui.panels.angle")).background(), this.yaw, this.pitch, this.roll, this.fov});
    }

    public void fill(ValueAngle angle) {
        this.angle = angle;
        this.yaw.setValue((double)angle.get().yaw);
        this.pitch.setValue((double)angle.get().pitch);
        this.roll.setValue((double)angle.get().roll);
        this.fov.setValue((double)angle.get().fov);
    }
}

