/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui.panels.modifiers.widgets;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.aperture.camera.smooth.Envelope;
import mchorse.aperture.client.gui.panels.modifiers.GuiAbstractModifierPanel;
import mchorse.aperture.client.gui.utils.GuiCameraEditorKeyframesGraphEditor;
import mchorse.aperture.client.gui.utils.GuiGraphView;
import mchorse.aperture.client.gui.utils.undo.ModifierValueChangeUndo;
import mchorse.aperture.utils.TimeUtils;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiInterpolationList;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.tooltips.ITooltip;
import mchorse.mclib.client.gui.framework.tooltips.InterpolationTooltip;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.Interpolation;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.undo.CompoundUndo;
import mchorse.mclib.utils.undo.IUndo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public class GuiEnvelope
extends GuiElement {
    public static final int regular = -16777216;
    public static final int selected = -65536;
    public GuiAbstractModifierPanel panel;
    public GuiElement row;
    public GuiToggleElement enabled;
    public GuiToggleElement relative;
    public GuiIconElement pickInterp;
    public GuiTrackpadElement startX;
    public GuiTrackpadElement startD;
    public GuiTrackpadElement endX;
    public GuiTrackpadElement endD;
    public GuiInterpolationList interps;
    public GuiToggleElement keyframes;
    public GuiCameraEditorKeyframesGraphEditor channel;
    private Color color = new Color();

    public GuiEnvelope(Minecraft mc, GuiAbstractModifierPanel panel) {
        super(mc);
        this.panel = panel;
        InterpolationTooltip tooltip = new InterpolationTooltip(0.0f, 0.0f, () -> this.get().interpolation.get(), null);
        this.enabled = new GuiToggleElement(mc, IKey.lang((String)"aperture.gui.modifiers.enabled"), b -> this.panel.modifiers.editor.postUndo(this.undo((Value)this.get().enabled, b.isToggled())));
        this.relative = new GuiToggleElement(mc, IKey.lang((String)"aperture.gui.modifiers.panels.relative"), b -> this.toggleRelative(b.isToggled()));
        this.pickInterp = new GuiIconElement(mc, Icons.GEAR, b -> this.interps.toggleVisible());
        this.pickInterp.tooltip(IKey.lang((String)"aperture.gui.modifiers.envelopes.interp"));
        this.startX = new GuiTrackpadElement(mc, value -> this.panel.modifiers.editor.postUndo(this.undo((Value)this.get().startX, Float.valueOf(TimeUtils.fromTime(value.floatValue())))));
        this.startX.tooltip(IKey.lang((String)"aperture.gui.modifiers.envelopes.start_x"), Direction.TOP);
        this.startD = new GuiTrackpadElement(mc, value -> this.panel.modifiers.editor.postUndo(this.undo((Value)this.get().startDuration, Float.valueOf(TimeUtils.fromTime(value.floatValue())))));
        this.startD.tooltip(IKey.lang((String)"aperture.gui.modifiers.envelopes.start_d"), Direction.TOP);
        this.endX = new GuiTrackpadElement(mc, value -> this.panel.modifiers.editor.postUndo(this.undo((Value)this.get().endX, Float.valueOf(TimeUtils.fromTime(value.floatValue())))));
        this.endX.tooltip(IKey.lang((String)"aperture.gui.modifiers.envelopes.end_x"), Direction.TOP);
        this.endD = new GuiTrackpadElement(mc, value -> this.panel.modifiers.editor.postUndo(this.undo((Value)this.get().endDuration, Float.valueOf(TimeUtils.fromTime(value.floatValue())))));
        this.endD.tooltip(IKey.lang((String)"aperture.gui.modifiers.envelopes.end_d"), Direction.TOP);
        this.interps = new GuiInterpolationList(mc, l -> this.panel.modifiers.editor.postUndo(this.undo(this.get().interpolation, l.get(0))));
        this.interps.tooltip((ITooltip)tooltip).setVisible(false);
        this.keyframes = new GuiToggleElement(mc, IKey.lang((String)"aperture.gui.modifiers.panels.keyframes"), b -> {
            this.panel.modifiers.editor.postUndo(this.undo((Value)this.get().keyframes, b.isToggled()));
            this.toggleKeyframes(b.isToggled());
        });
        this.channel = new GuiCameraEditorKeyframesGraphEditor(mc, panel.modifiers.editor);
        this.enabled.flex().reset();
        this.relative.flex().reset();
        this.row = Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.enabled, this.relative, this.pickInterp});
        this.row.flex().relative((GuiElement)this).xy(10, 10).w(1.0f, -20);
        this.startX.flex().relative((GuiElement)this.enabled).xy(0, 20).w(1.0f);
        this.startD.flex().relative((GuiElement)this.startX).xy(0, 25).w(1.0f);
        this.endX.flex().relative((GuiElement)this.relative).xy(0, 20).w(1.0f);
        this.endD.flex().relative((GuiElement)this.endX).xy(0, 25).w(1.0f);
        this.interps.flex().relative((GuiElement)this.pickInterp).xy(1.0f, 1.0f).w(110).hTo((IResizer)this.area, 1.0f).anchor(1.0f, 0.0f);
        this.channel.flex().relative((GuiElement)this.enabled).y(20).wTo((IResizer)this.row.area, 1.0f).h(200);
    }

    public IUndo<CameraProfile> undo(Value value, Object newValue) {
        CameraProfile profile = this.panel.modifiers.editor.getProfile();
        AbstractFixture fixture = this.panel.modifiers.fixture;
        int index = -1;
        if (fixture != null) {
            index = profile.fixtures.indexOf(fixture);
        }
        return new ModifierValueChangeUndo(index, this.panel.modifiers.panels.scroll.scroll, value.getPath(), value.getValue(), newValue).view(this.panel.modifiers.editor.timeline);
    }

    private void toggleKeyframes(boolean toggled) {
        this.removeAll();
        this.row.removeAll();
        if (toggled) {
            this.row.add((IGuiElement)this.enabled);
            this.add(new IGuiElement[]{this.row, this.channel, this.keyframes});
            this.flex().h(255);
            this.keyframes.flex().reset().relative((GuiElement)this.channel).y(1.0f).w(1.0f).h(20);
        } else {
            this.row.add(new IGuiElement[]{this.enabled, this.relative, this.pickInterp});
            this.add(new IGuiElement[]{this.row, this.startX, this.startD, this.endX, this.endD, this.keyframes, this.interps});
            this.flex().h(110);
            this.keyframes.flex().reset().relative((GuiElement)this.startD).y(1.0f).wTo((IResizer)this.endD.area, 1.0f).h(20);
        }
        if (this.getParent() != null) {
            this.getParent().getParent().resize();
            if (toggled) {
                this.initiate();
            }
        }
    }

    public void initiate() {
        this.updateDuration();
        ((GuiGraphView)this.channel.graph).resetView();
        this.channel.updateConverter();
        TimeUtils.configure(this.startX, Integer.MIN_VALUE);
        TimeUtils.configure(this.startD, 0L);
        TimeUtils.configure(this.endX, Integer.MIN_VALUE);
        TimeUtils.configure(this.endD, 0L);
        this.fillIntervals();
    }

    public void wasToggled() {
        ((GuiGraphView)this.channel.graph).resetView();
    }

    public void fillData() {
        Envelope envelope = this.get();
        this.enabled.toggled(((Boolean)envelope.enabled.get()).booleanValue());
        this.relative.toggled(((Boolean)envelope.relative.get()).booleanValue());
        this.fillIntervals();
        this.interps.setCurrentScroll((Object)envelope.interpolation.get());
        this.keyframes.toggled(((Boolean)envelope.keyframes.get()).booleanValue());
        this.channel.setChannel(envelope.channel, 35071);
        this.toggleKeyframes((Boolean)envelope.keyframes.get());
    }

    private void fillIntervals() {
        Envelope envelope = this.get();
        this.startX.setValue(TimeUtils.toTime(((Float)envelope.startX.get()).intValue()));
        this.startD.setValue(TimeUtils.toTime(((Float)envelope.startDuration.get()).intValue()));
        this.endX.setValue(TimeUtils.toTime(((Float)envelope.endX.get()).intValue()));
        this.endD.setValue(TimeUtils.toTime(((Float)envelope.endDuration.get()).intValue()));
    }

    public void updateDuration() {
        ((GuiGraphView)this.channel.graph).duration = (int)this.getDuration();
    }

    private void toggleRelative(boolean toggled) {
        Envelope envelope = this.get();
        this.panel.modifiers.editor.postUndo((IUndo<CameraProfile>)new CompoundUndo(new IUndo[]{this.undo((Value)envelope.relative, toggled), this.undo((Value)envelope.endX, Float.valueOf((float)this.getDuration() - ((Float)envelope.endX.get()).floatValue()))}));
        this.fillIntervals();
    }

    public long getDuration() {
        if (this.panel.modifiers.fixture == null) {
            return this.panel.modifiers.editor.getProfile().getDuration();
        }
        return this.panel.modifiers.fixture.getDuration();
    }

    public Envelope get() {
        return ((AbstractModifier)this.panel.modifier).envelope.get();
    }

    public void draw(GuiContext context) {
        if (this.interps.isVisible()) {
            this.pickInterp.area.draw(-2013265920);
        }
        if (!((Boolean)this.get().keyframes.get()).booleanValue()) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            GL11.glLineWidth((float)2.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179090_x();
            GlStateManager.func_179103_j((int)7425);
            buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            this.drawGraph(context, buffer, this.get());
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179103_j((int)7424);
            GL11.glLineWidth((float)1.0f);
            int x = this.panel.modifiers.editor.timeline.value;
            if (this.panel.modifiers.fixture != null) {
                x = (int)((long)x - this.panel.modifiers.editor.getProfile().calculateOffset(this.panel.modifiers.fixture));
            }
            float factor = this.get().factor(this.getDuration(), x);
            if ((x = this.getX(x)) >= this.area.x && x < this.area.ex()) {
                Gui.func_73734_a((int)x, (int)(this.area.ey() - 3 - (int)(9.0f * factor)), (int)(x + 2), (int)this.area.ey(), (int)-11012822);
            }
        }
        super.draw(context);
    }

    private void drawGraph(GuiContext context, BufferBuilder buffer, Envelope envelope) {
        long duration = this.getDuration();
        int startX = this.getX(envelope.getStartX(duration));
        int startD = this.getX(envelope.getStartDuration(duration));
        int endX = this.getX(envelope.getEndX(duration));
        int endD = this.getX(envelope.getEndDuration(duration));
        int sy = this.area.ey() - 1;
        int ey = sy - 10;
        if (startD > this.area.x) {
            this.color.set(this.startX.area.isInside(context) ? -65536 : -16777216, true);
            buffer.func_181662_b((double)this.area.x, (double)sy, 0.0).func_181666_a(this.color.r, this.color.g, this.color.b, this.color.a).func_181675_d();
            buffer.func_181662_b((double)startX, (double)sy, 0.0).func_181666_a(this.color.r, this.color.g, this.color.b, this.color.a).func_181675_d();
            this.drawFades(context, buffer, envelope.interpolation.get(), this.startD.area, startX, startD, sy, ey);
        }
        this.color.set(this.startD.area.isInside(context) ? -65536 : -16777216, true);
        buffer.func_181662_b((double)startD, (double)ey, 0.0).func_181666_a(this.color.r, this.color.g, this.color.b, this.color.a).func_181675_d();
        this.color.set(-16777216, true);
        buffer.func_181662_b((double)Interpolations.lerp((float)startD, (float)endD, (float)0.5f), (double)ey, 0.0).func_181666_a(this.color.r, this.color.g, this.color.b, this.color.a).func_181675_d();
        this.color.set(this.endD.area.isInside(context) ? -65536 : -16777216, true);
        buffer.func_181662_b((double)endD, (double)ey, 0.0).func_181666_a(this.color.r, this.color.g, this.color.b, this.color.a).func_181675_d();
        if (endD < this.area.ex()) {
            this.drawFades(context, buffer, envelope.interpolation.get(), this.endX.area, endD, endX, ey, sy);
            this.color.set(this.endX.area.isInside(context) ? -65536 : -16777216, true);
            buffer.func_181662_b((double)endX, (double)sy, 0.0).func_181666_a(this.color.r, this.color.g, this.color.b, this.color.a).func_181675_d();
            buffer.func_181662_b((double)this.area.ex(), (double)sy, 0.0).func_181666_a(this.color.r, this.color.g, this.color.b, this.color.a).func_181675_d();
        }
    }

    private void drawFades(GuiContext context, BufferBuilder buffer, Interpolation interp, Area area, int startX, int startD, int a, int b) {
        for (int i = 1; i < 10; ++i) {
            float x = Interpolations.lerp((float)startX, (float)startD, (float)((float)i / 10.0f));
            float y = interp.interpolate((float)a, (float)b, (float)i / 10.0f);
            if (i == 6) {
                this.color.set(area.isInside(context) ? -65536 : -16777216, true);
            }
            buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(this.color.r, this.color.g, this.color.b, this.color.a).func_181675_d();
        }
    }

    private int getX(float value) {
        long duration = this.getDuration();
        float factor = value / (float)duration;
        return this.area.x + (int)(factor * (float)this.area.w);
    }

    public void updateVisibility() {
        this.panel.modifiers.editor.postUndo(this.undo((Value)this.get().visible, (Boolean)this.get().visible.get() == false), false, false);
        this.get().visible.set((Object)((Boolean)this.get().visible.get() == false ? 1 : 0));
    }
}

