/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui.panels.modifiers;

import mchorse.aperture.camera.data.Point;
import mchorse.aperture.camera.modifiers.LookModifier;
import mchorse.aperture.client.gui.GuiModifiersManager;
import mchorse.aperture.client.gui.panels.modifiers.GuiAbstractModifierPanel;
import mchorse.aperture.client.gui.utils.GuiTextHelpElement;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.RayTracing;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class GuiLookModifierPanel
extends GuiAbstractModifierPanel<LookModifier> {
    public static final String TARGET_SELECTOR_HELP = "https://minecraft.gamepedia.com/Commands#Target_selector_arguments";
    public GuiTextHelpElement selector;
    public GuiTrackpadElement blockX;
    public GuiTrackpadElement blockY;
    public GuiTrackpadElement blockZ;
    public GuiTrackpadElement x;
    public GuiTrackpadElement y;
    public GuiTrackpadElement z;
    public GuiToggleElement relative;
    public GuiToggleElement atBlock;
    public GuiToggleElement forward;
    public GuiElement row;

    public GuiLookModifierPanel(Minecraft mc, LookModifier modifier, GuiModifiersManager modifiers) {
        super(mc, modifier, modifiers);
        this.selector = new GuiTextHelpElement(mc, 500, str -> {
            this.modifiers.editor.postUndo(this.undo((Value)((LookModifier)this.modifier).selector, str));
            ((LookModifier)this.modifier).tryFindingEntity();
        });
        this.selector.link(TARGET_SELECTOR_HELP).tooltip(IKey.lang((String)"aperture.gui.panels.selector"));
        this.blockX = new GuiTrackpadElement(mc, value -> {
            Point point = ((LookModifier)this.modifier).block.get().copy();
            point.x = value;
            this.modifiers.editor.postUndo(this.undo(((LookModifier)this.modifier).block, point));
        });
        this.blockX.tooltip(IKey.lang((String)"aperture.gui.panels.x"));
        this.blockY = new GuiTrackpadElement(mc, value -> {
            Point point = ((LookModifier)this.modifier).block.get().copy();
            point.y = value;
            this.modifiers.editor.postUndo(this.undo(((LookModifier)this.modifier).block, point));
        });
        this.blockY.tooltip(IKey.lang((String)"aperture.gui.panels.y"));
        this.blockZ = new GuiTrackpadElement(mc, value -> {
            Point point = ((LookModifier)this.modifier).block.get().copy();
            point.z = value;
            this.modifiers.editor.postUndo(this.undo(((LookModifier)this.modifier).block, point));
        });
        this.blockZ.tooltip(IKey.lang((String)"aperture.gui.panels.z"));
        this.x = new GuiTrackpadElement(mc, value -> {
            Point point = ((LookModifier)this.modifier).offset.get().copy();
            point.x = value;
            this.modifiers.editor.postUndo(this.undo(((LookModifier)this.modifier).offset, point));
        });
        this.x.tooltip(IKey.lang((String)"aperture.gui.panels.x"));
        this.y = new GuiTrackpadElement(mc, value -> {
            Point point = ((LookModifier)this.modifier).offset.get().copy();
            point.y = value;
            this.modifiers.editor.postUndo(this.undo(((LookModifier)this.modifier).offset, point));
        });
        this.y.tooltip(IKey.lang((String)"aperture.gui.panels.y"));
        this.z = new GuiTrackpadElement(mc, value -> {
            Point point = ((LookModifier)this.modifier).offset.get().copy();
            point.z = value;
            this.modifiers.editor.postUndo(this.undo(((LookModifier)this.modifier).offset, point));
        });
        this.z.tooltip(IKey.lang((String)"aperture.gui.panels.z"));
        this.relative = new GuiToggleElement(mc, IKey.lang((String)"aperture.gui.modifiers.panels.relative"), false, b -> this.modifiers.editor.postUndo(this.undo((Value)((LookModifier)this.modifier).relative, b.isToggled())));
        this.relative.tooltip(IKey.lang((String)"aperture.gui.modifiers.panels.relative_tooltip"));
        this.atBlock = new GuiToggleElement(mc, IKey.lang((String)"aperture.gui.modifiers.panels.at_block"), false, b -> {
            this.modifiers.editor.postUndo(this.undo((Value)((LookModifier)this.modifier).atBlock, b.isToggled()));
            this.updateVisibility(true);
        });
        this.forward = new GuiToggleElement(mc, IKey.lang((String)"aperture.gui.modifiers.panels.forward"), false, b -> this.modifiers.editor.postUndo(this.undo((Value)((LookModifier)this.modifier).forward, b.isToggled())));
        this.forward.tooltip(IKey.lang((String)"aperture.gui.modifiers.panels.forward_tooltip"));
        this.row = Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.blockX, this.blockY, this.blockZ});
        this.updateVisibility(false);
        this.fields.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.relative, this.atBlock}));
        this.fields.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.x, this.y, this.z}));
        this.fields.add((IGuiElement)this.forward);
    }

    @Override
    public void fillData() {
        super.fillData();
        this.selector.setText((String)((LookModifier)this.modifier).selector.get());
        this.blockX.setValue(((LookModifier)this.modifier).block.get().x);
        this.blockY.setValue(((LookModifier)this.modifier).block.get().y);
        this.blockZ.setValue(((LookModifier)this.modifier).block.get().z);
        this.x.setValue(((LookModifier)this.modifier).offset.get().x);
        this.y.setValue(((LookModifier)this.modifier).offset.get().y);
        this.z.setValue(((LookModifier)this.modifier).offset.get().z);
        this.relative.toggled(((Boolean)((LookModifier)this.modifier).relative.get()).booleanValue());
        this.atBlock.toggled(((Boolean)((LookModifier)this.modifier).atBlock.get()).booleanValue());
        this.forward.toggled(((Boolean)((LookModifier)this.modifier).forward.get()).booleanValue());
        this.updateVisibility(false);
    }

    public GuiContextMenu createContextMenu(GuiContext context) {
        if (((Boolean)((LookModifier)this.modifier).atBlock.get()).booleanValue()) {
            return new GuiSimpleContextMenu(this.mc).action(Icons.VISIBLE, IKey.lang((String)"aperture.gui.panels.context.look_coords"), () -> this.rayTrace(false)).action(Icons.BLOCK, IKey.lang((String)"aperture.gui.panels.context.look_block"), () -> this.rayTrace(true));
        }
        return super.createContextMenu(context);
    }

    private void rayTrace(boolean center) {
        RayTraceResult result;
        RayTraceResult rayTraceResult = result = center ? RayTracing.rayTrace((Entity)this.mc.field_71439_g, (double)128.0, (float)0.0f) : RayTracing.rayTraceWithEntity((Entity)this.mc.field_71439_g, (double)128.0);
        if (result != null) {
            if (center && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos pos = result.func_178782_a();
                this.modifiers.editor.postUndo(this.undo(((LookModifier)this.modifier).block, new Point((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5)));
                this.fillData();
            } else if (!center && result.field_72313_a != RayTraceResult.Type.MISS) {
                Vec3d vec = result.field_72307_f;
                this.modifiers.editor.postUndo(this.undo(((LookModifier)this.modifier).block, new Point(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c)));
                this.fillData();
            }
        }
    }

    private void updateVisibility(boolean resize) {
        boolean atBlock = (Boolean)((LookModifier)this.modifier).atBlock.get();
        this.row.removeFromParent();
        this.selector.removeFromParent();
        if (atBlock) {
            this.fields.prepend((IGuiElement)this.row);
        } else {
            this.fields.prepend((IGuiElement)this.selector);
        }
        if (resize) {
            this.getParent().resize();
        }
    }
}

