/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui.panels.modifiers;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.ModifierRegistry;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.aperture.client.gui.GuiModifiersManager;
import mchorse.aperture.client.gui.panels.modifiers.widgets.GuiEnvelope;
import mchorse.aperture.utils.APIcons;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.ColorUtils;
import mchorse.mclib.utils.undo.IUndo;
import net.minecraft.client.Minecraft;

public abstract class GuiAbstractModifierPanel<T extends AbstractModifier>
extends GuiElement {
    public T modifier;
    public GuiModifiersManager modifiers;
    public GuiLabel title;
    public int color;
    public GuiIconElement enable;
    public GuiIconElement remove;
    public GuiIconElement moveUp;
    public GuiIconElement moveDown;
    public GuiIconElement copy;
    public GuiIconElement envelope;
    public GuiElement header;
    public GuiElement buttons;
    public GuiElement fields;
    public GuiEnvelope envelopes;

    public GuiAbstractModifierPanel(Minecraft mc, T modifier, GuiModifiersManager modifiers) {
        super(mc);
        this.modifier = modifier;
        this.modifiers = modifiers;
        this.fields = new GuiElement(mc);
        this.fields.flex().column(5).vertical().stretch().height(20).padding(10);
        this.envelopes = new GuiEnvelope(mc, this);
        this.enable = new GuiIconElement(mc, Icons.NONE, b -> {
            this.modifiers.editor.postUndo(this.undo((Value)((AbstractModifier)this.modifier).enabled, (Boolean)((AbstractModifier)this.modifier).enabled.get() == false));
            this.updateEnable();
        });
        this.enable.tooltip(IKey.lang((String)"aperture.gui.modifiers.tooltips.lock"));
        this.remove = new GuiIconElement(mc, Icons.REMOVE, b -> this.modifiers.removeModifier(this));
        this.remove.tooltip(IKey.lang((String)"aperture.gui.modifiers.tooltips.remove"));
        this.moveUp = new GuiIconElement(mc, Icons.MOVE_UP, b -> this.modifiers.moveModifier(this, -1));
        this.moveUp.tooltip(IKey.lang((String)"aperture.gui.modifiers.tooltips.move_up"));
        this.moveDown = new GuiIconElement(mc, Icons.MOVE_DOWN, b -> this.modifiers.moveModifier(this, 1));
        this.moveDown.tooltip(IKey.lang((String)"aperture.gui.modifiers.tooltips.move_down"));
        this.copy = new GuiIconElement(mc, Icons.COPY, b -> this.modifiers.setClipboard((AbstractModifier)this.modifier));
        this.copy.tooltip(IKey.lang((String)"aperture.gui.modifiers.tooltips.copy"));
        this.envelope = new GuiIconElement(mc, APIcons.ENVELOPE, b -> {
            this.envelopes.updateVisibility();
            this.updateEnvelopes();
        });
        this.envelope.tooltip(IKey.lang((String)"aperture.gui.modifiers.tooltips.envelope"));
        this.header = new GuiElement(mc);
        this.header.flex().h(15);
        this.buttons = new GuiElement(mc);
        this.buttons.flex().relative(this.header).wh(1.0f, 1.0f);
        this.remove.flex().relative(this.header).set(-20.0f, 5.0f, 20.0f, 20.0f).x(1.0f, -30);
        this.enable.flex().relative((GuiElement)this.remove).set(-20.0f, 0.0f, 20.0f, 20.0f);
        this.moveUp.flex().relative((GuiElement)this.enable).set(-20.0f, 2.0f, 20.0f, 8.0f);
        this.moveDown.flex().relative((GuiElement)this.enable).set(-20.0f, 10.0f, 20.0f, 8.0f);
        this.copy.flex().relative((GuiElement)this.moveUp).set(-20.0f, -2.0f, 20.0f, 20.0f);
        this.envelope.flex().relative((GuiElement)this.copy).set(-20.0f, 0.0f, 20.0f, 20.0f);
        this.buttons.add(new IGuiElement[]{this.remove, this.enable, this.moveUp, this.moveDown, this.copy, this.envelope});
        this.flex().column(0).vertical().stretch();
        this.add(new IGuiElement[]{this.header, this.fields});
        String key = ModifierRegistry.CLIENT.get(modifier.getClass()).title;
        this.title = Elements.label((IKey)IKey.lang((String)key));
        this.title.anchor(0.0f, 0.5f).flex().relative(this.header).x(10).y(5).w(0.5f, -10).h(20);
        this.title.tooltip(IKey.lang((String)(key + "_description")));
        this.color = ModifierRegistry.CLIENT.get(this.modifier.getClass()).color.getRGBColor();
        this.header.add(new IGuiElement[]{this.title, this.buttons});
    }

    public IUndo<CameraProfile> undo(Value property, Object value) {
        return this.modifiers.undo(property, value);
    }

    public void handleUndo(IUndo<CameraProfile> undo, boolean redo) {
    }

    public void initiate() {
        this.envelopes.initiate();
    }

    public void fillData() {
        this.envelopes.fillData();
        this.updateEnvelopes();
        this.updateEnable();
    }

    public void updateDuration() {
        this.envelopes.updateDuration();
    }

    private void updateEnvelopes() {
        this.envelopes.removeFromParent();
        this.fields.removeFromParent();
        if (((Boolean)((AbstractModifier)this.modifier).envelope.get().visible.get()).booleanValue()) {
            this.add((IGuiElement)this.envelopes);
        } else {
            this.add((IGuiElement)this.fields);
        }
        if (this.parent != null) {
            this.parent.resize();
            this.envelopes.wasToggled();
        }
    }

    private void updateEnable() {
        this.enable.both((Boolean)((AbstractModifier)this.modifier).enabled.get() != false ? Icons.UNLOCKED : Icons.LOCKED);
    }

    public void draw(GuiContext context) {
        if (((Boolean)((AbstractModifier)this.modifier).enabled.get()).booleanValue()) {
            this.area.draw(-2013265920 + this.color);
        } else {
            ColorUtils.bindColor((int)(-2013265920 + this.color));
            Icons.DISABLED.renderArea(this.area.x, this.area.y, this.area.w, this.area.h);
        }
        this.buttons.setVisible(this.area.isInside(context.mouseX, context.mouseY));
        super.draw(context);
    }
}

