/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui.panels;

import javax.vecmath.Vector2d;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.InterpolationType;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.PathFixture;
import mchorse.aperture.camera.values.ValuePosition;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.panels.GuiAbstractFixturePanel;
import mchorse.aperture.client.gui.panels.modules.GuiAngleModule;
import mchorse.aperture.client.gui.panels.modules.GuiInterpModule;
import mchorse.aperture.client.gui.panels.modules.GuiPointModule;
import mchorse.aperture.client.gui.panels.modules.GuiPointsModule;
import mchorse.aperture.client.gui.utils.GuiCameraEditorKeyframesGraphEditor;
import mchorse.aperture.client.gui.utils.GuiGraphView;
import mchorse.aperture.client.gui.utils.undo.FixturePointsChangeUndo;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.undo.CompoundUndo;
import mchorse.mclib.utils.undo.IUndo;
import net.minecraft.client.Minecraft;

public class GuiPathFixturePanel
extends GuiAbstractFixturePanel<PathFixture> {
    public GuiPointModule point;
    public GuiAngleModule angle;
    public GuiPointsModule points;
    public GuiInterpModule interp;
    public GuiToggleElement useSpeed;
    public GuiCameraEditorKeyframesGraphEditor speed;
    public GuiElement circular;
    public GuiToggleElement autoCenter;
    public GuiTrackpadElement circularX;
    public GuiTrackpadElement circularZ;
    public ValuePosition position;
    private long update;

    public GuiPathFixturePanel(Minecraft mc, GuiCameraEditor editor) {
        super(mc, editor);
        this.point = new GuiPointModule(mc, editor);
        this.angle = new GuiAngleModule(mc, editor);
        this.points = new GuiPointsModule(mc, editor, this::pickPoint);
        this.interp = new GuiInterpModule(mc, editor, this);
        this.useSpeed = new GuiToggleElement(mc, IKey.lang((String)"aperture.gui.panels.use_speed_enable"), false, b -> {
            this.editor.postUndo(this.undo((Value)((PathFixture)this.fixture).useSpeed, b.isToggled()));
            boolean useSpeed = (Boolean)((PathFixture)this.fixture).useSpeed.get();
            this.speed.setVisible(useSpeed);
            this.updateSpeedPanel();
            if (useSpeed) {
                ((PathFixture)this.fixture).updateSpeedCache();
            }
        });
        this.speed = new GuiCameraEditorKeyframesGraphEditor(mc, editor);
        this.autoCenter = new GuiToggleElement(mc, IKey.lang((String)"aperture.gui.panels.auto_center"), b -> {
            IUndo<CameraProfile> undo = this.undo((Value)((PathFixture)this.fixture).circularAutoCenter, b.isToggled());
            if (!b.isToggled()) {
                Vector2d center = ((PathFixture)this.fixture).calculateCenter(new Vector2d());
                this.circularX.setValue(center.x);
                this.circularZ.setValue(center.y);
                this.editor.postUndo((IUndo<CameraProfile>)new CompoundUndo(new IUndo[]{undo, this.undo((Value)((PathFixture)this.fixture).circularX, center.x), this.undo((Value)((PathFixture)this.fixture).circularZ, center.y)}).noMerging());
            } else {
                this.editor.postUndo(undo);
            }
            this.updateCircular();
        });
        this.circularX = new GuiTrackpadElement(mc, value -> this.editor.postUndo(this.undo((Value)((PathFixture)this.fixture).circularX, value)));
        this.circularX.tooltip(IKey.lang((String)"aperture.gui.panels.circular_x"));
        this.circularZ = new GuiTrackpadElement(mc, value -> this.editor.postUndo(this.undo((Value)((PathFixture)this.fixture).circularZ, value)));
        this.circularZ.tooltip(IKey.lang((String)"aperture.gui.panels.circular_z"));
        this.circular = new GuiElement(mc);
        this.circular.flex().column(5).vertical().stretch().height(20);
        this.circular.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"aperture.gui.panels.circular")).background(), this.autoCenter});
        this.points.flex().relative((IResizer)this.left.flex()).x(1.0f, 40).y(1.0f, -30).wTo((IResizer)this.right.flex(), -80).h(20);
        this.speed.flex().relative((GuiElement)this).y(0.55f, 0).w(1.0f).h(0.45f);
        this.left.flex().w(140);
        this.left.add((IGuiElement)this.interp);
        this.left.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"aperture.gui.panels.use_speed")).background(), this.useSpeed});
        this.left.markContainer();
        this.right.add(new IGuiElement[]{this.point, this.angle});
        this.prepend((IGuiElement)this.speed);
        this.add((IGuiElement)this.points);
        this.keys().register(IKey.lang((String)"aperture.gui.panels.keys.velocity"), 18, () -> this.useSpeed.clickItself(GuiBase.getCurrent())).held(new int[]{42}).active(editor::isFlightDisabled).category(CATEGORY);
    }

    @Override
    public void handleUndo(IUndo<CameraProfile> undo, boolean redo) {
        super.handleUndo(undo, redo);
        if (undo instanceof FixturePointsChangeUndo) {
            FixturePointsChangeUndo points = (FixturePointsChangeUndo)undo;
            this.pickPoint(redo ? points.getPoint() : points.getLastPoint());
        }
    }

    @Override
    public void updateDurationSettings() {
        super.updateDurationSettings();
        this.speed.updateConverter();
    }

    public void interpolationWasUpdated(boolean position) {
        if (position) {
            this.updateCircular();
        }
    }

    private void updateCircular() {
        this.circular.removeFromParent();
        this.circularX.removeFromParent();
        this.circularZ.removeFromParent();
        if (!this.autoCenter.isToggled()) {
            this.circular.add((IGuiElement)this.circularX);
            this.circular.add((IGuiElement)this.circularZ);
        }
        if (((PathFixture)this.fixture).interpolation.get() == InterpolationType.CIRCULAR) {
            this.right.add((IGuiElement)this.circular);
        }
        this.right.resize();
    }

    private void updateSpeedPanel() {
        if (((Boolean)((PathFixture)this.fixture).useSpeed.get()).booleanValue()) {
            this.left.flex().hTo((IResizer)this.speed.area);
            this.right.flex().hTo((IResizer)this.speed.area);
        } else {
            this.left.flex().hTo((IResizer)this.area, 1.0f);
            this.right.flex().hTo((IResizer)this.area, 1.0f);
        }
        this.resize();
    }

    @Override
    public void profileWasUpdated() {
        if (((Boolean)((PathFixture)this.fixture).useSpeed.get()).booleanValue()) {
            this.update = System.currentTimeMillis() + 100L;
        }
    }

    private ValuePosition getPosition(int index) {
        Value value = (Value)((PathFixture)this.fixture).points.getSubValues().get(index);
        return value instanceof ValuePosition ? (ValuePosition)value : null;
    }

    public void pickPoint(int index) {
        this.points.setIndex(index);
        this.position = this.getPosition(index);
        this.point.fill(this.position.getPoint());
        this.angle.fill(this.position.getAngle());
        this.setDuration(((PathFixture)this.fixture).getDuration());
        if (this.editor.isSyncing()) {
            this.editor.timeline.setValueFromScrub((int)this.currentOffset());
        }
    }

    @Override
    public void select(PathFixture fixture, long duration) {
        super.select(fixture, duration);
        int index = this.points.index;
        if (duration != -1L) {
            index = (int)((float)duration / (float)fixture.getDuration() * (float)fixture.size());
        } else if (index >= fixture.size()) {
            index = 0;
        }
        this.position = this.getPosition(index);
        this.points.index = index;
        this.point.fill(this.position.getPoint());
        this.angle.fill(this.position.getAngle());
        this.points.fill(fixture);
        this.interp.fill(fixture);
        this.useSpeed.toggled(((Boolean)fixture.useSpeed.get()).booleanValue());
        this.updateSpeedPanel();
        ((GuiGraphView)this.speed.graph).setDuration(fixture.getDuration());
        this.speed.setChannel(fixture.speed, 35071);
        this.speed.setVisible((Boolean)((PathFixture)this.fixture).useSpeed.get());
        this.autoCenter.toggled(((Boolean)((PathFixture)this.fixture).circularAutoCenter.get()).booleanValue());
        this.circularX.setValue(((Double)((PathFixture)this.fixture).circularX.get()).doubleValue());
        this.circularZ.setValue(((Double)((PathFixture)this.fixture).circularZ.get()).doubleValue());
        this.updateCircular();
        this.points.index = index;
    }

    @Override
    public long currentOffset() {
        long point = ((PathFixture)this.fixture).getTickForPoint(this.points.index);
        if (point == ((PathFixture)this.fixture).getDuration()) {
            --point;
        }
        return super.currentOffset() + point;
    }

    @Override
    public void editFixture(Position position) {
        if (this.position != null) {
            this.editor.postUndo(this.undo(this.position, position));
            super.editFixture(position);
        }
    }

    @Override
    protected void updateDuration(long value) {
        super.updateDuration(value);
        ((GuiGraphView)this.speed.graph).setDuration((int)value);
    }

    public void draw(GuiContext context) {
        if (((Boolean)((PathFixture)this.fixture).useSpeed.get()).booleanValue() && this.update > 0L && System.currentTimeMillis() >= this.update) {
            ((PathFixture)this.fixture).updateSpeedCache();
            this.update = 0L;
        }
        super.draw(context);
    }
}

