/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui.panels;

import java.util.List;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.data.RenderFrame;
import mchorse.aperture.camera.fixtures.ManualFixture;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.panels.GuiAbstractFixturePanel;
import mchorse.aperture.utils.APIcons;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.Timer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;

public class GuiManualFixturePanel
extends GuiAbstractFixturePanel<ManualFixture> {
    public static boolean recording;
    public static int duration;
    public static int tick;
    public static int offset;
    public static Timer timer;
    public GuiTrackpadElement shift;
    public GuiTrackpadElement speed;
    public GuiButtonElement record;

    public static void update() {
        if (!recording) {
            return;
        }
        if (tick >= duration) {
            ClientProxy.openCameraEditor();
        } else {
            ++tick;
        }
    }

    public static void drawHUD(int w, int h) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        if (timer.checkReset()) {
            recording = true;
            ClientProxy.getCameraEditor().postPlayback(offset, true);
        } else if (GuiManualFixturePanel.timer.enabled) {
            long remaining = timer.getRemaining();
            float factor = (float)(remaining % 1000L) / 1000.0f * 3.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(w / 2), (float)(h / 2), (float)0.0f);
            GlStateManager.func_179152_a((float)factor, (float)factor, (float)1.0f);
            String label = String.valueOf(remaining / 1000L + 1L);
            font.func_175063_a(label, (float)(-font.func_78256_a(label) / 2), -4.0f, 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
        if (recording) {
            String caption = "Recording\u00a7r (\u00a7l" + tick + "\u00a7r)";
            APIcons.RECORD.render(4, 4, 0.0f, 0.0f);
            font.func_175063_a(caption, 22.0f, 8.0f, -1);
        }
    }

    public GuiManualFixturePanel(Minecraft mc, GuiCameraEditor editor) {
        super(mc, editor);
        this.shift = new GuiTrackpadElement(mc, v -> this.editor.postUndo(this.undo((Value)((ManualFixture)this.fixture).shift, v.intValue())));
        this.shift.integer().tooltip(IKey.lang((String)"aperture.gui.panels.manual.shift"));
        this.speed = new GuiTrackpadElement(mc, v -> this.editor.postUndo(this.undo((Value)((ManualFixture)this.fixture).speed, Float.valueOf(v.floatValue()))));
        this.speed.limit(0.0).tooltip(IKey.lang((String)"aperture.gui.panels.manual.speed"));
        this.record = new GuiButtonElement(mc, IKey.lang((String)"aperture.gui.record"), this::startRecording);
        this.record.tooltip(IKey.lang((String)"aperture.gui.panels.manual.record"));
        this.left.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"aperture.gui.panels.manual.title")).background(), this.shift, this.speed, this.record});
        this.keys().register(IKey.lang((String)"aperture.gui.panels.keys.record_manual"), 19, () -> this.record.clickItself(GuiBase.getCurrent())).held(new int[]{29}).active(editor::isFlightDisabled).category(CATEGORY);
    }

    @Override
    public void select(ManualFixture fixture, long duration) {
        super.select(fixture, duration);
        this.shift.setValue((double)((Integer)fixture.shift.get()).intValue());
        this.speed.setValue((double)((Float)fixture.speed.get()).floatValue());
    }

    private void startRecording(GuiButtonElement button) {
        offset = (int)this.editor.getProfile().calculateOffset(this.fixture);
        duration = (int)((ManualFixture)this.fixture).getDuration();
        tick = 0;
        timer.mark();
        this.editor.postRewind(offset);
        this.editor.exit();
    }

    @Override
    public void cameraEditorOpened() {
        super.cameraEditorOpened();
        if (recording) {
            List<List<RenderFrame>> frames;
            recording = false;
            if (tick > 0 && (frames = ((ManualFixture)this.fixture).setupRecorded()) != null) {
                this.editor.postUndo(this.undo(((ManualFixture)this.fixture).frames, frames));
            }
        } else {
            timer.reset();
        }
    }

    public void recordFrame(EntityPlayerSP player, float partialTicks) {
        ((ManualFixture)this.fixture).recordFrame((EntityPlayer)player, partialTicks);
    }

    static {
        timer = new Timer(3000L);
    }
}

