/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui.panels;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.KeyframeFixture;
import mchorse.aperture.camera.values.ValueKeyframeChannel;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.panels.GuiAbstractFixturePanel;
import mchorse.aperture.client.gui.utils.GuiCameraEditorKeyframesDopeSheetEditor;
import mchorse.aperture.client.gui.utils.GuiCameraEditorKeyframesEditor;
import mchorse.aperture.client.gui.utils.GuiCameraEditorKeyframesGraphEditor;
import mchorse.aperture.client.gui.utils.GuiDopeSheet;
import mchorse.aperture.client.gui.utils.GuiGraphView;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.keyframes.KeyframeChannel;
import mchorse.mclib.utils.undo.CompoundUndo;
import mchorse.mclib.utils.undo.IUndo;
import net.minecraft.client.Minecraft;

public class GuiKeyframeFixturePanel
extends GuiAbstractFixturePanel<KeyframeFixture> {
    public GuiElement buttons;
    public GuiButtonElement all;
    public GuiButtonElement x;
    public GuiButtonElement y;
    public GuiButtonElement z;
    public GuiButtonElement yaw;
    public GuiButtonElement pitch;
    public GuiButtonElement roll;
    public GuiButtonElement fov;
    public GuiButtonElement distance;
    public GuiCameraEditorKeyframesGraphEditor graph;
    public GuiCameraEditorKeyframesDopeSheetEditor dope;
    public IKey[] titles = new IKey[9];
    public int[] colors = new int[]{15014195, 1697075, 3348965, 1690853, 13375973, 15059993, 0xBFBFBF, 0x777777};
    private IKey title = IKey.EMPTY;
    private GuiElement current;

    public GuiKeyframeFixturePanel(Minecraft mc, GuiCameraEditor editor) {
        super(mc, editor);
        this.buttons = new GuiElement(mc);
        this.graph = new GuiCameraEditorKeyframesGraphEditor(mc, this.editor);
        this.dope = new GuiCameraEditorKeyframesDopeSheetEditor(mc, this.editor);
        this.all = new GuiButtonElement(mc, IKey.lang((String)"aperture.gui.panels.all"), b -> this.selectChannel(null, 0));
        this.x = new GuiButtonElement(mc, IKey.lang((String)"aperture.gui.panels.x"), b -> this.selectChannel(((KeyframeFixture)this.fixture).x, 1));
        this.y = new GuiButtonElement(mc, IKey.lang((String)"aperture.gui.panels.y"), b -> this.selectChannel(((KeyframeFixture)this.fixture).y, 2));
        this.z = new GuiButtonElement(mc, IKey.lang((String)"aperture.gui.panels.z"), b -> this.selectChannel(((KeyframeFixture)this.fixture).z, 3));
        this.yaw = new GuiButtonElement(mc, IKey.lang((String)"aperture.gui.panels.yaw"), b -> this.selectChannel(((KeyframeFixture)this.fixture).yaw, 4));
        this.pitch = new GuiButtonElement(mc, IKey.lang((String)"aperture.gui.panels.pitch"), b -> this.selectChannel(((KeyframeFixture)this.fixture).pitch, 5));
        this.roll = new GuiButtonElement(mc, IKey.lang((String)"aperture.gui.panels.roll"), b -> this.selectChannel(((KeyframeFixture)this.fixture).roll, 6));
        this.fov = new GuiButtonElement(mc, IKey.lang((String)"aperture.gui.panels.fov"), b -> this.selectChannel(((KeyframeFixture)this.fixture).fov, 7));
        this.distance = new GuiButtonElement(mc, IKey.lang((String)"aperture.gui.panels.distance"), b -> this.selectChannel(((KeyframeFixture)this.fixture).distance, 8));
        this.buttons.add((IGuiElement)this.all);
        this.buttons.add(new IGuiElement[]{this.x, this.y, this.z});
        this.buttons.add(new IGuiElement[]{this.yaw, this.pitch, this.roll, this.fov});
        this.buttons.add((IGuiElement)this.distance);
        for (int i = 0; i < this.titles.length; ++i) {
            this.titles[i] = ((GuiButtonElement)this.buttons.getChildren().get((int)i)).label;
        }
        this.buttons.flex().relative((GuiElement)this.graph).x(10).y(-25).w(1.0f).h(20).row(5).resize().height(20).padding(0);
        this.graph.flex().relative((GuiElement)this).y(0.5f, 0).wh(1.0f, 0.5f);
        this.dope.flex().relative((GuiElement)this).y(0.5f, 0).wh(1.0f, 0.5f);
        this.add(new IGuiElement[]{this.graph, this.dope, this.buttons});
        this.keys().register(IKey.lang((String)"aperture.gui.panels.keys.toggle_keyframes"), 49, this::toggleKeyframes).category(CATEGORY);
    }

    private void toggleKeyframes() {
        if (this.current != null) {
            this.buttons.toggleVisible();
            this.current.toggleVisible();
        }
    }

    @Override
    public void updateDurationSettings() {
        super.updateDurationSettings();
        this.dope.updateConverter();
        this.graph.updateConverter();
    }

    @Override
    public void select(KeyframeFixture fixture, long duration) {
        boolean same = this.fixture == fixture;
        super.select(fixture, duration);
        this.graph.interpolations.setVisible(false);
        ((GuiGraphView)this.graph.graph).setDuration(fixture.getDuration());
        ((GuiDopeSheet)this.dope.graph).setDuration(fixture.getDuration());
        if (!same) {
            this.dope.setFixture(fixture);
            this.selectChannel(null, 0);
        }
        if (duration != -1L) {
            ((GuiGraphView)this.graph.graph).selectByDuration(duration);
            ((GuiDopeSheet)this.dope.graph).selectByDuration(duration);
        }
    }

    @Override
    protected void updateDuration(long value) {
        super.updateDuration(value);
        ((GuiGraphView)this.graph.graph).setDuration(value);
        ((GuiDopeSheet)this.dope.graph).setDuration(value);
    }

    public void selectChannel(ValueKeyframeChannel channel, int id) {
        this.title = this.titles[id];
        this.dope.setVisible(id == 0);
        this.graph.setVisible(id != 0);
        this.buttons.setVisible(true);
        GuiCameraEditorKeyframesEditor guiCameraEditorKeyframesEditor = this.current = id == 0 ? this.dope : this.graph;
        if (channel != null) {
            this.graph.setChannel(channel, this.colors[id - 1]);
        }
    }

    @Override
    public void editFixture(Position position) {
        long tick = (long)this.editor.timeline.value - this.currentOffset();
        double x = position.point.x;
        double y = position.point.y;
        double z = position.point.z;
        float yaw = position.angle.yaw;
        float pitch = position.angle.pitch;
        float distance = ((KeyframeFixture)this.fixture).distance.get().isEmpty() ? 0.0f : (float)((KeyframeFixture)this.fixture).distance.get().interpolate((float)tick) + 0.05f;
        float distYaw = (float)((double)distance * Math.cos(Math.toRadians(pitch)));
        CompoundUndo undo = new CompoundUndo(new IUndo[]{this.undoKeyframes(((KeyframeFixture)this.fixture).x, tick, x -= (double)distYaw * Math.sin(Math.toRadians(yaw))), this.undoKeyframes(((KeyframeFixture)this.fixture).y, tick, y -= (double)distance * Math.sin(Math.toRadians(pitch))), this.undoKeyframes(((KeyframeFixture)this.fixture).z, tick, z += (double)distYaw * Math.cos(Math.toRadians(yaw))), this.undoKeyframes(((KeyframeFixture)this.fixture).yaw, tick, position.angle.yaw), this.undoKeyframes(((KeyframeFixture)this.fixture).pitch, tick, position.angle.pitch), this.undoKeyframes(((KeyframeFixture)this.fixture).roll, tick, position.angle.roll), this.undoKeyframes(((KeyframeFixture)this.fixture).fov, tick, position.angle.fov), this.undoKeyframes(((KeyframeFixture)this.fixture).distance, tick, distance - 0.05f)});
        this.editor.postUndo((IUndo<CameraProfile>)undo, false);
    }

    private IUndo<CameraProfile> undoKeyframes(ValueKeyframeChannel channel, long tick, double value) {
        KeyframeChannel c = (KeyframeChannel)channel.getValue();
        c.insert(tick, value);
        IUndo<CameraProfile> undo = this.undo(channel, c);
        channel.get().insert(tick, value);
        return undo;
    }

    public void resize() {
        for (IGuiElement element : this.buttons.getChildren()) {
            GuiButtonElement button = (GuiButtonElement)element;
            button.flex().w(this.font.func_78256_a(button.label.get()) + 10);
        }
        super.resize();
    }

    public void draw(GuiContext context) {
        this.font.func_175063_a(this.title.get(), (float)(this.area.ex() - this.font.func_78256_a(this.title.get()) - 10), (float)(this.graph.area.y - this.font.field_78288_b - 5), 0xFFFFFF);
        super.draw(context);
    }
}

