/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui.panels;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.DollyFixture;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.panels.GuiAbstractFixturePanel;
import mchorse.aperture.client.gui.panels.modules.GuiAngleModule;
import mchorse.aperture.client.gui.panels.modules.GuiPointModule;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiInterpolationList;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.tooltips.ITooltip;
import mchorse.mclib.client.gui.framework.tooltips.InterpolationTooltip;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.Interpolation;
import mchorse.mclib.utils.undo.CompoundUndo;
import mchorse.mclib.utils.undo.IUndo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;

public class GuiDollyFixturePanel
extends GuiAbstractFixturePanel<DollyFixture> {
    public GuiPointModule point;
    public GuiAngleModule angle;
    public GuiTrackpadElement distance;
    public GuiIconElement reverse;
    public GuiButtonElement pickInterp;
    public GuiInterpolationList interps;
    public GuiTrackpadElement yaw;
    public GuiTrackpadElement pitch;

    public GuiDollyFixturePanel(Minecraft mc, GuiCameraEditor editor) {
        super(mc, editor);
        this.point = new GuiPointModule(mc, editor);
        this.angle = new GuiAngleModule(mc, editor);
        this.distance = new GuiTrackpadElement(mc, value -> this.editor.postUndo(this.undo((Value)((DollyFixture)this.fixture).distance, Float.valueOf(value.floatValue()))));
        this.distance.tooltip(IKey.lang((String)"aperture.gui.panels.dolly.distance"));
        this.reverse = new GuiIconElement(mc, Icons.REVERSE, b -> this.reverse());
        this.reverse.tooltip(IKey.lang((String)"aperture.gui.panels.dolly.reverse"));
        this.yaw = new GuiTrackpadElement(mc, value -> this.editor.postUndo(this.undo((Value)((DollyFixture)this.fixture).yaw, Float.valueOf(value.floatValue()))));
        this.yaw.tooltip(IKey.lang((String)"aperture.gui.panels.dolly.yaw"));
        this.pitch = new GuiTrackpadElement(mc, value -> this.editor.postUndo(this.undo((Value)((DollyFixture)this.fixture).pitch, Float.valueOf(value.floatValue()))));
        this.pitch.tooltip(IKey.lang((String)"aperture.gui.panels.dolly.pitch"));
        InterpolationTooltip tooltip = new InterpolationTooltip(1.0f, 0.0f, () -> ((DollyFixture)this.fixture).interp.get(), null);
        this.pickInterp = new GuiButtonElement(mc, IKey.lang((String)""), b -> {
            if (this.interps.hasParent()) {
                this.interps.removeFromParent();
            } else {
                this.interps.setCurrent((Object)((DollyFixture)this.fixture).interp.get());
                this.add((IGuiElement)this.interps);
                this.interps.flex().relative((GuiElement)this.pickInterp);
                this.interps.resize();
            }
        });
        this.pickInterp.tooltip((ITooltip)tooltip);
        this.interps = new GuiInterpolationList(mc, interp -> {
            this.editor.postUndo(this.undo(((DollyFixture)this.fixture).interp, interp.get(0)));
            this.pickInterp.label.set(((Interpolation)interp.get(0)).getKey());
            this.editor.updateProfile();
        });
        this.interps.tooltip((ITooltip)tooltip).markIgnored().flex().y(1.0f).w(1.0f).h(96);
        this.right.add(new IGuiElement[]{this.point, this.angle});
        this.left.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"aperture.gui.fixtures.dolly")).background(), Elements.row((Minecraft)mc, (int)0, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.distance, this.reverse}), this.yaw, this.pitch, this.pickInterp});
    }

    private void reverse() {
        Position position = new Position();
        ((DollyFixture)this.fixture).applyLast(this.editor.getProfile(), position);
        this.editor.postUndo((IUndo<CameraProfile>)new CompoundUndo(new IUndo[]{this.undo(((DollyFixture)this.fixture).position, position), this.undo((Value)((DollyFixture)this.fixture).distance, Float.valueOf(-((Float)((DollyFixture)this.fixture).distance.get()).floatValue()))}));
        this.select((DollyFixture)this.fixture, 0L);
    }

    @Override
    public void select(DollyFixture fixture, long duration) {
        super.select(fixture, duration);
        this.point.fill(fixture.position.getPoint());
        this.angle.fill(fixture.position.getAngle());
        this.yaw.setValue((double)((Float)fixture.yaw.get()).floatValue());
        this.pitch.setValue((double)((Float)fixture.pitch.get()).floatValue());
        this.distance.setValue((double)((Float)fixture.distance.get()).floatValue());
        this.interps.removeFromParent();
        this.interps.setCurrent((Object)fixture.interp.get());
        this.pickInterp.label.set(fixture.interp.get().getKey());
    }

    @Override
    public void editFixture(Position position) {
        this.editor.postUndo((IUndo<CameraProfile>)new CompoundUndo(new IUndo[]{this.undo(((DollyFixture)this.fixture).position, position), this.undo((Value)((DollyFixture)this.fixture).yaw, Float.valueOf(position.angle.yaw)), this.undo((Value)((DollyFixture)this.fixture).pitch, Float.valueOf(position.angle.pitch))}));
        super.editFixture(position);
    }

    public void draw(GuiContext context) {
        double speed = (double)((Float)((DollyFixture)this.fixture).distance.get()).floatValue() / ((double)((DollyFixture)this.fixture).getDuration() / 20.0);
        String label = I18n.func_135052_a((String)"aperture.gui.panels.dolly.speed", (Object[])new Object[]{GuiTrackpadElement.FORMAT.format(speed)});
        GuiDraw.drawTextBackground((FontRenderer)this.font, (String)label, (int)this.area.mx(this.font.func_78256_a(label)), (int)(this.area.ey() - this.font.field_78288_b - 20), (int)0xFFFFFF, (int)-2013265920);
        super.draw(context);
    }
}

