/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui.panels;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.panels.IFixturePanel;
import mchorse.aperture.client.gui.utils.undo.FixtureValueChangeUndo;
import mchorse.aperture.utils.TimeUtils;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiColorElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.undo.IUndo;
import net.minecraft.client.Minecraft;

public abstract class GuiAbstractFixturePanel<T extends AbstractFixture>
extends GuiElement
implements IFixturePanel<T> {
    public static final IKey CATEGORY = IKey.lang((String)"aperture.gui.panels.keys.title");
    public T fixture;
    public GuiCameraEditor editor;
    public GuiScrollElement left;
    public GuiScrollElement right;
    public GuiTextElement name;
    public GuiColorElement color;
    private GuiTrackpadElement duration;

    public static IUndo<CameraProfile> undo(GuiCameraEditor editor, Value property, Object newValue) {
        return GuiAbstractFixturePanel.undo(editor, property, property.getValue(), newValue);
    }

    public static IUndo<CameraProfile> undo(GuiCameraEditor editor, Value property, Object oldValue, Object newValue) {
        CameraProfile profile = editor.getProfile();
        AbstractFixture fixture = editor.getFixture();
        int index = profile.fixtures.indexOf(fixture);
        return new FixtureValueChangeUndo(index, property.getPath(), oldValue, newValue).view(editor.timeline);
    }

    public GuiAbstractFixturePanel(Minecraft mc, GuiCameraEditor editor) {
        super(mc);
        this.editor = editor;
        this.left = new GuiScrollElement(mc);
        this.left.scroll.opposite = true;
        this.left.flex().relative((GuiElement)this).y(20).w(130).hTo((IResizer)this.area, 1.0f).column(5).vertical().stretch().scroll().height(20).padding(10);
        this.right = new GuiScrollElement(mc);
        this.right.flex().relative((GuiElement)this).x(1.0f).y(20).w(130).hTo((IResizer)this.area, 1.0f).anchorX(1.0f).column(5).vertical().stretch().scroll().height(20).padding(10);
        this.name = new GuiTextElement(mc, 80, str -> this.editor.postUndo(this.undo((Value)((AbstractFixture)this.fixture).name, str)));
        this.name.tooltip(IKey.lang((String)"aperture.gui.panels.name_tooltip"));
        this.color = new GuiColorElement(mc, c -> this.editor.postUndo(this.undo((Value)((AbstractFixture)this.fixture).color, c)));
        this.color.target((GuiElement)this).tooltip(IKey.lang((String)"aperture.gui.panels.color_tooltip"));
        this.color.direction(Direction.RIGHT);
        this.duration = new GuiTrackpadElement(mc, value -> {
            this.updateDuration(TimeUtils.fromTime(value));
            this.editor.updatePlayerCurrently();
            this.editor.updateValues();
        });
        this.duration.tooltip(IKey.lang((String)"aperture.gui.panels.duration"));
        this.left.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"aperture.gui.panels.name")).background(), this.name, this.color, this.duration});
        this.add(new IGuiElement[]{this.left, this.right});
    }

    protected IUndo<CameraProfile> undo(Value value, Object newValue) {
        return GuiAbstractFixturePanel.undo(this.editor, value, newValue);
    }

    public void handleUndo(IUndo<CameraProfile> undo, boolean redo) {
        if (undo instanceof FixtureValueChangeUndo && ((FixtureValueChangeUndo)undo).getName().equals(((AbstractFixture)this.fixture).duration.id)) {
            this.editor.updateValues();
        }
    }

    public void setDuration(long ticks) {
        this.duration.setValue(TimeUtils.toTime(ticks));
    }

    public void updateDurationSettings() {
        TimeUtils.configure(this.duration, 1L);
        this.setDuration(((AbstractFixture)this.fixture).getDuration());
    }

    protected void updateDuration(long value) {
        this.editor.postUndo(this.undo((Value)((AbstractFixture)this.fixture).duration, value));
        this.editor.updateDuration((AbstractFixture)this.fixture);
    }

    public void profileWasUpdated() {
    }

    public void cameraEditorOpened() {
        this.updateDurationSettings();
    }

    @Override
    public void select(T fixture, long duration) {
        this.fixture = fixture;
        this.name.setText((String)((AbstractFixture)fixture).name.get());
        this.color.picker.setColor(((Integer)((AbstractFixture)fixture).color.get()).intValue());
        this.updateDurationSettings();
    }

    @Override
    public long currentOffset() {
        return this.editor.getProfile().calculateOffset((AbstractFixture)this.fixture);
    }

    public void editFixture(Position position) {
        this.select(this.fixture, -1L);
        this.editor.updateProfile();
    }
}

