/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui.config;

import mchorse.aperture.Aperture;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.config.GuiAbstractConfigOptions;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiColorElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTexturePicker;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import net.minecraft.client.Minecraft;

public class GuiConfigCameraOptions
extends GuiAbstractConfigOptions {
    public GuiToggleElement outside;
    public GuiToggleElement spectator;
    public GuiToggleElement renderPath;
    public GuiToggleElement sync;
    public GuiToggleElement flight;
    public GuiToggleElement displayPosition;
    public GuiToggleElement essentialsTeleport;
    public GuiColorElement guidesColor;
    public GuiToggleElement ruleOfThirds;
    public GuiToggleElement centerLines;
    public GuiToggleElement crosshair;
    public GuiToggleElement letterBox;
    public GuiTextElement aspectRatio;
    public GuiToggleElement loop;
    public GuiToggleElement overlay;
    public GuiButtonElement pickOverlay;
    public GuiTexturePicker overlayPicker;
    public GuiToggleElement hideChat;

    public GuiConfigCameraOptions(Minecraft mc, GuiCameraEditor editor) {
        super(mc, editor);
        this.outside = new GuiToggleElement(mc, Aperture.outside, b -> {
            if (b.isToggled()) {
                ClientProxy.runner.attachOutside();
                this.editor.updatePlayerCurrently();
            } else {
                ClientProxy.runner.detachOutside();
            }
        });
        this.spectator = new GuiToggleElement(mc, Aperture.spectator);
        this.renderPath = new GuiToggleElement(mc, Aperture.profileRender);
        this.sync = new GuiToggleElement(mc, Aperture.editorSync);
        this.flight = new GuiToggleElement(mc, IKey.lang((String)"aperture.gui.config.flight"), this.editor.flight.isFlightEnabled(), b -> this.editor.setFlight(b.isToggled()));
        this.flight.tooltip(IKey.lang((String)"aperture.gui.config.flight_tooltip"));
        this.displayPosition = new GuiToggleElement(mc, Aperture.editorDisplayPosition);
        this.essentialsTeleport = new GuiToggleElement(mc, Aperture.essentialsTeleport);
        this.guidesColor = new GuiColorElement(mc, Aperture.editorGuidesColor);
        this.guidesColor.picker.editAlpha();
        this.ruleOfThirds = new GuiToggleElement(mc, Aperture.editorRuleOfThirds);
        this.centerLines = new GuiToggleElement(mc, Aperture.editorCenterLines);
        this.crosshair = new GuiToggleElement(mc, Aperture.editorCrosshair);
        this.letterBox = new GuiToggleElement(mc, Aperture.editorLetterbox);
        this.aspectRatio = new GuiTextElement(mc, Aperture.editorLetterboxAspect, this.editor::setAspectRatio);
        this.aspectRatio.setText((String)Aperture.editorLetterboxAspect.get());
        this.loop = new GuiToggleElement(mc, Aperture.editorLoop);
        this.overlay = new GuiToggleElement(mc, Aperture.editorOverlay);
        this.pickOverlay = new GuiButtonElement(mc, IKey.lang((String)"aperture.gui.config.pick_overlay"), b -> {
            this.overlayPicker.refresh();
            this.overlayPicker.fill(this.editor.overlayLocation);
            this.overlayPicker.resize();
            this.editor.top.add((IGuiElement)this.overlayPicker);
        });
        this.overlayPicker = new GuiTexturePicker(mc, rl -> {
            Aperture.editorOverlayRL.set(rl);
            this.editor.updateOverlay();
        });
        this.overlayPicker.flex().relative((IResizer)this.editor.viewport).wh(1.0f, 1.0f);
        this.hideChat = new GuiToggleElement(mc, Aperture.editorHideChat);
        this.add(new IGuiElement[]{this.outside, this.spectator, this.renderPath, this.sync, this.flight, this.displayPosition, this.guidesColor, this.ruleOfThirds, this.centerLines, this.crosshair, this.letterBox, this.aspectRatio, this.loop, this.overlay, this.pickOverlay, this.hideChat});
        if (!mc.func_71356_B()) {
            this.add((IGuiElement)this.essentialsTeleport);
        }
        for (IGuiElement element : this.getChildren()) {
            if (!(element instanceof GuiToggleElement)) continue;
            ((GuiElement)element).flex().h(16);
        }
    }

    @Override
    public void update() {
        this.outside.toggled(((Boolean)Aperture.outside.get()).booleanValue());
        this.spectator.toggled(((Boolean)Aperture.spectator.get()).booleanValue());
        this.renderPath.toggled(((Boolean)Aperture.profileRender.get()).booleanValue());
        this.sync.toggled(((Boolean)Aperture.editorSync.get()).booleanValue());
        this.loop.toggled(((Boolean)Aperture.editorLoop.get()).booleanValue());
        this.flight.toggled(this.editor.flight.isFlightEnabled());
        this.displayPosition.toggled(((Boolean)Aperture.editorDisplayPosition.get()).booleanValue());
        this.essentialsTeleport.toggled(((Boolean)Aperture.essentialsTeleport.get()).booleanValue());
        this.guidesColor.picker.setColor(((Integer)Aperture.editorGuidesColor.get()).intValue());
        this.ruleOfThirds.toggled(((Boolean)Aperture.editorRuleOfThirds.get()).booleanValue());
        this.centerLines.toggled(((Boolean)Aperture.editorCenterLines.get()).booleanValue());
        this.crosshair.toggled(((Boolean)Aperture.editorCrosshair.get()).booleanValue());
        this.letterBox.toggled(((Boolean)Aperture.editorLetterbox.get()).booleanValue());
        this.aspectRatio.setText((String)Aperture.editorLetterboxAspect.get());
        this.overlay.toggled(((Boolean)Aperture.editorOverlay.get()).booleanValue());
        this.hideChat.toggled(((Boolean)Aperture.editorHideChat.get()).booleanValue());
    }

    @Override
    public IKey getTitle() {
        return IKey.lang((String)"aperture.gui.config.title");
    }
}

