/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.CameraAPI;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.destination.AbstractDestination;
import mchorse.aperture.camera.destination.ClientDestination;
import mchorse.aperture.camera.destination.ServerDestination;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.GuiCurves;
import mchorse.aperture.network.Dispatcher;
import mchorse.aperture.network.common.PacketRequestCameraProfiles;
import mchorse.aperture.utils.APIcons;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiSearchListElement;
import mchorse.mclib.client.gui.framework.elements.modals.GuiConfirmModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiPromptModal;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.OpHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;

public class GuiProfilesManager
extends GuiElement {
    public GuiCameraEditor editor;
    public GuiCameraProfilesSearchList profiles;
    public GuiCurves curves;
    public GuiIconElement keyframes;
    public GuiIconElement rename;
    public GuiIconElement convert;
    public GuiIconElement add;
    public GuiIconElement dupe;
    public GuiIconElement remove;

    public GuiProfilesManager(Minecraft mc, GuiCameraEditor editor) {
        super(mc);
        this.editor = editor;
        this.profiles = new GuiCameraProfilesSearchList(mc, entry -> this.pickProfile((CameraProfile)entry.get(0)));
        this.profiles.label(IKey.lang((String)"aperture.gui.search"));
        this.keyframes = new GuiIconElement(mc, APIcons.KEYFRAMES, b -> this.toggleKeyframes());
        this.keyframes.tooltip(IKey.lang((String)"aperture.gui.profiles.keyframes"));
        this.rename = new GuiIconElement(mc, Icons.EDIT, b -> this.rename());
        this.rename.tooltip(IKey.lang((String)"aperture.gui.profiles.rename_tooltip"));
        this.convert = new GuiIconElement(mc, Icons.SERVER, b -> this.convert());
        this.convert.tooltip(IKey.lang((String)"aperture.gui.profiles.convert_tooltip"));
        this.add = new GuiIconElement(mc, Icons.ADD, b -> this.add());
        this.add.tooltip(IKey.lang((String)"aperture.gui.profiles.add_tooltip"));
        this.dupe = new GuiIconElement(mc, Icons.DUPE, b -> this.dupe());
        this.dupe.tooltip(IKey.lang((String)"aperture.gui.profiles.dupe_tooltip"));
        this.remove = new GuiIconElement(mc, Icons.REMOVE, b -> this.remove());
        this.remove.tooltip(IKey.lang((String)"aperture.gui.profiles.remove_tooltip"));
        this.profiles.flex().relative((GuiElement)this).set(10.0f, 28.0f, 0.0f, 0.0f).w(1.0f, -20).h(1.0f, -38);
        this.remove.flex().relative((GuiElement)this).set(0.0f, 4.0f, 20.0f, 20.0f).x(1.0f, -30);
        this.dupe.flex().relative((GuiElement)this.remove).set(-20.0f, 0.0f, 20.0f, 20.0f);
        this.add.flex().relative((GuiElement)this.dupe).set(-20.0f, 0.0f, 20.0f, 20.0f);
        this.rename.flex().relative((GuiElement)this.add).set(-20.0f, 0.0f, 20.0f, 20.0f);
        this.convert.flex().relative((GuiElement)this.rename).set(-20.0f, 0.0f, 20.0f, 20.0f);
        this.keyframes.flex().relative((GuiElement)this.convert).set(-20.0f, 0.0f, 20.0f, 20.0f);
        this.curves = new GuiCurves(mc, editor);
        this.curves.flex().relative((GuiElement)this).set(0.0f, 28.0f, 0.0f, 0.0f).w(1.0f).h(1.0f, -28);
        this.curves.setVisible(false);
        GuiLabel label = Elements.label((IKey)IKey.lang((String)"aperture.gui.profiles.title")).background();
        label.flex().relative((GuiElement)this).set(10.0f, 10.0f, 0.0f, 20.0f);
        this.add(new IGuiElement[]{label, this.profiles, this.curves, this.remove, this.dupe, this.add, this.rename, this.convert, this.keyframes});
    }

    public void updateDuration() {
        this.curves.updateDuration();
    }

    public void pickProfile(CameraProfile profile) {
        if (!profile.exists) {
            profile.getDestination().load();
        }
        this.editor.setProfile(profile);
    }

    public CameraProfile createTemporary() {
        CameraProfile profile = new CameraProfile(AbstractDestination.create("default"));
        this.profiles.list.add((Object)profile);
        this.editor.setProfile(profile);
        return profile;
    }

    private void add() {
        GuiModal.addFullModal((GuiElement)this, () -> new GuiPromptModal(this.mc, IKey.lang((String)"aperture.gui.profiles.add_modal"), this::add).filename());
    }

    private void add(String name) {
        if (name.isEmpty()) {
            return;
        }
        this.addProfile(AbstractDestination.create(name), true);
    }

    private void dupe() {
        CameraProfile entry = (CameraProfile)this.profiles.list.getCurrentFirst();
        if (entry == null) {
            return;
        }
        GuiModal.addFullModal((GuiElement)this, () -> {
            AbstractDestination destination = entry.getDestination();
            GuiPromptModal modal = new GuiPromptModal(this.mc, IKey.lang((String)"aperture.gui.profiles.dupe_modal"), name -> {
                AbstractDestination target = AbstractDestination.fromResourceLocation(destination.toResourceLocation());
                target.setFilename((String)name);
                if (!this.hasCameraProfile(target)) {
                    this.dupe((String)name);
                }
            });
            return modal.filename().setValue(destination.getFilename());
        });
    }

    private void dupe(String name) {
        CameraProfile entry = (CameraProfile)this.profiles.list.getCurrentFirst();
        if (entry != null) {
            CameraProfile profile = entry.copy();
            profile.getDestination().setFilename(name);
            profile.dirty();
            this.profiles.filter("", true);
            this.profiles.list.add((Object)profile);
            this.profiles.list.sort();
            this.editor.setProfile(profile);
        }
    }

    private void rename() {
        CameraProfile entry = (CameraProfile)this.profiles.list.getCurrentFirst();
        if (entry == null) {
            return;
        }
        GuiModal.addFullModal((GuiElement)this, () -> new GuiPromptModal(this.mc, IKey.lang((String)"aperture.gui.profiles.rename_modal"), this::rename).filename().setValue(entry.getDestination().getFilename()));
    }

    private void rename(String name) {
        CameraProfile entry = (CameraProfile)this.profiles.list.getCurrentFirst();
        AbstractDestination dest = entry.getDestination();
        dest.rename(name);
    }

    public void toggleKeyframes() {
        boolean profiles = this.profiles.isVisible();
        this.profiles.setVisible(!profiles);
        this.curves.setVisible(!this.profiles.isVisible());
        if (this.curves.isVisible()) {
            this.curves.update();
        }
    }

    private void convert() {
        AbstractDestination newDest;
        CameraProfile entry = (CameraProfile)this.profiles.list.getCurrentFirst();
        if (entry == null) {
            return;
        }
        AbstractDestination dest = entry.getDestination();
        String filename = dest.getFilename();
        AbstractDestination abstractDestination = newDest = dest instanceof ClientDestination ? new ServerDestination(filename) : new ClientDestination(filename);
        if (!this.hasSimilar(newDest)) {
            entry.setDestination(newDest);
            entry.dirty();
        }
        this.init();
    }

    private boolean hasSimilar(AbstractDestination dest) {
        for (CameraProfile profile : this.profiles.list.getList()) {
            if (!profile.getDestination().equals(dest)) continue;
            return true;
        }
        return false;
    }

    private void remove() {
        GuiModal.addFullModal((GuiElement)this, () -> new GuiConfirmModal(this.mc, IKey.lang((String)"aperture.gui.profiles.remove_modal"), this::remove));
    }

    private void remove(boolean confirmed) {
        if (confirmed) {
            CameraProfile entry = (CameraProfile)this.profiles.list.getCurrentFirst();
            if (entry == null) {
                return;
            }
            int index = this.profiles.list.getIndex();
            this.profiles.list.remove((Object)entry);
            this.profiles.filter("", true);
            entry.getDestination().remove();
            if (this.editor.getProfile() == entry) {
                this.selectFirstAvailable(index);
            }
        }
    }

    public void selectFirstAvailable(int lastIndex) {
        if (this.profiles.list.getList().isEmpty()) {
            this.createTemporary();
        } else {
            if (!this.profiles.list.exists(lastIndex)) {
                lastIndex = MathHelper.func_76125_a((int)lastIndex, (int)0, (int)(this.profiles.list.getList().size() - 1));
            }
            this.profiles.list.setIndex(lastIndex);
            this.profiles.list.scroll.scrollIntoView(this.profiles.list.getIndex(), this.profiles.list.scroll.scrollItemSize);
            this.pickProfile((CameraProfile)this.profiles.list.getCurrentFirst());
        }
    }

    public void selectProfile(CameraProfile profile) {
        this.profiles.list.setCurrentScroll((Object)profile);
    }

    public void rename(AbstractDestination from, String to) {
        CameraProfile profile = this.profiles.getBy(from);
        if (profile != null) {
            profile.getDestination().setFilename(to);
            this.profiles.list.sort();
        }
    }

    public void remove(ServerDestination serverDestination) {
        int index = this.profiles.list.getIndex();
        CameraProfile profile = this.profiles.getBy(serverDestination);
        if (profile != null && profile.exists) {
            this.profiles.list.remove((Object)profile);
            this.selectFirstAvailable(index);
        }
    }

    public void init() {
        this.curves.updateKeyframeEditor();
        this.convert.setEnabled(OpHelper.isPlayerOp());
        if (ClientProxy.server && OpHelper.isPlayerOp()) {
            Dispatcher.sendToServer(new PacketRequestCameraProfiles());
        } else {
            for (String filename : CameraAPI.getClientProfiles()) {
                this.addProfile(new ClientDestination(filename));
            }
            this.profiles.filter("", true);
            this.profiles.list.sort();
            this.selectProfile(ClientProxy.control.currentProfile);
        }
    }

    public void addProfile(AbstractDestination destination) {
        this.addProfile(destination, false);
    }

    public void addProfile(AbstractDestination destination, boolean exists) {
        if (this.hasCameraProfile(destination)) {
            return;
        }
        CameraProfile profile = new CameraProfile(destination);
        profile.exists = exists;
        this.profiles.list.add((Object)profile);
        this.profiles.list.sort();
        if (exists) {
            this.editor.setProfile(profile);
        }
    }

    public void addProfile(CameraProfile newProfile) {
        for (CameraProfile profile : this.profiles.list.getList()) {
            if (!profile.getDestination().equals(newProfile.getDestination())) continue;
            profile.copyFrom(newProfile);
            this.editor.setProfile(profile);
            return;
        }
        this.profiles.list.add((Object)newProfile);
        this.profiles.list.sort();
        this.editor.setProfile(newProfile);
    }

    private boolean hasCameraProfile(AbstractDestination destination) {
        for (CameraProfile profile : this.profiles.list.getList()) {
            if (!profile.getDestination().equals(destination)) continue;
            return true;
        }
        return false;
    }

    public void draw(GuiContext context) {
        Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)this.area.ex(), (int)this.area.ey(), (int)-1442840576);
        super.draw(context);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.curves.isVisible()) {
            this.curves.update();
        }
    }

    public static class GuiCameraProfilesList
    extends GuiListElement<CameraProfile> {
        public GuiCameraProfilesList(Minecraft mc, Consumer<List<CameraProfile>> callback) {
            super(mc, callback);
        }

        protected boolean sortElements() {
            Collections.sort(this.list, (o1, o2) -> o1.getDestination().getFilename().compareToIgnoreCase(o2.getDestination().getFilename()));
            return true;
        }

        protected void drawElementPart(CameraProfile element, int i, int x, int y, boolean hover, boolean selected) {
            boolean hasProfile = element.exists;
            if (hasProfile) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            }
            (element.getDestination() instanceof ClientDestination ? Icons.FOLDER : Icons.SERVER).render(x + 2, y + 2);
            this.font.func_175063_a(element.getDestination().getFilename(), (float)(x + 4 + 16), (float)(y + 6), hasProfile ? (hover ? 0xFFFFA0 : 0xFFFFFF) : 0x888888);
        }

        protected String elementToString(CameraProfile element) {
            return element.getDestination().getFilename();
        }
    }

    public static class GuiCameraProfilesSearchList
    extends GuiSearchListElement<CameraProfile> {
        public GuiCameraProfilesSearchList(Minecraft mc, Consumer<List<CameraProfile>> callback) {
            super(mc, callback);
        }

        protected GuiListElement<CameraProfile> createList(Minecraft mc, Consumer<List<CameraProfile>> callback) {
            return new GuiCameraProfilesList(mc, callback);
        }

        public CameraProfile getBy(AbstractDestination from) {
            for (CameraProfile profile : this.list.getList()) {
                if (!profile.getDestination().equals(from)) continue;
                return profile;
            }
            return null;
        }
    }
}

