/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui;

import mchorse.aperture.Aperture;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.FixtureRegistry;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.fixtures.ManualFixture;
import mchorse.aperture.camera.fixtures.PathFixture;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.panels.GuiAbstractFixturePanel;
import mchorse.aperture.utils.TimeUtils;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Scale;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.MathUtils;
import mchorse.mclib.utils.undo.CompoundUndo;
import mchorse.mclib.utils.undo.IUndo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.MathHelper;

public class GuiPlaybackScrub
extends GuiElement {
    public static final Color COLOR = new Color();
    public boolean scrubbing;
    public int value;
    protected int min;
    protected int max;
    public int index;
    public GuiCameraEditor editor;
    public CameraProfile profile;
    private Area timeline = new Area();
    public boolean scrolling;
    public Scale scale;
    private int lastX;
    private boolean dragging;
    private boolean resize;
    private AbstractFixture start;
    private AbstractFixture end;
    private boolean firstTime;
    public int selectingLoop = -1;
    public int loopMin = 0;
    public int loopMax = 0;

    public GuiPlaybackScrub(Minecraft mc, GuiCameraEditor editor, CameraProfile profile) {
        super(mc);
        this.editor = editor;
        this.profile = profile;
        this.scale = new Scale(this.timeline, false);
        this.scale.anchor(0.5f);
    }

    public void resize() {
        super.resize();
        this.timeline.copy(this.area);
        this.timeline.offsetX(-2);
        if (!this.firstTime) {
            this.scale.view((double)this.min, (double)this.max);
            this.firstTime = true;
        }
        this.clampScroll();
    }

    public void set(int min, int max) {
        this.min = min;
        this.max = max;
        if (this.profile == null || this.profile.getDuration() == 0L) {
            max = Math.max((Integer)Aperture.duration.get(), max);
            this.scale.lock((double)min, (double)max);
            this.scale.view((double)min, (double)max);
        } else {
            this.scale.lock((double)min, (double)max);
        }
        this.clampScroll();
    }

    public void rescale() {
        AbstractFixture fixture = this.editor.getFixture();
        if (fixture != null) {
            double min = this.scale.getMinValue();
            double max = this.scale.getMaxValue();
            long offset = this.profile.calculateOffset(fixture) + fixture.getDuration();
            if ((double)offset > max) {
                this.scale.view(min, (double)offset);
            } else if ((double)offset < min) {
                this.scale.view((double)offset, max);
            }
        }
    }

    public void setLoopMin(int min) {
        if (min <= this.loopMax) {
            this.loopMin = min;
        }
    }

    public void setLoopMax(int max) {
        if (max >= this.loopMin) {
            this.loopMax = max;
        }
    }

    private void verifyLoopMinMax() {
        int min = this.loopMin;
        int max = this.loopMax;
        this.loopMin = Math.min(min, max);
        this.loopMax = Math.max(min, max);
    }

    public void setProfile(CameraProfile profile) {
        boolean same = this.profile == profile;
        int duration = Math.max(profile == null ? 0 : (int)profile.getDuration(), this.editor.maxScrub);
        this.profile = profile;
        this.index = -1;
        this.set(0, duration);
        this.value = MathHelper.func_76125_a((int)this.value, (int)this.min, (int)this.max);
        if (profile != null && this.area.w != 0) {
            this.scale.view((double)this.min, duration <= 0 ? 30.0 : (double)duration);
        }
        if (!same) {
            this.loopMax = 0;
            this.loopMin = 0;
        }
    }

    public void setValue(int value, boolean fromScrub) {
        int old = this.value;
        this.value = value;
        this.value = MathHelper.func_76125_a((int)this.value, (int)this.min, (int)this.max);
        if (this.value != old) {
            this.editor.setFlight(false);
            this.editor.scrubbed(this, this.value, fromScrub);
            this.scale.shiftInto((double)this.value);
        }
    }

    public void setValue(int value) {
        this.setValue(value, false);
    }

    public void setValueFromScrub(int value) {
        this.setValue(value, true);
    }

    public int fromGraphX(int mouseX) {
        return (int)this.scale.from((double)mouseX);
    }

    public int toGraphX(int value) {
        return (int)this.scale.to((double)value);
    }

    public void clampScroll() {
        this.scale.setShift(this.scale.getShift());
        this.scale.calculateMultiplier();
    }

    public boolean mouseClicked(GuiContext context) {
        int mouseX = context.mouseX;
        int mouseY = context.mouseY;
        if (this.area.isInside(mouseX, mouseY)) {
            if (context.mouseButton == 0) {
                if (GuiScreen.func_146271_m()) {
                    this.selectingLoop = 0;
                    this.loopMin = this.fromGraphX(mouseX);
                    this.verifyLoopMinMax();
                } else {
                    this.scrubbing = true;
                    this.setValueFromScrub(this.fromGraphX(mouseX));
                }
            } else if (context.mouseButton == 1 && this.profile != null) {
                if (GuiScreen.func_146271_m()) {
                    boolean same = this.loopMin == this.loopMax;
                    this.selectingLoop = 1;
                    this.loopMax = this.fromGraphX(mouseX);
                    if (same) {
                        this.loopMin = this.loopMax;
                    } else {
                        this.verifyLoopMinMax();
                    }
                    return false;
                }
                int tick = this.fromGraphX(mouseX);
                if (this.editor.creating) {
                    this.editor.addMarker(tick);
                    return false;
                }
                AbstractFixture fixture = this.profile.atTick(tick);
                long offset = this.profile.calculateOffset(fixture);
                if (fixture != null) {
                    boolean right;
                    boolean left = Math.abs(this.toGraphX((int)offset) - mouseX) < 5;
                    boolean bl = right = Math.abs(this.toGraphX((int)(offset + fixture.getDuration())) - mouseX) < 5;
                    if (left || right) {
                        int index = this.profile.fixtures.indexOf(fixture);
                        if (left && index > 0) {
                            this.dragging = true;
                            this.lastX = mouseX;
                            this.start = this.profile.get(index - 1);
                            this.end = fixture;
                        } else if (right) {
                            this.dragging = true;
                            this.lastX = mouseX;
                            this.start = fixture;
                            AbstractFixture abstractFixture = this.end = this.profile.has(index + 1) ? this.profile.get(index + 1) : null;
                        }
                    }
                }
                if (!this.dragging) {
                    int index = this.profile.fixtures.indexOf(fixture);
                    this.editor.pickCameraFixture(fixture, (long)tick - offset);
                    this.index = index;
                }
            } else if (context.mouseButton == 2) {
                if (GuiScreen.func_146271_m()) {
                    this.loopMax = 0;
                    this.loopMin = 0;
                } else {
                    this.scrolling = true;
                    this.lastX = mouseX;
                }
            }
        }
        return false;
    }

    public boolean mouseScrolled(GuiContext context) {
        int scroll = context.mouseWheel;
        if (!Minecraft.field_142025_a) {
            scroll = -scroll;
        }
        if (this.area.isInside(context) && !this.scrolling) {
            this.scale.zoom(Math.copySign(this.scale.getZoomFactor(), (double)scroll), 0.001, 1000.0);
            return true;
        }
        return super.mouseScrolled(context);
    }

    public void mouseReleased(GuiContext context) {
        if (this.resize) {
            this.editor.markLastNoMerging();
            this.editor.updateValues();
        }
        if (this.selectingLoop >= 0) {
            this.verifyLoopMinMax();
        }
        this.scrubbing = false;
        this.resize = false;
        this.dragging = false;
        this.scrolling = false;
        this.selectingLoop = -1;
    }

    public void draw(GuiContext context) {
        int mouseX = context.mouseX;
        int mouseY = context.mouseY;
        if (this.scrubbing) {
            this.setValueFromScrub(this.fromGraphX(mouseX));
        } else if (this.selectingLoop == 0) {
            this.loopMin = MathUtils.clamp((int)this.fromGraphX(mouseX), (int)0, (int)this.loopMax);
        } else if (this.selectingLoop == 1) {
            this.loopMax = MathUtils.clamp((int)this.fromGraphX(mouseX), (int)this.loopMin, (int)Math.max(this.editor.maxScrub, (int)this.editor.getProfile().getDuration()));
        }
        if (this.scrolling) {
            this.scale.setShift(this.scale.getShift() - (double)(mouseX - this.lastX) / this.scale.getZoom());
            this.lastX = mouseX;
            this.clampScroll();
        }
        if (this.dragging && Math.abs(mouseX - this.lastX) > 6 && !this.resize) {
            this.resize = true;
        }
        if (this.resize && this.profile != null) {
            long value;
            long start = this.profile.calculateOffset(this.start);
            long end = start + this.start.getDuration();
            if (this.end != null) {
                end += this.end.getDuration();
            }
            if ((value = (long)this.fromGraphX(mouseX)) >= start + 5L && (this.end == null || value <= end - 5L)) {
                if (this.end != null) {
                    this.editor.postUndo((IUndo<CameraProfile>)new CompoundUndo(new IUndo[]{GuiAbstractFixturePanel.undo(this.editor, (Value)this.start.duration, value - start), GuiAbstractFixturePanel.undo(this.editor, (Value)this.end.duration, end - value)}));
                } else {
                    this.editor.postUndo(GuiAbstractFixturePanel.undo(this.editor, (Value)this.start.duration, value - start));
                }
                GuiAbstractFixturePanel delegate = (GuiAbstractFixturePanel)this.editor.panel.delegate;
                if (delegate != null) {
                    if (delegate.fixture == this.start) {
                        delegate.setDuration(this.start.getDuration());
                    } else if (delegate.fixture == this.end) {
                        delegate.setDuration(this.end.getDuration());
                    }
                }
                this.editor.updateDuration(this.end);
            }
        }
        int x = this.area.x;
        int y = this.area.y;
        int w = this.area.w;
        int h = this.area.h;
        if (this.profile != null) {
            int stopX;
            String label = TimeUtils.formatTime(this.value) + "/" + TimeUtils.formatTime(this.max);
            int tx = this.toGraphX(this.value);
            int width = this.font.func_78256_a(label) + 4;
            int pos = 0;
            boolean drawnMarker = false;
            int leftMarginMarker = 0;
            int rightMarginMarker = 0;
            GuiDraw.scissor((int)(x + 2), (int)(y - 16), (int)(w - 4), (int)(h + 16), (GuiContext)context);
            this.drawTickMarks(y, h);
            for (int i = 0; i < this.profile.fixtures.size(); ++i) {
                AbstractFixture fixture = this.profile.fixtures.get(i);
                COLOR.set(((Integer)fixture.color.get()).intValue(), false);
                int color = COLOR.getRGBColor();
                if (color == 0) {
                    color = FixtureRegistry.CLIENT.get(fixture.getClass()).color.getRGBColor();
                }
                boolean selected = i == this.index;
                int leftMargin = this.toGraphX(pos) - 1;
                int rightMargin = this.toGraphX(pos + (int)fixture.getDuration()) - 1;
                if (rightMargin < this.area.x) {
                    pos = (int)((long)pos + fixture.getDuration());
                    continue;
                }
                if (leftMargin > this.area.ex()) break;
                if (fixture instanceof ManualFixture) {
                    ManualFixture manual = (ManualFixture)fixture;
                    int startTick = (Integer)manual.shift.get();
                    int endTick = manual.getEndTick();
                    int start = MathUtils.clamp((int)(leftMargin + (int)((float)startTick / (float)fixture.getDuration() * (float)(rightMargin - leftMargin))), (int)leftMargin, (int)rightMargin);
                    int end = MathUtils.clamp((int)(leftMargin + (int)((float)endTick / (float)fixture.getDuration() * (float)(rightMargin - leftMargin))), (int)leftMargin, (int)rightMargin);
                    if (end < rightMargin) {
                        Gui.func_73734_a((int)(end + 1), (int)(y + (selected ? 12 : 15)), (int)rightMargin, (int)(y + h - 1), (int)(selected ? -1442840576 : 0x66000000));
                    }
                    if (end > leftMargin) {
                        Gui.func_73734_a((int)(start + 1), (int)(y + (selected ? 12 : 15)), (int)(end + 1), (int)(y + h - 1), (int)((selected ? -587202560 : 0x66000000) + color));
                    }
                    if (start > leftMargin) {
                        Gui.func_73734_a((int)(leftMargin + 1), (int)(y + (selected ? 12 : 15)), (int)(start + 1), (int)(y + h - 1), (int)(selected ? -1442840576 : 0x66000000));
                    }
                } else {
                    Gui.func_73734_a((int)(leftMargin + 1), (int)(y + (selected ? 12 : 15)), (int)rightMargin, (int)(y + h - 1), (int)((selected ? -587202560 : 0x66000000) + color));
                }
                Gui.func_73734_a((int)rightMargin, (int)(y + 1), (int)(rightMargin + 1), (int)(y + h - 1), (int)(-16777216 + color));
                if (selected) {
                    this.func_73733_a(leftMargin + 1, y + 5, rightMargin, y + 12, 35071, -2013230849);
                    this.func_73733_a(leftMargin + 1, y + 15, rightMargin, y + h - 1, 0, 0x44000000);
                }
                String name = (String)fixture.name.get();
                if (fixture instanceof PathFixture) {
                    COLOR.set(color, false);
                    GuiPlaybackScrub.COLOR.r *= 0.89f;
                    GuiPlaybackScrub.COLOR.g *= 0.89f;
                    GuiPlaybackScrub.COLOR.b *= 0.89f;
                    PathFixture path = (PathFixture)fixture;
                    int c = path.size() - 1;
                    int highlight = COLOR.getRGBAColor();
                    if (c > 1) {
                        float fract = (float)(rightMargin - leftMargin) / (float)c;
                        for (int j = 1; j < c; ++j) {
                            int px = leftMargin + (int)(fract * (float)j);
                            Gui.func_73734_a((int)px, (int)(y + 5), (int)(px + 1), (int)(y + h - 1), (int)highlight);
                        }
                    }
                }
                if (this.area.isInside(mouseX, mouseY) && !this.resize && !drawnMarker && i != 0) {
                    boolean right;
                    boolean left = Math.abs(leftMargin - mouseX) < 5;
                    boolean bl = right = Math.abs(rightMargin - mouseX) < 5;
                    if (left || right) {
                        leftMarginMarker = leftMargin;
                        rightMarginMarker = rightMargin;
                        drawnMarker = true;
                    }
                }
                if (!name.isEmpty()) {
                    int lw = this.font.func_78256_a(name);
                    int textColor = selected ? 0xFFFFA0 : 0xFFFFFF;
                    boolean shortened = false;
                    while (lw + 10 >= rightMargin - leftMargin && !name.isEmpty()) {
                        name = name.substring(0, name.length() - 1);
                        lw = this.font.func_78256_a(name);
                        shortened = true;
                    }
                    if (!name.isEmpty()) {
                        this.font.func_175063_a(shortened ? name + "..." : name, (float)(leftMargin + 4), (float)(y + 6), textColor);
                    }
                }
                pos = (int)((long)pos + fixture.getDuration());
            }
            if (this.editor.creating) {
                for (Integer marker : this.editor.markers) {
                    int mx = this.toGraphX(marker);
                    Gui.func_73734_a((int)mx, (int)(y + 5), (int)(mx + 1), (int)(y + h - 1), (int)-1426128896);
                }
            }
            if (this.loopMin != this.loopMax) {
                int min = Math.min(this.loopMin, this.loopMax);
                int max = Math.max(this.loopMin, this.loopMax);
                int minX = this.toGraphX(min);
                int maxX = this.toGraphX(max);
                if (maxX >= this.area.x + 1 && minX < this.area.ex() - 1) {
                    minX = MathUtils.clamp((int)minX, (int)(this.area.x + 1), (int)(this.area.ex() - 1));
                    maxX = MathUtils.clamp((int)maxX, (int)(this.area.x + 1), (int)(this.area.ex() - 1));
                    GuiDraw.drawVerticalGradientRect((int)minX, (int)this.area.y, (int)maxX, (int)this.area.ey(), (int)65535, (int)-1442805505);
                    Gui.func_73734_a((int)minX, (int)this.area.y, (int)(minX + 1), (int)this.area.ey(), (int)-7798785);
                    Gui.func_73734_a((int)(maxX - 1), (int)this.area.y, (int)maxX, (int)this.area.ey(), (int)-7798785);
                }
            }
            double bias = 0.001;
            if (this.scale.getMinValue() > (double)this.min + 0.001) {
                GuiDraw.drawHorizontalGradientRect((int)(x + 2), (int)(y + h - 5), (int)(x + 22), (int)(y + h), (int)-2013265920, (int)0, (float)0.0f);
            }
            if (this.scale.getMaxValue() < (double)this.max - 0.001) {
                GuiDraw.drawHorizontalGradientRect((int)(x + w - 22), (int)(y + h - 5), (int)(x + w - 2), (int)(y + h), (int)0, (int)-2013265920, (float)0.0f);
            }
            if ((stopX = this.toGraphX((int)this.profile.getDuration())) < this.area.ex() - 2) {
                this.func_73733_a(stopX + 1, y + h / 2, x + w - 1, y + h, 0, -2013265920);
                Gui.func_73734_a((int)stopX, (int)(y + h / 2), (int)(stopX + 1), (int)(y + h), (int)-1426063361);
            }
            if (tx + 3 - x + width > w) {
                tx -= 2;
            }
            Gui.func_73734_a((int)tx, (int)(y + 1), (int)(tx + 2), (int)(y + h - 1), (int)-11012822);
            String offsetLabel = TimeUtils.formatTime((long)this.value - this.profile.calculateOffset(this.value, false));
            int ow = this.font.func_78256_a(offsetLabel);
            this.font.func_175063_a(offsetLabel, (float)(tx - ow / 2 + 1), (float)(y + h - this.font.field_78288_b * 3 - 1), 0xFFFFFF);
            if (tx + 3 - x + width > w) {
                tx -= width + 2;
            }
            Gui.func_73734_a((int)(tx + 2), (int)(y + h - 3 - this.font.field_78288_b), (int)(tx + 2 + width), (int)(y + h - 1), (int)-1437076182);
            this.font.func_175063_a(label, (float)(tx + 4), (float)(y + h - this.font.field_78288_b - 1), 0xFFFFFF);
            GuiDraw.unscissor((GuiContext)context);
            if (drawnMarker) {
                int markerOffset = Math.abs(leftMarginMarker - mouseX) < 5 ? leftMarginMarker : rightMarginMarker;
                Gui.func_73734_a((int)(markerOffset - 4), (int)(this.area.y - 1), (int)(markerOffset + 5), (int)this.area.y, (int)-1426063361);
                Gui.func_73734_a((int)(markerOffset - 5), (int)(this.area.y - 1 - 2), (int)(markerOffset - 4), (int)(this.area.y + 2), (int)-1426063361);
                Gui.func_73734_a((int)(markerOffset + 5), (int)(this.area.y - 1 - 2), (int)(markerOffset + 6), (int)(this.area.y + 2), (int)-1426063361);
            }
        }
        Gui.func_73734_a((int)(x + 1), (int)(y + h / 2), (int)(x + 2), (int)(y + h), (int)-1426063361);
        Gui.func_73734_a((int)(x + w - 2), (int)(y + h / 2), (int)(x + w - 1), (int)(y + h), (int)-1426063361);
        Gui.func_73734_a((int)x, (int)(y + h - 1), (int)(x + w), (int)(y + h), (int)-1);
    }

    private void drawTickMarks(int y, int h) {
        int mult = this.scale.getMult() * 2;
        int start = (int)this.scale.getMinValue();
        int end = (int)this.scale.getMaxValue();
        int max = this.max - (this.max - 1) % mult;
        start -= start % mult;
        end -= end % mult;
        start = MathUtils.clamp((int)start, (int)mult, (int)max);
        end = MathUtils.clamp((int)end, (int)mult, (int)max);
        for (int j = start; j <= end; j += mult) {
            int xx = this.toGraphX(j);
            String value = TimeUtils.formatTime(j);
            GuiDraw.drawTextBackground((FontRenderer)this.font, (String)value, (int)(xx - this.font.func_78256_a(value) / 2), (int)y, (int)0xFFFFFF, (int)-2013265920, (int)2);
            Gui.func_73734_a((int)xx, (int)(y + h / 2), (int)(xx + 1), (int)(y + h), (int)0x66FFFFFF);
        }
    }
}

