/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.ModifierRegistry;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.aperture.camera.values.ValueModifiers;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.panels.modifiers.GuiAbstractModifierPanel;
import mchorse.aperture.client.gui.utils.undo.ModifierValueChangeUndo;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.undo.CompoundUndo;
import mchorse.mclib.utils.undo.IUndo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class GuiModifiersManager
extends GuiElement {
    public static final Map<Class<? extends AbstractModifier>, Class<? extends GuiAbstractModifierPanel<? extends AbstractModifier>>> PANELS = new HashMap<Class<? extends AbstractModifier>, Class<? extends GuiAbstractModifierPanel<? extends AbstractModifier>>>();
    private String stringTitle = "aperture.gui.modifiers.title";
    private String stringGlobal = "aperture.gui.modifiers.global";
    private AbstractModifier clipboard;
    public AbstractFixture fixture;
    public boolean modified = false;
    public GuiElement buttons;
    public GuiScrollElement panels;
    public GuiIconElement add;
    public GuiIconElement paste;
    public GuiCameraEditor editor;
    public GuiLabel title;

    public GuiModifiersManager(Minecraft mc, GuiCameraEditor editor) {
        super(mc);
        this.editor = editor;
        this.add = new GuiIconElement(mc, Icons.ADD, b -> this.buttons.setVisible(!this.buttons.isVisible()));
        this.add.tooltip(IKey.lang((String)"aperture.gui.modifiers.tooltips.add"));
        this.paste = new GuiIconElement(mc, Icons.PASTE, b -> {
            if (this.clipboard != null) {
                this.addModifier(this.clipboard.copy());
            }
        });
        this.paste.tooltip(IKey.lang((String)"aperture.gui.modifiers.tooltips.paste"));
        this.buttons = new GuiElement(mc){

            public void draw(GuiContext context) {
                this.area.draw(-2013265920);
                super.draw(context);
            }
        };
        this.buttons.setVisible(false);
        this.buttons.flex().relative((GuiElement)this).x(1.0f, -10).y(24).w(0.5f, 0).anchor(1.0f, 0.0f).column(0).vertical().stretch().padding(2);
        for (byte i = 0; i < ModifierRegistry.getNextId(); i = (byte)(i + 1)) {
            ModifierRegistry.ModifierInfo info = ModifierRegistry.CLIENT.get(ModifierRegistry.CLASS_TO_ID.inverse().get((Object)i));
            byte type = info.type;
            int color = info.color.getRGBAColor();
            GuiButtonElement button = new GuiButtonElement(mc, IKey.lang((String)info.title), b -> {
                AbstractModifier modifier = this.addCameraModifier(type);
                if (modifier != null) {
                    this.addModifier(modifier);
                }
                this.buttons.setVisible(false);
            });
            this.buttons.add((IGuiElement)button.color(color));
        }
        this.panels = new GuiScrollElement(mc);
        this.panels.flex().relative((GuiElement)this).y(28).w(1.0f, 0).h(1.0f, -28).column(0).vertical().stretch().scroll();
        this.add.flex().relative((GuiElement)this).set(0.0f, 4.0f, 20.0f, 20.0f).x(1.0f, -30);
        this.paste.flex().relative((GuiElement)this.add).set(-20.0f, 0.0f, 20.0f, 20.0f);
        this.title = Elements.label((IKey)IKey.lang((String)this.stringGlobal)).background();
        this.title.flex().relative((GuiElement)this).set(10.0f, 10.0f, 0.0f, 20.0f);
        this.add(new IGuiElement[]{this.title, this.add, this.paste, this.panels, this.buttons});
        this.hideTooltip();
    }

    public IUndo<CameraProfile> undo(List<AbstractModifier> modifiers) {
        CameraProfile profile = this.editor.getProfile();
        if (this.fixture != null) {
            int index = profile.fixtures.indexOf(this.fixture);
            return new ModifierValueChangeUndo(index, this.panels.scroll.scroll, this.fixture.modifiers.getPath(), this.fixture.modifiers.getValue(), modifiers).view(this.editor.timeline).noMerging();
        }
        return new ModifierValueChangeUndo(-1, this.panels.scroll.scroll, profile.modifiers.getPath(), profile.modifiers.getValue(), modifiers).view(this.editor.timeline).noMerging();
    }

    public IUndo<CameraProfile> undo(Value value, Object newValue) {
        CameraProfile profile = this.editor.getProfile();
        int index = -1;
        if (this.fixture != null) {
            index = profile.fixtures.indexOf(this.fixture);
        }
        return new ModifierValueChangeUndo(index, this.panels.scroll.scroll, value.getPath(), value.getValue(), newValue).view(this.editor.timeline);
    }

    public void handleUndo(IUndo<CameraProfile> undo, boolean redo) {
        int scroll = -1;
        if (undo instanceof ModifierValueChangeUndo) {
            scroll = ((ModifierValueChangeUndo)undo).getPanelScroll();
        } else if (undo instanceof CompoundUndo && ((CompoundUndo)undo).has(ModifierValueChangeUndo.class)) {
            scroll = ((ModifierValueChangeUndo)((CompoundUndo)undo).getFirst(ModifierValueChangeUndo.class)).getPanelScroll();
        }
        if (scroll >= 0) {
            this.panels.scroll.scrollTo(scroll);
        }
        for (IGuiElement element : this.panels.getChildren()) {
            if (!(element instanceof GuiAbstractModifierPanel)) continue;
            ((GuiAbstractModifierPanel)element).handleUndo(undo, redo);
        }
    }

    public void cameraEditorOpened() {
        for (IGuiElement element : this.panels.getChildren()) {
            if (!(element instanceof GuiAbstractModifierPanel)) continue;
            ((GuiAbstractModifierPanel)element).initiate();
        }
    }

    public void updateDuration() {
        for (IGuiElement element : this.panels.getChildren()) {
            if (!(element instanceof GuiAbstractModifierPanel)) continue;
            ((GuiAbstractModifierPanel)element).updateDuration();
        }
    }

    public ValueModifiers getModifiers() {
        if (this.fixture != null) {
            return this.fixture.modifiers;
        }
        if (this.editor.getProfile() != null) {
            return this.editor.getProfile().modifiers;
        }
        return null;
    }

    public void setFixture(AbstractFixture fixture) {
        this.panels.removeAll();
        this.fixture = fixture;
        this.title.label.set(fixture == null ? this.stringGlobal : this.stringTitle);
        ValueModifiers modifiers = this.getModifiers();
        if (modifiers == null) {
            return;
        }
        for (int i = 0; i < modifiers.size(); ++i) {
            AbstractModifier modifier = modifiers.get(i);
            this.addModifierPanel(modifier);
        }
    }

    public void setClipboard(AbstractModifier modifier) {
        this.clipboard = modifier.copy();
    }

    public void addModifierPanel(AbstractModifier modifier) {
        Class<? extends GuiAbstractModifierPanel<? extends AbstractModifier>> clazz = PANELS.get(modifier.getClass());
        if (clazz != null) {
            try {
                GuiAbstractModifierPanel<? extends AbstractModifier> panel = clazz.getConstructor(Minecraft.class, modifier.getClass(), GuiModifiersManager.class).newInstance(new Object[]{this.mc, modifier, this});
                panel.fillData();
                this.panels.add(panel);
                this.panels.resize();
                panel.initiate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addModifier(AbstractModifier modifier) {
        ValueModifiers value = this.getModifiers();
        List modifiers = (List)value.getValue();
        modifiers.add(modifier);
        this.editor.postUndo(this.undo(modifiers), false, false);
        value.add(modifier);
        this.addModifierPanel(modifier);
    }

    public void moveModifier(GuiAbstractModifierPanel<? extends AbstractModifier> panel, int direction) {
        int index = this.panels.getChildren().indexOf(panel);
        if (index == -1) {
            return;
        }
        int to = index + direction;
        if (to < 0 || to >= this.panels.getChildren().size()) {
            return;
        }
        ValueModifiers value = this.getModifiers();
        List modifiers = (List)value.getValue();
        modifiers.add(to, modifiers.remove(index));
        this.editor.postUndo(this.undo(modifiers), false, false);
        this.panels.getChildren().add(to, this.panels.getChildren().remove(index));
        value.add(to, value.remove(index));
        this.resize();
        this.modified = true;
    }

    public void removeModifier(GuiAbstractModifierPanel<? extends AbstractModifier> panel) {
        ValueModifiers value = this.getModifiers();
        List modifiers = (List)this.getModifiers().getValue();
        int index = value.indexOf((AbstractModifier)panel.modifier);
        modifiers.remove(index);
        this.editor.postUndo(this.undo(modifiers), false, false);
        this.panels.getChildren().remove(panel);
        value.remove(index);
        this.resize();
        this.modified = true;
    }

    private AbstractModifier addCameraModifier(int id) {
        try {
            return ModifierRegistry.fromType((byte)id);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void draw(GuiContext context) {
        int h = Math.min(this.panels.scroll.scrollSize + 28, this.area.h);
        if (this.panels.getChildren().isEmpty()) {
            h = 28;
        }
        Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)this.area.ex(), (int)(this.area.y + h), (int)-1442840576);
        if (this.buttons.isVisible()) {
            this.add.area.draw(-2013265920);
        }
        super.draw(context);
    }
}

