/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import mchorse.aperture.Aperture;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.CameraExporter;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.minema.MinemaIntegration;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.panels.GuiAbstractFixturePanel;
import mchorse.aperture.client.gui.utils.GuiTextHelpElement;
import mchorse.aperture.events.CameraEditorEvent;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.modals.GuiMessageModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiModal;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDrawable;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GuiMinemaPanel
extends GuiElement {
    public GuiCameraEditor editor;
    public GuiElement fields;
    public GuiTextElement name;
    public GuiCirculateElement mode;
    public GuiTrackpadElement left;
    public GuiTrackpadElement right;
    public GuiButtonElement setLeft;
    public GuiButtonElement setRight;
    public GuiButtonElement movies;
    public GuiToggleElement trackingButton;
    public GuiElement trackingElementsWrapper;
    public GuiElement trackingElements;
    public GuiToggleElement originButton;
    public GuiElement originElementsWrapper;
    public GuiLabel originTitle;
    public GuiRelativeOriginTransformation originRow;
    public GuiElement originElements;
    public GuiElement selectorElement;
    public GuiTextHelpElement selector;
    public GuiButtonElement record;
    public static final CameraExporter trackingExporter = new CameraExporter();
    private GuiElement customWrapper;
    private GuiElement leftRight;
    private GuiElement setLeftRight;
    private RecordingMode recordingMode = RecordingMode.FULL;
    private boolean recording;
    private int start;
    private int end;
    private long lastUpdate;
    private String lastName;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");

    public GuiMinemaPanel(Minecraft mc, GuiCameraEditor editor) {
        super(mc);
        this.editor = editor;
        this.fields = new GuiElement(mc);
        this.name = new GuiTextElement(mc, (Consumer)null).filename();
        this.name.tooltip(IKey.lang((String)"aperture.gui.minema.output"));
        this.mode = new GuiCirculateElement(mc, b -> {
            this.switchMode((GuiCirculateElement)b);
            this.updateButtons();
        });
        for (RecordingMode mode : RecordingMode.values()) {
            this.mode.addLabel(IKey.lang((String)("aperture.gui.minema.modes." + mode.id)));
        }
        this.mode.tooltip(IKey.lang((String)"aperture.gui.minema.modes.tooltip"));
        this.left = new GuiTrackpadElement(mc, (Consumer)null);
        this.left.limit(0.0).integer();
        this.left.setValue(0.0);
        this.right = new GuiTrackpadElement(mc, (Consumer)null);
        this.right.limit(0.0).integer();
        this.right.setValue(0.0);
        this.setLeft = new GuiButtonElement(mc, IKey.lang((String)"aperture.gui.minema.set_start"), this::calculateLeft);
        this.setLeft.tooltip(IKey.lang((String)"aperture.gui.minema.set_start_tooltip"));
        this.setRight = new GuiButtonElement(mc, IKey.lang((String)"aperture.gui.minema.set_duration"), this::calculateRight);
        this.setRight.tooltip(IKey.lang((String)"aperture.gui.minema.set_duration_tooltip"));
        this.record = new GuiButtonElement(mc, IKey.lang((String)"aperture.gui.minema.record"), this::startRecording);
        this.movies = new GuiButtonElement(mc, IKey.lang((String)"minema.gui.movies_folder"), this::openMovies);
        this.trackingButton = new GuiToggleElement(mc, IKey.lang((String)"aperture.gui.minema.tracking_button"), b -> this.updateButtons());
        this.trackingButton.tooltip(IKey.lang((String)"aperture.gui.minema.tracking_tooltip"));
        this.originButton = new GuiToggleElement(mc, IKey.lang((String)"aperture.gui.minema.tracking_origin_title"), b -> {
            trackingExporter.setRelativeOrigin(b.isToggled());
            if (b.isToggled()) {
                trackingExporter.setOriginX(this.originRow.originX.value);
                trackingExporter.setOriginY(this.originRow.originY.value);
                trackingExporter.setOriginZ(this.originRow.originZ.value);
            }
        });
        this.originButton.tooltip(IKey.lang((String)"aperture.gui.minema.tracking_origin_title_tooltip"));
        this.trackingElementsWrapper = new GuiElement(mc);
        this.trackingElementsWrapper.flex().column(4).stretch().vertical().height(3);
        this.trackingElements = new GuiElement(mc);
        this.trackingElements.flex().column(4).stretch().vertical().height(3);
        this.trackingElements.marginTop(10).marginBottom(10);
        this.originElementsWrapper = new GuiElement(mc);
        this.originElementsWrapper.flex().column(4).stretch().vertical().height(3);
        this.originElements = new GuiElement(mc);
        this.originElements.flex().column(4).stretch().vertical().height(3);
        this.originElements.marginTop(7).marginBottom(7);
        this.originRow = new GuiRelativeOriginTransformation(mc);
        this.selectorElement = new GuiElement(mc);
        this.selectorElement.flex().column(4).stretch().vertical().height(1);
        this.originTitle = Elements.label((IKey)IKey.lang((String)"aperture.gui.minema.tracking_origin_title"), (int)20).anchor(0.0f, 1.0f);
        this.originTitle.tooltip(IKey.lang((String)"aperture.gui.minema.tracking_origin_title_tooltip"));
        this.selector = new GuiTextHelpElement(mc, 500, str -> trackingExporter.setEntitiesSelector((String)str));
        this.selector.link("https://minecraft.gamepedia.com/Commands#Target_selector_arguments").tooltip(IKey.lang((String)"aperture.gui.minema.tracking_entity_selector"));
        this.originElements.add(new IGuiElement[]{this.originButton, this.originRow});
        this.originElementsWrapper.add((IGuiElement)this.originElements);
        this.selectorElement.add((IGuiElement)this.selector);
        this.trackingElementsWrapper.add(new IGuiElement[]{this.originElementsWrapper, this.selectorElement});
        this.trackingElements.add((IGuiElement)this.trackingButton);
        this.customWrapper = new GuiElement(mc);
        this.customWrapper.flex().column(4).stretch().vertical().height(2);
        this.leftRight = Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.left, this.right});
        this.setLeftRight = Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.setLeft, this.setRight});
        this.fields.flex().relative((IResizer)this.flex()).w(1.0f).column(5).vertical().stretch().height(20).padding(10);
        this.flex().hTo((IResizer)this.fields.flex(), 1.0f);
        this.fields.add((IGuiElement)Elements.label((IKey)IKey.lang((String)"aperture.gui.minema.title"), (int)12).background());
        this.fields.add(new IGuiElement[]{this.name, this.mode});
        this.fields.add(new IGuiElement[]{this.customWrapper, this.trackingElements, Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.movies, this.record})});
        this.add((IGuiElement)this.fields);
        this.add((IGuiElement)new GuiDrawable(context -> {
            if (this.fields.isVisible() && !this.name.isFocused() && this.name.field.func_146179_b().isEmpty()) {
                long current = System.currentTimeMillis();
                if (current > this.lastUpdate + 1000L) {
                    this.lastUpdate = current;
                    this.lastName = this.format.format(new Date());
                }
                String filename = (Boolean)Aperture.minemaDefaultProfileName.get() != false ? this.getFilename() : this.lastName;
                this.font.func_175063_a(filename, (float)(this.name.area.x + 5), (float)(this.name.area.my() - 4), 0x888888);
            }
        }));
        this.fields.setVisible(MinemaIntegration.isLoaded() && MinemaIntegration.isAvailable());
        this.switchMode(this.mode);
    }

    private void updateButtons() {
        this.trackingElementsWrapper.removeFromParent();
        this.leftRight.removeFromParent();
        this.setLeftRight.removeFromParent();
        if (this.trackingButton.isToggled()) {
            this.trackingElements.add((IGuiElement)this.trackingElementsWrapper);
        }
        if (this.recordingMode == RecordingMode.CUSTOM) {
            this.customWrapper.add((IGuiElement)this.leftRight);
            this.customWrapper.add((IGuiElement)this.setLeftRight);
        }
        this.getParent().resize();
    }

    public void setProfile(CameraProfile profile) {
        this.left.setValue(0.0);
        this.right.setValue(profile == null ? 30.0 : (double)profile.getDuration());
    }

    private void switchMode(GuiCirculateElement b) {
        this.recordingMode = RecordingMode.values()[b.getValue()];
    }

    public boolean isRecording() {
        return this.recording;
    }

    private boolean isRunning() {
        return this.editor.getRunner().isRunning();
    }

    private String getFilename() {
        AbstractFixture fixture;
        String text = this.name.field.func_146179_b();
        if (!text.isEmpty()) {
            return text;
        }
        if (!((Boolean)Aperture.minemaDefaultProfileName.get()).booleanValue()) {
            return "";
        }
        text = this.editor.getProfile().getDestination().getFilename();
        if (this.recordingMode == RecordingMode.FIXTURE && (fixture = this.editor.getFixture()) != null) {
            text = text + "-" + (this.editor.getProfile().fixtures.indexOf(fixture) + 1);
        }
        return text;
    }

    private void calculateLeft(GuiButtonElement button) {
        int right = (int)(this.left.value + this.right.value);
        this.left.setValue((double)this.editor.timeline.value);
        this.right.setValue((double)right - this.left.value);
    }

    private void calculateRight(GuiButtonElement button) {
        this.right.setValue((double)this.editor.timeline.value - this.left.value);
    }

    private void openMovies(GuiButtonElement button) {
        MinemaIntegration.openMovies();
    }

    private void startRecording(GuiButtonElement button) {
        if (this.isRunning() || MinemaIntegration.isRecording()) {
            return;
        }
        this.start = (int)this.left.value;
        this.end = this.start + (int)this.right.value;
        if (this.recordingMode == RecordingMode.FIXTURE && this.editor.panel.delegate != null) {
            Object fixture = ((GuiAbstractFixturePanel)this.editor.panel.delegate).fixture;
            this.start = (int)this.editor.getProfile().calculateOffset((AbstractFixture)fixture);
            this.end = (int)((long)this.start + ((AbstractFixture)fixture).getDuration());
        } else if (this.recordingMode == RecordingMode.FULL) {
            this.start = 0;
            this.end = (int)this.editor.getProfile().getDuration();
        }
        if (this.end - this.start <= 0) {
            return;
        }
        MinemaIntegration.setName(this.getFilename());
        try {
            MinemaIntegration.toggleRecording(true);
            this.editor.postOperation(() -> {
                this.recording = true;
            });
        }
        catch (Exception e) {
            GuiModal.addFullModal((GuiElement)this, () -> new GuiMessageModal(this.mc, IKey.str((String)MinemaIntegration.getMessage(e))));
            return;
        }
        if (this.trackingButton.isToggled()) {
            trackingExporter.start(this.editor.getRunner());
        }
        ClientProxy.EVENT_BUS.post((Event)new CameraEditorEvent.Rewind(this.editor, this.start));
        this.editor.timeline.setValueFromScrub(this.start);
        this.editor.updatePlayer(this.start, 0.0f);
        if (!this.isRunning()) {
            this.editor.togglePlayback();
        }
        this.editor.root.setVisible(false);
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean prematureStop) {
        if (this.recording) {
            try {
                MinemaIntegration.toggleRecording(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isRunning()) {
                this.editor.togglePlayback();
            }
            this.editor.root.setVisible(true);
            this.recording = false;
            if (!prematureStop) {
                if (trackingExporter.isTracking()) {
                    trackingExporter.exportTrackingData((this.getFilename().isEmpty() ? this.format.format(new Date(System.currentTimeMillis())) : this.getFilename()) + ".json");
                }
            }
            trackingExporter.reset();
        }
    }

    public void minema(int ticks, float partialTicks) {
        if (!this.recording) {
            return;
        }
        if (!MinemaIntegration.isRecording()) {
            this.stop(true);
            GuiModal.addFullModal((GuiElement)this, () -> new GuiMessageModal(this.mc, IKey.lang((String)"aperture.gui.minema.premature_stop")));
            return;
        }
        if (this.isRunning() && ticks >= this.end) {
            this.editor.togglePlayback();
            this.stop();
        } else if (!this.isRunning()) {
            this.stop();
        }
        if (((Boolean)Aperture.debugTicks.get()).booleanValue()) {
            this.font.func_175063_a(String.valueOf((float)ticks + partialTicks), 0.0f, 0.0f, 0xFFFFFF);
        }
    }

    public void draw(GuiContext context) {
        this.area.draw(-1442840576);
        int x = this.area.x + 10;
        int y = this.area.my();
        if (!MinemaIntegration.isLoaded()) {
            GuiDraw.drawMultiText((FontRenderer)this.font, (String)I18n.func_135052_a((String)"aperture.gui.minema.minema_not_installed", (Object[])new Object[0]), (int)x, (int)y, (int)0xFFFFFF, (int)(this.area.w - 20), (int)12, (float)0.5f, (float)0.5f);
        } else if (!MinemaIntegration.isAvailable()) {
            GuiDraw.drawMultiText((FontRenderer)this.font, (String)I18n.func_135052_a((String)"aperture.gui.minema.minema_wrong_version", (Object[])new Object[0]), (int)x, (int)y, (int)0xFFFFFF, (int)(this.area.w - 20), (int)12, (float)0.5f, (float)0.5f);
        }
        super.draw(context);
    }

    protected class GuiRelativeOriginTransformation
    extends GuiElement {
        public GuiTrackpadElement originX;
        public GuiTrackpadElement originY;
        public GuiTrackpadElement originZ;

        public GuiRelativeOriginTransformation(Minecraft mc) {
            super(mc);
            this.originX = new GuiTrackpadElement(mc, trackingExporter::setOriginX);
            this.originX.tooltip(IKey.lang((String)"aperture.gui.minema.tracking_origin_x"));
            this.originY = new GuiTrackpadElement(mc, trackingExporter::setOriginY);
            this.originY.tooltip(IKey.lang((String)"aperture.gui.minema.tracking_origin_y"));
            this.originZ = new GuiTrackpadElement(mc, trackingExporter::setOriginZ);
            this.originZ.tooltip(IKey.lang((String)"aperture.gui.minema.tracking_origin_z"));
            this.add(new IGuiElement[]{this.originX, this.originY, this.originZ});
            this.flex().column(4).vertical().stretch();
        }

        public GuiContextMenu createContextMenu(GuiContext context) {
            GuiSimpleContextMenu menu = new GuiSimpleContextMenu(context.mc);
            NBTTagList transforms = null;
            try {
                NBTTagCompound tag = JsonToNBT.func_180713_a((String)("{Transforms:" + GuiScreen.func_146277_j() + "}"));
                NBTTagList list = tag.func_150295_c("Transforms", 6);
                if (list.func_74745_c() >= 3) {
                    transforms = list;
                }
            }
            catch (Exception tag) {
                // empty catch block
            }
            menu.action(Icons.COPY, IKey.lang((String)"mclib.gui.transforms.context.copy"), this::copyTransformations);
            if (transforms != null) {
                NBTTagList innerList = transforms;
                menu.action(Icons.PASTE, IKey.lang((String)"mclib.gui.transforms.context.paste"), () -> this.pasteTransformations(innerList));
            }
            menu.action(Icons.REFRESH, IKey.lang((String)"aperture.gui.minema.tracking_origin_generate"), this::setRelativeOriginCoordinates);
            menu.action(Icons.CLOSE, IKey.lang((String)"mclib.gui.transforms.context.reset"), this::resetTransformations);
            return menu;
        }

        private void resetTransformations() {
            this.originX.setValue(0.0);
            this.originY.setValue(0.0);
            this.originZ.setValue(0.0);
        }

        private void setRelativeOriginCoordinates() {
            DecimalFormat df = new DecimalFormat("#.##");
            df.setRoundingMode(RoundingMode.HALF_UP);
            this.originX.setValue(Double.parseDouble(df.format(GuiMinemaPanel.this.editor.position.point.x)));
            this.originY.setValue(Double.parseDouble(df.format(GuiMinemaPanel.this.editor.position.point.y)));
            this.originZ.setValue(Double.parseDouble(df.format(GuiMinemaPanel.this.editor.position.point.z)));
        }

        private void copyTransformations() {
            NBTTagList list = new NBTTagList();
            list.func_74742_a((NBTBase)new NBTTagDouble(this.originX.value));
            list.func_74742_a((NBTBase)new NBTTagDouble(this.originY.value));
            list.func_74742_a((NBTBase)new NBTTagDouble(this.originZ.value));
            GuiScreen.func_146275_d((String)list.toString());
        }

        private void pasteTransformations(NBTTagList list) {
            this.originX.setValue(list.func_150309_d(0));
            this.originY.setValue(list.func_150309_d(1));
            this.originZ.setValue(list.func_150309_d(2));
        }
    }

    public static enum RecordingMode {
        FULL("full"),
        FIXTURE("fixture"),
        CUSTOM("custom");

        public final String id;

        private RecordingMode(String id) {
            this.id = id;
        }
    }
}

