/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui;

import java.util.function.Consumer;
import mchorse.aperture.Aperture;
import mchorse.aperture.camera.FixtureRegistry;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;

public class GuiFixtures
extends GuiElement {
    public Consumer<AbstractFixture> callback;

    public GuiFixtures(Minecraft mc, Consumer<AbstractFixture> callback) {
        super(mc);
        this.callback = callback;
        this.flex().column(0).vertical().stretch().height(20).padding(2);
        for (byte i = 0; i < FixtureRegistry.getNextId(); i = (byte)(i + 1)) {
            FixtureRegistry.FixtureInfo info = FixtureRegistry.getInfo(i);
            byte type = info.type;
            int color = info.color.getRGBAColor();
            this.add((IGuiElement)new GuiButtonElement(mc, IKey.lang((String)info.title), b -> this.createFixture(type)).color(color));
        }
    }

    public void createFixture(byte type) {
        long duration = ((Integer)Aperture.duration.get()).intValue();
        AbstractFixture fixture = null;
        try {
            fixture = FixtureRegistry.fromType(type, duration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (fixture != null && this.callback != null) {
            this.callback.accept(fixture);
        }
    }

    public void draw(GuiContext context) {
        this.area.draw(-1442840576);
        super.draw(context);
    }
}

