/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui;

import java.awt.Color;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.curves.AbstractCurve;
import mchorse.aperture.camera.values.ValueCurves;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.utils.GuiCameraEditorKeyframesGraphEditor;
import mchorse.aperture.client.gui.utils.GuiGraphView;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiSearchListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.keyframes.KeyframeChannel;
import net.minecraft.client.Minecraft;

public class GuiCurves
extends GuiElement {
    public GuiCameraEditor editor;
    public GuiCameraEditorKeyframesGraphEditor keyframes;
    public GuiButtonElement curveSelector;
    public GuiSearchCurveList curveList;
    public String selected;

    public GuiCurves(Minecraft mc, GuiCameraEditor editor) {
        super(mc);
        this.editor = editor;
        this.curveSelector = new GuiButtonElement(mc, IKey.str((String)"Curves"), btn -> this.toggleCurveList());
        this.curveSelector.flex().relative((GuiElement)this).y(1.0f).w(1.0f).anchorY(1.0f);
        this.keyframes = new GuiCameraEditorKeyframesGraphEditor(mc, editor);
        ((GuiGraphView)this.keyframes.graph).global = true;
        this.keyframes.flex().relative((GuiElement)this).w(1.0f).hTo((IResizer)this.curveSelector.area);
        this.curveList = new GuiSearchCurveList(mc, list -> this.selectCurve((String)list.get(0)));
        this.curveList.flex().relative((GuiElement)this.keyframes).wh(1.0f, 1.0f);
        this.curveList.list.background(-1073741824);
        this.curveList.list.scroll.scrollSpeed = 20;
        this.add(new IGuiElement[]{this.curveSelector, this.keyframes, this.curveList});
    }

    public void updateKeyframeEditor() {
        this.keyframes.updateConverter();
    }

    public void updateDuration() {
        ((GuiGraphView)this.keyframes.graph).duration = (int)this.editor.getProfile().getDuration();
    }

    public void update() {
        this.updateCurveList();
        if (!this.curveList.list.getList().contains(this.selected)) {
            this.selectCurve((String)this.curveList.list.getList().get(0));
        } else {
            this.selectCurve(this.selected);
        }
    }

    public void draw(GuiContext context) {
        super.draw(context);
    }

    public void selectCurve(String id) {
        this.selected = id;
        this.curveList.list.setCurrent((Object)this.selected);
        this.curveList.setVisible(false);
        this.curveSelector.label.set(ClientProxy.curveManager.curves.get(id).getTranslatedName());
        CameraProfile profile = this.editor.getProfile();
        ValueCurves channels = profile.curves;
        KeyframeChannel channel = channels.get(id);
        if (channel == null) {
            channel = new KeyframeChannel();
            channels.put(id, channel);
        }
        this.updateDuration();
        this.keyframes.setChannel(profile.getProperty(profile.curves.id + "." + id), Color.HSBtoRGB(new Random().nextFloat(), 1.0f, 1.0f));
    }

    public void updateCurveList() {
        this.curveList.list.clear();
        this.curveList.list.add(ClientProxy.curveManager.curves.keySet());
        this.curveList.list.sort();
        this.curveList.resize();
    }

    public void toggleCurveList() {
        this.curveList.toggleVisible();
        if (this.curveList.isVisible()) {
            this.updateCurveList();
            this.curveList.list.setCurrentScroll((Object)this.selected);
            this.curveList.list.filter(this.curveList.search.field.func_146179_b());
        }
    }

    public class GuiCurveList
    extends GuiListElement<String> {
        public ValueCurves curves;

        public GuiCurveList(Minecraft mc, Consumer<List<String>> callback) {
            super(mc, callback);
        }

        protected String elementToString(String element) {
            KeyframeChannel channel = GuiCurves.this.editor.getProfile().curves.get(element);
            String hasKey = channel != null && !channel.isEmpty() ? "*" : "";
            AbstractCurve curve = ClientProxy.curveManager.curves.get(element);
            if (curve == null) {
                return hasKey + element;
            }
            return hasKey + curve.getTranslatedName();
        }

        protected boolean sortElements() {
            this.list.sort((a, b) -> {
                KeyframeChannel channel = GuiCurves.this.editor.getProfile().curves.get((String)a);
                int aa = channel != null && !channel.isEmpty() ? 0 : 1;
                channel = GuiCurves.this.editor.getProfile().curves.get((String)b);
                int bb = channel != null && !channel.isEmpty() ? 0 : 1;
                return aa - bb;
            });
            return true;
        }
    }

    public class GuiSearchCurveList
    extends GuiSearchListElement<String> {
        public GuiSearchCurveList(Minecraft mc, Consumer<List<String>> callback) {
            super(mc, callback);
        }

        protected GuiListElement<String> createList(Minecraft mc, Consumer<List<String>> callback) {
            return new GuiCurveList(mc, callback);
        }
    }
}

