/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui;

import com.google.common.collect.Queues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Supplier;
import mchorse.aperture.Aperture;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.CameraRunner;
import mchorse.aperture.camera.CameraUtils;
import mchorse.aperture.camera.FixtureRegistry;
import mchorse.aperture.camera.data.Angle;
import mchorse.aperture.camera.data.Point;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.fixtures.IdleFixture;
import mchorse.aperture.camera.fixtures.PathFixture;
import mchorse.aperture.client.KeyboardHandler;
import mchorse.aperture.client.gui.Flight;
import mchorse.aperture.client.gui.GuiFixtures;
import mchorse.aperture.client.gui.GuiMinemaPanel;
import mchorse.aperture.client.gui.GuiModifiersManager;
import mchorse.aperture.client.gui.GuiPlaybackScrub;
import mchorse.aperture.client.gui.GuiProfilesManager;
import mchorse.aperture.client.gui.config.GuiCameraConfig;
import mchorse.aperture.client.gui.config.GuiConfigCameraOptions;
import mchorse.aperture.client.gui.panels.GuiAbstractFixturePanel;
import mchorse.aperture.client.gui.panels.GuiPathFixturePanel;
import mchorse.aperture.client.gui.utils.undo.CameraProfileUndo;
import mchorse.aperture.client.gui.utils.undo.FixtureAddRemoveUndo;
import mchorse.aperture.client.gui.utils.undo.FixtureValueChangeUndo;
import mchorse.aperture.events.CameraEditorEvent;
import mchorse.aperture.utils.APIcons;
import mchorse.mclib.client.InputRenderer;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiDelegateElement;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.undo.CompoundUndo;
import mchorse.mclib.utils.undo.IUndo;
import mchorse.mclib.utils.undo.UndoManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameType;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiCameraEditor
extends GuiBase {
    public static final Map<Class<? extends AbstractFixture>, Class<? extends GuiAbstractFixturePanel<? extends AbstractFixture>>> PANELS = new HashMap<Class<? extends AbstractFixture>, Class<? extends GuiAbstractFixturePanel<? extends AbstractFixture>>>();
    private String stringX = I18n.func_135052_a((String)"aperture.gui.panels.x", (Object[])new Object[0]);
    private String stringY = I18n.func_135052_a((String)"aperture.gui.panels.y", (Object[])new Object[0]);
    private String stringZ = I18n.func_135052_a((String)"aperture.gui.panels.z", (Object[])new Object[0]);
    private String stringYaw = I18n.func_135052_a((String)"aperture.gui.panels.yaw", (Object[])new Object[0]);
    private String stringPitch = I18n.func_135052_a((String)"aperture.gui.panels.pitch", (Object[])new Object[0]);
    private String stringRoll = I18n.func_135052_a((String)"aperture.gui.panels.roll", (Object[])new Object[0]);
    private String stringFov = I18n.func_135052_a((String)"aperture.gui.panels.fov", (Object[])new Object[0]);
    private CameraRunner runner;
    private boolean playing = false;
    private boolean replacing = false;
    public boolean creating = false;
    public List<Integer> markers = new ArrayList<Integer>();
    private float lastPartialTick = 0.0f;
    private long lastSave = 0L;
    public ResourceLocation overlayLocation;
    public boolean haveScrubbed;
    public int maxScrub = 0;
    public Flight flight;
    public Position position = new Position(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public Position lastPosition = new Position(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public Map<Class<? extends AbstractFixture>, GuiAbstractFixturePanel<? extends AbstractFixture>> panels = new HashMap<Class<? extends AbstractFixture>, GuiAbstractFixturePanel<? extends AbstractFixture>>();
    public float aspectRatio = 1.7777778f;
    public GuiElement leftBar;
    public GuiElement rightBar;
    public GuiElement middleBar;
    public GuiElement creationBar;
    public GuiIconElement plause;
    public GuiIconElement nextFrame;
    public GuiIconElement prevFrame;
    public GuiIconElement prevFixture;
    public GuiIconElement nextFixture;
    public GuiIconElement moveForward;
    public GuiIconElement moveBackward;
    public GuiIconElement copyPosition;
    public GuiIconElement moveDuration;
    public GuiIconElement cut;
    public GuiIconElement creation;
    public GuiIconElement save;
    public GuiIconElement openMinema;
    public GuiIconElement openModifiers;
    public GuiIconElement openConfig;
    public GuiIconElement openProfiles;
    public GuiIconElement add;
    public GuiIconElement dupe;
    public GuiIconElement replace;
    public GuiIconElement remove;
    public GuiElement top;
    public GuiCameraConfig config;
    public GuiFixtures fixtures;
    public GuiPlaybackScrub timeline;
    public GuiProfilesManager profiles;
    public GuiConfigCameraOptions cameraOptions;
    public GuiModifiersManager modifiers;
    public GuiMinemaPanel minema;
    public GuiDelegateElement<GuiAbstractFixturePanel> panel;
    public Queue<Runnable> operations = Queues.newArrayDeque();

    public GuiCameraEditor(Minecraft mc, CameraRunner runner) {
        this.runner = runner;
        this.flight = new Flight(this);
        this.top = new GuiElement(mc){

            public void draw(GuiContext context) {
                super.draw(context);
                GuiCameraEditor editor = GuiCameraEditor.this;
                IResizer panel = editor.panel.resizer();
                if (editor.flight.isFlightEnabled()) {
                    editor.flight.drawSpeed(this.font, panel.getX() + panel.getW() - 10, panel.getY() + panel.getH() - 5);
                }
                if ((editor.isSyncing() || editor.runner.isRunning()) && ((Boolean)Aperture.editorDisplayPosition.get()).booleanValue()) {
                    editor.drawPosition(panel);
                }
            }
        };
        this.top.flex().relative((IResizer)this.viewport).wh(1.0f, 1.0f);
        this.panel = new GuiDelegateElement(mc, null);
        this.timeline = new GuiPlaybackScrub(mc, this, null);
        this.fixtures = new GuiFixtures(mc, fixture -> {
            fixture.fromPlayer(this.getCamera());
            this.createFixture((AbstractFixture)fixture);
            this.fixtures.setVisible(false);
        });
        this.profiles = new GuiProfilesManager(mc, this);
        this.cameraOptions = new GuiConfigCameraOptions(mc, this);
        this.modifiers = new GuiModifiersManager(mc, this);
        this.config = new GuiCameraConfig(mc, this);
        this.minema = new GuiMinemaPanel(mc, this);
        this.nextFixture = new GuiIconElement(mc, APIcons.FRAME_NEXT, b -> this.jumpToNextFixture());
        this.nextFixture.tooltip(IKey.lang((String)"aperture.gui.tooltips.jump_next_fixture"));
        this.nextFrame = new GuiIconElement(mc, APIcons.FORWARD, b -> this.jumpToNextFrame());
        this.nextFrame.tooltip(IKey.lang((String)"aperture.gui.tooltips.jump_next_frame"));
        this.plause = new GuiIconElement(mc, Icons.PLAY, b -> this.togglePlayback());
        this.plause.tooltip(IKey.lang((String)"aperture.gui.tooltips.plause"), Direction.BOTTOM);
        this.prevFrame = new GuiIconElement(mc, APIcons.BACKWARD, b -> this.jumpToPrevFrame());
        this.prevFrame.tooltip(IKey.lang((String)"aperture.gui.tooltips.jump_prev_frame"));
        this.prevFixture = new GuiIconElement(mc, APIcons.FRAME_PREV, b -> this.jumpToPrevFixture());
        this.prevFixture.tooltip(IKey.lang((String)"aperture.gui.tooltips.jump_prev_fixture"));
        this.save = new GuiIconElement(mc, Icons.SAVED, b -> this.saveProfile());
        this.save.tooltip(IKey.lang((String)"aperture.gui.tooltips.save"));
        this.openMinema = new GuiIconElement(mc, APIcons.MINEMA, b -> this.hidePopups(this.minema));
        this.openMinema.tooltip(IKey.lang((String)"aperture.gui.tooltips.minema"));
        this.openModifiers = new GuiIconElement(mc, Icons.FILTER, b -> this.hidePopups(this.modifiers));
        this.openModifiers.tooltip(IKey.lang((String)"aperture.gui.tooltips.modifiers"));
        this.openConfig = new GuiIconElement(mc, Icons.GEAR, b -> this.hidePopups((GuiElement)this.config));
        this.openConfig.tooltip(IKey.lang((String)"aperture.gui.tooltips.config"));
        this.openProfiles = new GuiIconElement(mc, Icons.MORE, b -> this.hidePopups(this.profiles));
        this.openProfiles.tooltip(IKey.lang((String)"aperture.gui.tooltips.profiles"));
        this.add = new GuiIconElement(mc, Icons.ADD, b -> this.hideReplacingPopups(this.fixtures, false));
        this.add.tooltip(IKey.lang((String)"aperture.gui.tooltips.add"));
        this.dupe = new GuiIconElement(mc, Icons.DUPE, b -> this.dupeFixture());
        this.dupe.tooltip(IKey.lang((String)"aperture.gui.tooltips.dupe"));
        this.replace = new GuiIconElement(mc, Icons.REFRESH, b -> this.hideReplacingPopups(this.fixtures, true));
        this.replace.tooltip(IKey.lang((String)"aperture.gui.tooltips.replace"));
        this.remove = new GuiIconElement(mc, Icons.REMOVE, b -> this.removeFixture());
        this.remove.tooltip(IKey.lang((String)"aperture.gui.tooltips.remove"));
        this.creation = new GuiIconElement(mc, APIcons.INTERACTIVE, b -> this.toggleCreation());
        this.creation.tooltip(IKey.lang((String)"aperture.gui.tooltips.creation"));
        this.cut = new GuiIconElement(mc, Icons.CUT, b -> this.cutFixture());
        this.cut.tooltip(IKey.lang((String)"aperture.gui.tooltips.cut"));
        this.moveForward = new GuiIconElement(mc, Icons.SHIFT_FORWARD, b -> this.moveTo(1));
        this.moveForward.tooltip(IKey.lang((String)"aperture.gui.tooltips.move_up"));
        this.moveDuration = new GuiIconElement(mc, Icons.SHIFT_TO, b -> this.shiftDurationToCursor());
        this.moveDuration.tooltip(IKey.lang((String)"aperture.gui.tooltips.move_duration"));
        this.copyPosition = new GuiIconElement(mc, Icons.MOVE_TO, b -> this.editFixture(false));
        this.copyPosition.tooltip(IKey.lang((String)"aperture.gui.tooltips.copy_position"));
        this.moveBackward = new GuiIconElement(mc, Icons.SHIFT_BACKWARD, b -> this.moveTo(-1));
        this.moveBackward.tooltip(IKey.lang((String)"aperture.gui.tooltips.move_down"));
        this.leftBar = new GuiElement(mc);
        this.rightBar = new GuiElement(mc);
        this.middleBar = new GuiElement(mc);
        this.creationBar = new GuiElement(mc);
        this.leftBar.flex().relative((IResizer)this.top.flex()).row(0).resize().width(20).height(20);
        this.rightBar.flex().relative((IResizer)this.top.flex()).x(1.0f).anchorX(1.0f).row(0).resize().width(20).height(20);
        this.middleBar.flex().relative((IResizer)this.top.flex()).x(0.5f).anchorX(0.5f).row(0).resize().width(20).height(20);
        this.creationBar.flex().row(0).resize().width(20).height(20);
        this.leftBar.add(new IGuiElement[]{this.moveBackward, this.moveForward, this.copyPosition, this.moveDuration, this.cut, this.creation});
        this.middleBar.add(new IGuiElement[]{this.prevFixture, this.prevFrame, this.plause, this.nextFrame, this.nextFixture});
        this.rightBar.add(new IGuiElement[]{this.save, this.openMinema, this.openModifiers, this.openConfig, this.openProfiles});
        this.creationBar.add(new IGuiElement[]{this.add, this.dupe, this.replace, this.remove});
        this.timeline.flex().relative(this.top).set(10.0f, 0.0f, 0.0f, 20.0f).y(1.0f, -20).w(1.0f, -20);
        this.panel.flex().relative(this.top).set(0.0f, 20.0f, 0.0f, 0.0f).w(1.0f).hTo((IResizer)this.timeline.area);
        this.config.flex().relative((GuiElement)this.openConfig).xy(1.0f, 1.0f).anchorX(1.0f).w(200).hTo((IResizer)this.panel.flex(), 1.0f);
        this.profiles.flex().relative((GuiElement)this.openProfiles).xy(1.0f, 1.0f).anchorX(1.0f).w(190).hTo((IResizer)this.panel.flex(), 1.0f);
        this.modifiers.flex().relative((GuiElement)this.openModifiers).xy(1.0f, 1.0f).anchorX(1.0f).w(210).hTo((IResizer)this.panel.flex(), 1.0f);
        this.minema.flex().relative((GuiElement)this.openMinema).xy(1.0f, 1.0f).anchorX(1.0f).w(200);
        this.hidePopups(this.profiles);
        this.top.add(new IGuiElement[]{this.leftBar, this.middleBar, this.rightBar, this.creationBar});
        this.top.add(new IGuiElement[]{this.timeline, this.panel, this.fixtures, this.profiles, this.config, this.modifiers, this.minema});
        this.root.add(new IGuiElement[]{this.flight, this.top});
        ClientProxy.EVENT_BUS.post((Event)new CameraEditorEvent.Init(this));
        IKey fixture2 = IKey.lang((String)"aperture.gui.editor.keys.fixture.title");
        IKey modes = IKey.lang((String)"aperture.gui.editor.keys.modes.title");
        IKey editor = IKey.lang((String)"aperture.gui.editor.keys.editor.title");
        IKey looping = IKey.lang((String)"aperture.gui.editor.keys.looping.title");
        Supplier<Boolean> active = this::isFlightDisabled;
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.editor.toggle"), 59, () -> this.top.toggleVisible()).category(editor);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.editor.modifiers"), 49, () -> this.openModifiers.clickItself(this.context)).active(active).category(editor);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.editor.save"), 31, () -> this.save.clickItself(this.context)).held(new int[]{29}).active(active).category(editor);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.editor.plause"), 57, () -> this.plause.clickItself(this.context)).active(active).category(editor);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.editor.next_fixture"), 205, this::jumpToNextFixture).held(new int[]{42}).active(active).category(editor);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.editor.prev_fixture"), 203, this::jumpToPrevFixture).held(new int[]{42}).active(active).category(editor);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.editor.next"), 205, this::jumpToNextFrame).active(active).category(editor);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.editor.prev"), 203, this::jumpToPrevFrame).active(active).category(editor);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.editor.undo"), 44, this::undo).held(new int[]{29}).category(editor);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.editor.redo"), 21, this::redo).held(new int[]{29}).category(editor);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.fixture.deselect"), 32, () -> this.pickCameraFixture(null, 0L)).active(active).category(fixture2);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.fixture.shift"), 50, this::shiftDurationToCursor).active(active).category(fixture2);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.fixture.copy"), 48, () -> this.editFixture(false)).active(active).category(fixture2);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.fixture.cut"), 46, () -> this.cut.clickItself(this.context)).held(new int[]{56}).active(active).category(fixture2);
        for (byte i = 0; i < FixtureRegistry.getNextId(); i = (byte)(i + 1)) {
            FixtureRegistry.FixtureInfo info = FixtureRegistry.getInfo(i);
            IKey label = IKey.format((String)"aperture.gui.editor.keys.fixture.add", (Object[])new Object[]{IKey.lang((String)info.title)});
            byte type = i;
            this.root.keys().register(label, 2 + i, () -> this.fixtures.createFixture(type)).held(new int[]{29}).active(active).category(fixture2);
        }
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.modes.flight"), 33, () -> this.cameraOptions.flight.clickItself(this.context)).category(modes);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.modes.vertical"), 47, () -> this.flight.toggleMovementType()).active(() -> this.flight.isFlightEnabled()).category(modes);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.modes.sync"), 31, () -> this.cameraOptions.sync.clickItself(this.context)).active(active).category(modes);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.modes.ouside"), 24, () -> this.cameraOptions.outside.clickItself(this.context)).active(active).category(modes);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.modes.interactive"), 23, () -> this.creation.clickItself(this.context)).active(active).category(modes);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.modes.looping"), 38, () -> this.cameraOptions.loop.clickItself(this.context)).active(active).category(looping);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.looping.set_min"), 26, () -> this.timeline.setLoopMin(this.timeline.value)).active(active).category(looping);
        this.root.keys().register(IKey.lang((String)"aperture.gui.editor.keys.looping.set_max"), 27, () -> this.timeline.setLoopMax(this.timeline.value)).active(active).category(looping);
    }

    public void postUndo(IUndo<CameraProfile> undo) {
        this.postUndo(undo, true, false);
    }

    public void postUndo(IUndo<CameraProfile> undo, boolean apply) {
        this.postUndo(undo, apply, false);
    }

    public void postUndoCallback(IUndo<CameraProfile> undo) {
        this.postUndo(undo, true, true);
    }

    public void postUndo(IUndo<CameraProfile> undo, boolean apply, boolean callback) {
        if (undo == null) {
            throw new RuntimeException("Given undo is null!");
        }
        CameraProfile profile = this.getProfile();
        UndoManager<CameraProfile> undoManager = profile.undoManager;
        undoManager.setCallback(callback ? this::handleUndos : null);
        if (apply) {
            undoManager.pushApplyUndo(undo, (Object)profile);
        } else {
            undoManager.pushUndo(undo);
        }
        undoManager.setCallback(this::handleUndos);
        this.updateProfile();
    }

    private void handleUndos(IUndo<CameraProfile> undo, boolean redo) {
        CameraProfileUndo profileUndo;
        FixtureValueChangeUndo value;
        int cursor = -1;
        double min = -1.0;
        double max = -1.0;
        int index = -1;
        String name = "";
        if (undo instanceof FixtureValueChangeUndo) {
            value = (FixtureValueChangeUndo)undo;
            index = value.getIndex();
            name = value.getName();
        } else if (undo instanceof CompoundUndo && ((CompoundUndo)undo).has(FixtureValueChangeUndo.class)) {
            value = (FixtureValueChangeUndo)((CompoundUndo)undo).getFirst(FixtureValueChangeUndo.class);
            index = value.getIndex();
            name = value.getName();
        }
        if (index >= 0) {
            this.pickCameraFixture(this.getProfile().get(index), -1L);
            ((GuiAbstractFixturePanel)this.panel.delegate).handleUndo(undo, redo);
            this.modifiers.handleUndo(undo, redo);
            if (name.endsWith("duration")) {
                this.updateValues();
            }
        }
        if (name.contains("modifiers")) {
            this.hidePopups(this.modifiers, true);
        } else if (name.startsWith("curves")) {
            this.hidePopups(this.profiles, true);
            if (!this.profiles.curves.isVisible()) {
                this.profiles.toggleKeyframes();
            }
        }
        index = -2;
        if (undo instanceof FixtureAddRemoveUndo) {
            FixtureAddRemoveUndo addRemoveUndo = (FixtureAddRemoveUndo)undo;
            index = addRemoveUndo.getTargetIndex(redo);
        } else if (undo instanceof CompoundUndo && ((CompoundUndo)undo).has(FixtureAddRemoveUndo.class)) {
            CompoundUndo compound = (CompoundUndo)undo;
            FixtureAddRemoveUndo addRemoveUndo = (FixtureAddRemoveUndo)(redo ? compound.getLast(FixtureAddRemoveUndo.class) : compound.getFirst(FixtureAddRemoveUndo.class));
            index = addRemoveUndo.getTargetIndex(redo);
        }
        if (index >= -1) {
            CameraProfile profile = this.getProfile();
            AbstractFixture fixture = profile.size() == 0 ? null : profile.get(index);
            this.pickCameraFixture(fixture, -1L);
            this.updateValues();
            this.timeline.rescale();
        }
        if (undo instanceof CameraProfileUndo) {
            profileUndo = (CameraProfileUndo)undo;
            cursor = profileUndo.cursor;
            min = profileUndo.viewMin;
            max = profileUndo.viewMax;
        } else if (undo instanceof CompoundUndo && ((CompoundUndo)undo).has(CameraProfileUndo.class)) {
            profileUndo = (CameraProfileUndo)((CompoundUndo)undo).getFirst(CameraProfileUndo.class);
            cursor = profileUndo.cursor;
            min = profileUndo.viewMin;
            max = profileUndo.viewMax;
        }
        if (cursor >= 0 && this.timeline.value != cursor) {
            this.timeline.setValueFromScrub(cursor);
        }
        if (min >= 0.0 && max >= 0.0 && min != max) {
            this.timeline.scale.view(min, max);
        }
    }

    public void markLastNoMerging() {
        IUndo undo = this.getProfile().undoManager.getCurrentUndo();
        if (undo != null) {
            undo.noMerging();
        }
    }

    public void undo() {
        CameraProfile profile = this.getProfile();
        if (profile != null && profile.undoManager.undo((Object)profile)) {
            GuiUtils.playClick();
        }
    }

    public void redo() {
        CameraProfile profile = this.getProfile();
        if (profile != null && profile.undoManager.redo((Object)profile)) {
            GuiUtils.playClick();
        }
    }

    public void exit() {
        this.closeScreen();
    }

    public void postRewind(int tick) {
        ClientProxy.EVENT_BUS.post((Event)new CameraEditorEvent.Rewind(this, tick));
    }

    public void postPlayback(int tick) {
        this.postPlayback(tick, this.playing);
    }

    public void postPlayback(int tick, boolean playing) {
        ClientProxy.EVENT_BUS.post((Event)new CameraEditorEvent.Playback(this, playing, tick));
    }

    public void postScrub(int tick) {
        ClientProxy.EVENT_BUS.post((Event)new CameraEditorEvent.Scrubbed(this, this.runner.isRunning(), tick));
    }

    public boolean func_73868_f() {
        return false;
    }

    public boolean isSyncing() {
        return (Boolean)Aperture.editorSync.get();
    }

    public boolean isFlightEnabled() {
        return this.flight.isFlightEnabled();
    }

    public boolean isFlightDisabled() {
        return !this.flight.isFlightEnabled();
    }

    public void haveScrubbed() {
        this.haveScrubbed = true;
    }

    public void scrubbed(GuiPlaybackScrub scrub, int value, boolean fromScrub) {
        if (this.runner.isRunning()) {
            this.postOperation(() -> this.runner.setTick(value));
        }
        if (fromScrub) {
            this.haveScrubbed();
            this.postScrub(value);
        }
    }

    public void pickCameraFixture(AbstractFixture fixture, long duration) {
        this.setFlight(false);
        if (fixture == null) {
            this.timeline.index = -1;
            this.panel.setDelegate(null);
        } else {
            GuiAbstractFixturePanel<? extends AbstractFixture> panel;
            if (!this.panels.containsKey(fixture.getClass())) {
                try {
                    this.panels.put(fixture.getClass(), PANELS.get(fixture.getClass()).getConstructor(Minecraft.class, GuiCameraEditor.class).newInstance(new Object[]{this.field_146297_k, this}));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((panel = this.panels.get(fixture.getClass())) != null) {
                this.panel.setDelegate(panel);
                panel.select(fixture, duration);
                if (this.isSyncing()) {
                    int offset = (int)panel.currentOffset();
                    this.timeline.setValueFromScrub((int)((long)offset + duration));
                }
                this.timeline.index = this.getProfile().fixtures.indexOf(fixture);
            } else {
                this.panel.setDelegate(null);
            }
        }
        this.modifiers.setFixture(fixture);
    }

    public void createFixture(AbstractFixture fixture) {
        if (fixture == null) {
            return;
        }
        if (this.replacing && !this.getProfile().has(this.timeline.index)) {
            return;
        }
        CameraProfile profile = this.getProfile();
        if (this.panel.delegate == null) {
            this.postUndoCallback(FixtureAddRemoveUndo.create(this, profile, profile.size(), fixture));
        } else if (this.replacing) {
            AbstractFixture present = profile.get(this.timeline.index);
            fixture.copyByReplacing(present);
            this.postUndoCallback((IUndo<CameraProfile>)new CompoundUndo(new IUndo[]{FixtureAddRemoveUndo.create(this, profile, this.timeline.index, null), FixtureAddRemoveUndo.create(this, profile, this.timeline.index, fixture)}).noMerging());
            this.replacing = false;
        } else {
            this.postUndoCallback(FixtureAddRemoveUndo.create(this, profile, this.timeline.index + 1, fixture));
        }
    }

    private void dupeFixture() {
        int index = this.timeline.index;
        if (this.getProfile().has(index)) {
            CameraProfile profile = this.getProfile();
            this.postUndoCallback(FixtureAddRemoveUndo.create(this, profile, index + 1, profile.get(index).copy()));
        }
    }

    private void removeFixture() {
        int index = this.timeline.index;
        CameraProfile profile = this.getProfile();
        if (profile.has(index)) {
            this.postUndo(FixtureAddRemoveUndo.create(this, profile, index, null));
            this.pickCameraFixture(index - 1 >= 0 ? profile.get(index - 1) : null, -1L);
            this.updateValues();
            this.timeline.rescale();
        }
    }

    private void toggleCreation() {
        boolean bl = this.creating = !this.creating;
        if (!this.creating) {
            Collections.sort(this.markers);
            CameraProfile profile = this.getProfile();
            ArrayList<IUndo<CameraProfile>> fixtures = new ArrayList<IUndo<CameraProfile>>();
            long duration = profile.getDuration();
            int i = 0;
            for (Integer tick : this.markers) {
                long difference = (long)tick.intValue() - duration;
                if ((long)tick.intValue() < duration || difference <= 0L) continue;
                IdleFixture fixture = new IdleFixture(difference);
                fixture.fromPlayer(this.getCamera());
                fixtures.add(FixtureAddRemoveUndo.create(this, profile, profile.size() + i, fixture));
                duration += difference;
                ++i;
            }
            this.postUndoCallback((IUndo<CameraProfile>)new CompoundUndo(fixtures.toArray(new IUndo[fixtures.size()])).noMerging());
            this.markers.clear();
        }
    }

    public void addMarker(int tick) {
        if (this.markers.contains(tick)) {
            this.markers.remove((Object)tick);
        } else {
            this.markers.add(tick);
        }
    }

    private void cutFixture() {
        int where = this.timeline.value;
        CameraProfile profile = this.getProfile();
        AbstractFixture current = profile.atTick(where);
        if (current != null) {
            long offset = profile.calculateOffset(current);
            long duration = current.getDuration();
            long diff = (long)where - offset;
            if (diff <= 0L || diff >= duration) {
                return;
            }
            AbstractFixture fixture = current.copy();
            AbstractFixture newFixture = fixture.breakDown(diff);
            if (newFixture == null) {
                return;
            }
            fixture.setDuration(diff);
            int index = profile.fixtures.indexOf(current);
            this.postUndoCallback((IUndo<CameraProfile>)new CompoundUndo(new IUndo[]{new FixtureValueChangeUndo(index, profile.fixtures.getPath() + "." + index, current.copy(), fixture).view(this.timeline), new FixtureAddRemoveUndo(index + 1, newFixture, null).view(this.timeline)}).noMerging());
        }
    }

    public void setFlight(boolean flight) {
        if (flight) {
            this.lastPartialTick = 0.0f;
        }
        if (!this.runner.isRunning() || !flight) {
            this.flight.setFlightEnabled(flight);
            if (this.isSyncing()) {
                if (!flight) {
                    this.markLastNoMerging();
                } else {
                    this.lastPosition.set(Position.ZERO);
                }
            }
        }
        this.cameraOptions.update();
        if (flight) {
            this.haveScrubbed();
        }
    }

    public void setAspectRatio(String aspectRatio) {
        this.aspectRatio = CameraUtils.parseAspectRation(aspectRatio, this.aspectRatio);
    }

    public void addPathPoint() {
        if (this.getFixture() instanceof PathFixture) {
            ((GuiPathFixturePanel)this.panel.delegate).points.addPoint();
        }
    }

    public boolean setProfile(CameraProfile profile) {
        boolean isSame = this.getCurrentProfile() == profile;
        this.setCurrentProfile(profile);
        this.profiles.selectProfile(profile);
        this.timeline.setProfile(profile);
        this.updateSaveButton(profile);
        this.minema.setProfile(profile);
        if (!isSame) {
            this.pickCameraFixture(null, 0L);
        } else if (this.panel.delegate != null) {
            this.timeline.index = profile.fixtures.indexOf(this.getFixture());
        }
        this.lastSave = System.currentTimeMillis();
        return isSame;
    }

    public void updateSaveButton(CameraProfile profile) {
        if (this.save != null) {
            this.save.both(profile != null && profile.dirty ? Icons.SAVE : Icons.SAVED);
        }
    }

    public void updateCameraEditor(EntityPlayer player) {
        KeyboardHandler.setSmoothCamera(false);
        this.maxScrub = 0;
        this.haveScrubbed = false;
        this.updateOverlay();
        this.position.set(player);
        this.setProfile(ClientProxy.control.currentProfile);
        this.profiles.init();
        if (this.panel.delegate != null) {
            ((GuiAbstractFixturePanel)this.panel.delegate).cameraEditorOpened();
            this.modifiers.cameraEditorOpened();
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71474_y.field_74319_N = true;
        GuiIngameForge.renderHotbar = false;
        GuiIngameForge.renderCrosshairs = false;
        this.flight.setFlightEnabled(false);
        ClientProxy.control.cache();
        this.setAspectRatio((String)Aperture.editorLetterboxAspect.get());
        mc.field_71474_y.field_74320_O = 0;
        mc.func_175607_a((Entity)player);
        if (((Boolean)Aperture.spectator.get()).booleanValue() && !((Boolean)Aperture.outside.get()).booleanValue() && ClientProxy.control.lastGameMode != GameType.SPECTATOR) {
            ((EntityPlayerSP)player).func_71165_d("/gamemode 3");
        }
        this.runner.attachOutside();
        ClientProxy.curveManager.refreshCurves();
        if (this.profiles.curves.isVisible()) {
            this.profiles.curves.update();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public CameraRunner getRunner() {
        return this.runner;
    }

    public CameraProfile getProfile() {
        if (this.getCurrentProfile() == null) {
            this.profiles.selectFirstAvailable(-1);
        }
        return this.getCurrentProfile();
    }

    private CameraProfile getCurrentProfile() {
        return ClientProxy.control.currentProfile;
    }

    private void setCurrentProfile(CameraProfile profile) {
        ClientProxy.control.currentProfile = profile;
    }

    public AbstractFixture getFixture() {
        return this.panel.delegate == null ? null : (AbstractFixture)((GuiAbstractFixturePanel)this.panel.delegate).fixture;
    }

    public EntityPlayer getCamera() {
        return this.runner.outside.active ? this.runner.outside.camera : this.field_146297_k.field_71439_g;
    }

    public void updateOverlay() {
        this.overlayLocation = Aperture.editorOverlayRL.get();
    }

    public void updatePlayerCurrently() {
        this.updatePlayerCurrently(this.lastPartialTick);
    }

    public void updatePlayerCurrently(float partialTicks) {
        if ((this.isSyncing() || this.runner.outside.active) && !this.runner.isRunning()) {
            this.updatePlayer(this.timeline.value, partialTicks);
        }
    }

    public void updatePlayer(long tick, float ticks) {
        long duration = this.getProfile().getDuration();
        tick = tick < 0L ? 0L : tick;
        tick = tick > duration ? duration : tick;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.position.set((EntityPlayer)player);
        this.getProfile().applyProfile(tick, ticks, this.lastPartialTick, this.position);
        this.position.apply(this.getCamera());
        ClientProxy.control.setRollAndFOV(this.position.angle.roll, this.position.angle.fov);
    }

    public void updateValues() {
        this.timeline.set(0, Math.max((int)this.getProfile().getDuration(), this.maxScrub));
        this.timeline.setValue(this.timeline.value);
    }

    public void updateDuration(AbstractFixture fixture) {
        this.timeline.rescale();
        this.updateValues();
        this.profiles.updateDuration();
        this.modifiers.updateDuration();
    }

    public void updateProfile() {
        this.getProfile().dirty();
        if (this.panel.delegate != null) {
            ((GuiAbstractFixturePanel)this.panel.delegate).profileWasUpdated();
        }
        this.updateSaveButton(this.getProfile());
    }

    public void saveProfile() {
        this.getProfile().save();
        this.profiles.init();
    }

    public Position getPosition() {
        Position position = new Position(this.getCamera());
        AbstractFixture fixture = this.getFixture();
        if (fixture != null && fixture.modifiers.size() != 0) {
            Position withModifiers = new Position();
            this.getProfile().applyProfile(this.timeline.value, 0.0f, withModifiers);
            Position noModifiers = new Position();
            this.getProfile().applyProfile((long)this.timeline.value, 0.0f, noModifiers, false);
            withModifiers.point.x -= noModifiers.point.x;
            withModifiers.point.y -= noModifiers.point.y;
            withModifiers.point.z -= noModifiers.point.z;
            withModifiers.angle.yaw -= noModifiers.angle.yaw;
            withModifiers.angle.pitch -= noModifiers.angle.pitch;
            withModifiers.angle.roll -= noModifiers.angle.roll;
            withModifiers.angle.fov -= noModifiers.angle.fov;
            position.point.x -= withModifiers.point.x;
            position.point.y -= withModifiers.point.y;
            position.point.z -= withModifiers.point.z;
            position.angle.yaw -= withModifiers.angle.yaw;
            position.angle.pitch -= withModifiers.angle.pitch;
            position.angle.roll -= withModifiers.angle.roll;
            position.angle.fov -= withModifiers.angle.fov;
        }
        return position;
    }

    private void hideReplacingPopups(GuiElement exception, boolean replacing) {
        if (this.replacing != replacing && exception.isVisible()) {
            exception.toggleVisible();
        }
        this.replacing = replacing;
        this.fixtures.flex().relative(replacing ? this.replace.resizer() : this.add.resizer());
        this.fixtures.resize();
        this.hidePopups(exception);
    }

    private void hidePopups(GuiElement exception) {
        this.hidePopups(exception, !exception.isVisible());
    }

    private void hidePopups(GuiElement exception, boolean visible) {
        this.profiles.setVisible(false);
        this.config.setVisible(false);
        this.modifiers.setVisible(false);
        this.fixtures.setVisible(false);
        this.minema.setVisible(false);
        exception.setVisible(visible);
    }

    private void updatePlauseButton() {
        this.plause.both(this.runner.isRunning() ? Icons.PAUSE : Icons.PLAY);
    }

    private void jumpToNextFrame() {
        this.timeline.setValueFromScrub(this.timeline.value + 1);
    }

    private void jumpToPrevFrame() {
        this.timeline.setValueFromScrub(this.timeline.value - 1);
    }

    private void editFixture(boolean checkForBeingStatic) {
        Position current = this.getPosition();
        if (!(this.panel.delegate == null || checkForBeingStatic && this.lastPosition.equals(current))) {
            ((GuiAbstractFixturePanel)this.panel.delegate).editFixture(current);
        }
        this.lastPosition.set(current);
        this.haveScrubbed();
    }

    private void shiftDurationToCursor() {
        AbstractFixture fixture;
        if (this.panel.delegate == null) {
            return;
        }
        CameraProfile profile = this.getProfile();
        long offset = profile.calculateOffset(fixture = profile.get(this.timeline.index));
        if ((long)this.timeline.value > offset && fixture != null) {
            this.postUndo(GuiAbstractFixturePanel.undo(this, (Value)fixture.duration, (long)this.timeline.value - offset));
            this.updateValues();
            ((GuiAbstractFixturePanel)this.panel.delegate).select(fixture, 0L);
        }
    }

    private void jumpToNextFixture() {
        this.timeline.setValueFromScrub((int)this.getProfile().calculateOffset(this.timeline.value, true));
    }

    private void jumpToPrevFixture() {
        this.timeline.setValueFromScrub((int)this.getProfile().calculateOffset(this.timeline.value - 1, false));
    }

    private void moveTo(int direction) {
        CameraProfile profile = this.getProfile();
        int from = this.timeline.index;
        int to = from + direction;
        if (profile.has(from) && profile.has(to)) {
            AbstractFixture fixture = profile.get(from);
            this.postUndoCallback((IUndo<CameraProfile>)new CompoundUndo(new IUndo[]{FixtureAddRemoveUndo.create(this, profile, from, null), FixtureAddRemoveUndo.create(this, profile, to, fixture)}).noMerging());
        }
    }

    public void togglePlayback() {
        boolean playing = !this.playing;
        this.setFlight(false);
        this.postOperation(() -> {
            if (playing) {
                this.runner.start(this.getProfile(), this.timeline.value, () -> Math.max(this.getProfile().getDuration(), (long)this.maxScrub));
            } else {
                int tick = (int)this.runner.ticks;
                if (!this.runner.skipUpdate) {
                    ++tick;
                }
                this.runner.stop();
                this.timeline.setValue(tick);
            }
            this.playing = this.runner.isRunning();
            this.updatePlauseButton();
            if (!this.playing) {
                this.runner.attachOutside();
                this.updatePlayerCurrently();
            }
        });
        this.postPlayback(this.timeline.value, playing);
    }

    protected void viewportSet() {
        this.creationBar.flex().relative((IResizer)this.rightBar.flex()).x(-20).y(0.0f).anchorX(1.0f);
        this.fixtures.flex().anchorX(1.0f).xy(1.0f, 1.0f).w(70);
        int a = this.creationBar.flex().getX();
        int b = this.middleBar.flex().getX() + this.middleBar.flex().getW();
        int diff = a - b;
        if (diff < 0) {
            this.creationBar.flex().relative((IResizer)this.leftBar.flex()).x(0).y(1.0f).anchorX(0.0f);
            this.fixtures.flex().anchorX(0.0f).xy(0.0f, 1.0f).w(70);
        }
    }

    protected void closeScreen() {
        this.minema.stop();
        Minecraft.func_71410_x().field_71474_y.field_74319_N = false;
        GuiIngameForge.renderHotbar = true;
        GuiIngameForge.renderCrosshairs = true;
        if (!this.runner.isRunning()) {
            this.runner.detachOutside();
        }
        ClientProxy.curveManager.resetAll();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        while (!this.operations.isEmpty()) {
            this.operations.poll().run();
        }
        ClientProxy.control.restore();
        super.closeScreen();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 && this.minema.isRecording() && this.runner.isRunning()) {
            this.minema.stop();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        partialTicks = Minecraft.func_71410_x().func_184121_ak();
        this.lastPartialTick = 0.0f;
        if (this.runner.isRunning()) {
            this.lastPartialTick = partialTicks;
        }
        this.updateLogic(partialTicks);
        this.drawOverlays();
        if (!this.top.canBeSeen()) {
            InputRenderer.disable();
            if (this.canRenderF1Tooltip()) {
                this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"aperture.gui.editor.f1", (Object[])new Object[0]), 5.0f, (float)(this.field_146295_m - 12), 0xFFFFFF);
            }
        } else {
            this.drawEditorsBackground();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private boolean canRenderF1Tooltip() {
        return (Boolean)Aperture.editorF1Tooltip.get() != false && !this.runner.isRunning() && !this.minema.isRecording();
    }

    private void updateLogic(float partialTicks) {
        int autoSave;
        AbstractFixture fixture = this.getFixture();
        if (!this.haveScrubbed) {
            this.field_146297_k.field_71439_g.field_70159_w = 0.0;
            this.field_146297_k.field_71439_g.field_70181_x = 0.0;
            this.field_146297_k.field_71439_g.field_70179_y = 0.0;
        }
        if ((autoSave = ((Integer)Aperture.editorAutoSave.get()).intValue()) > 0) {
            long current = System.currentTimeMillis();
            if (this.lastSave == 0L) {
                this.lastSave = current;
            }
            if (current >= this.lastSave + (long)(autoSave * 1000)) {
                if (this.getProfile().dirty && this.isFlightDisabled()) {
                    this.saveProfile();
                }
                this.lastSave = current;
            }
        }
        if (((Boolean)Aperture.editorLoop.get()).booleanValue() && this.runner.isRunning() && !this.minema.isRecording()) {
            long min = -1L;
            long max = -1L;
            if (fixture != null) {
                min = this.getProfile().calculateOffset(fixture);
                max = min + fixture.getDuration();
            }
            if (this.timeline.loopMin != this.timeline.loopMax && this.timeline.loopMin >= 0 && this.timeline.loopMin < this.timeline.loopMax) {
                min = this.timeline.loopMin;
                max = this.timeline.loopMax;
            }
            max = Math.min(max, Math.max(this.getProfile().getDuration(), (long)this.maxScrub));
            if (min >= 0L && max >= 0L && min < max && this.runner.ticks >= max - 1L) {
                this.timeline.setValueFromScrub((int)min);
            }
        }
        this.flight.animate(this.context, this.position);
        if (this.flight.isFlightEnabled()) {
            this.position.apply(this.getCamera());
            ClientProxy.control.roll = this.position.angle.roll;
            this.field_146297_k.field_71474_y.field_74334_X = this.position.angle.fov;
            if (this.isSyncing() && this.haveScrubbed) {
                this.editFixture(true);
            }
        }
        if (this.runner.isRunning()) {
            this.setFlight(false);
            this.timeline.value = (int)this.runner.ticks;
            this.timeline.setValue(this.timeline.value);
            this.timeline.scale.shiftInto((double)this.timeline.value);
        }
        if (!this.runner.isRunning() && this.playing) {
            this.updatePlauseButton();
            this.runner.attachOutside();
            this.timeline.setValueFromScrub(0);
            this.postRewind(this.timeline.value);
            this.playing = false;
        }
        if (!this.runner.isRunning()) {
            this.getProfile().applyCurves(this.timeline.value, this.lastPartialTick);
        }
        if (!this.flight.isFlightEnabled() && (this.runner.outside.active || this.isSyncing() && this.haveScrubbed)) {
            this.updatePlayerCurrently(partialTicks);
        }
        this.minema.minema(this.runner.isRunning() ? (int)this.runner.ticks : this.timeline.value, partialTicks);
    }

    private void drawEditorsBackground() {
        this.func_73733_a(0, 0, this.field_146294_l, 20, 0x66000000, 0);
        this.drawIcons();
        if (this.profiles.isVisible()) {
            this.openProfiles.area.draw(-1442840576);
        } else if (this.config.isVisible()) {
            this.openConfig.area.draw(-1442840576);
        } else if (this.modifiers.isVisible()) {
            this.openModifiers.area.draw(-1442840576);
        } else if (this.minema.isVisible()) {
            this.openMinema.area.draw(-1442840576);
        }
        if (this.fixtures.isVisible()) {
            if (this.replacing) {
                this.replace.area.draw(-1442840576);
            } else {
                this.add.area.draw(-1442840576);
            }
        }
        if (this.creating) {
            this.creation.area.draw(-1442840576);
        }
    }

    private void drawIcons() {
        if (!this.isSyncing() && !this.flight.isFlightEnabled()) {
            return;
        }
        int x = this.field_146294_l - 18;
        int y = 22;
        Gui.func_73734_a((int)(this.field_146294_l - (this.isSyncing() ? 20 : 0) - (this.flight.isFlightEnabled() ? 20 : 0)), (int)(y - 2), (int)this.field_146294_l, (int)(y + 18), (int)-2013265920);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isSyncing()) {
            Icons.DOWNLOAD.render(x, y);
            x -= 20;
        }
        if (this.flight.isFlightEnabled()) {
            this.flight.getMovementType().icon.render(x, y);
        }
    }

    private void drawPosition(IResizer panel) {
        Position pos = this.runner.isRunning() ? this.runner.getPosition() : this.position;
        Point point = pos.point;
        Angle angle = pos.angle;
        String[] labels = new String[]{this.stringX + ": " + point.x, this.stringY + ": " + point.y, this.stringZ + ": " + point.z, this.stringYaw + ": " + angle.yaw, this.stringPitch + ": " + angle.pitch, this.stringRoll + ": " + angle.roll, this.stringFov + ": " + angle.fov};
        int i = 6;
        for (String label : labels) {
            int width = this.field_146289_q.func_78256_a(label);
            int y = panel.getY() + panel.getH() - 20 - 15 * i;
            int x = panel.getX() + 10;
            Gui.func_73734_a((int)x, (int)(y - 3), (int)(x + width + 4), (int)(y + 10), (int)-1157627904);
            this.field_146289_q.func_175063_a(label, (float)(x + 2), (float)y, 0xFFFFFF);
            --i;
        }
    }

    private void drawOverlays() {
        int color;
        int width;
        if (((Boolean)Aperture.editorOverlay.get()).booleanValue() && this.overlayLocation != null) {
            this.field_146297_k.field_71446_o.func_110577_a(this.overlayLocation);
            Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.field_146294_l, (int)this.field_146295_m, (float)this.field_146294_l, (float)this.field_146295_m);
        }
        int rx = 0;
        int ry = 0;
        int rw = this.field_146294_l;
        int rh = this.field_146295_m;
        if (((Boolean)Aperture.editorLetterbox.get()).booleanValue() && this.aspectRatio > 0.0f && (width = (int)(this.aspectRatio * (float)this.field_146295_m)) != this.field_146294_l) {
            if (width < this.field_146294_l) {
                int w;
                rx = w = (this.field_146294_l - width) / 2;
                rw -= w * 2;
            } else {
                int h;
                ry = h = (int)((float)this.field_146295_m - 1.0f / this.aspectRatio * (float)this.field_146294_l) / 2;
                rh -= h * 2;
            }
        }
        if (!this.top.canBeSeen()) {
            return;
        }
        if (((Boolean)Aperture.editorRuleOfThirds.get()).booleanValue()) {
            color = (Integer)Aperture.editorGuidesColor.get();
            Gui.func_73734_a((int)(rx + rw / 3 - 1), (int)ry, (int)(rx + rw / 3), (int)(ry + rh), (int)color);
            Gui.func_73734_a((int)(rx + rw - rw / 3), (int)ry, (int)(rx + rw - rw / 3 + 1), (int)(ry + rh), (int)color);
            Gui.func_73734_a((int)rx, (int)(ry + rh / 3 - 1), (int)(rx + rw), (int)(ry + rh / 3), (int)color);
            Gui.func_73734_a((int)rx, (int)(ry + rh - rh / 3), (int)(rx + rw), (int)(ry + rh - rh / 3 + 1), (int)color);
        }
        if (((Boolean)Aperture.editorCenterLines.get()).booleanValue()) {
            color = (Integer)Aperture.editorGuidesColor.get();
            this.func_73730_a(0, this.field_146294_l, this.field_146295_m / 2, color);
            this.func_73728_b(this.field_146294_l / 2, 0, this.field_146295_m, color);
        }
        if (((Boolean)Aperture.editorCrosshair.get()).booleanValue()) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            this.field_146297_k.field_71446_o.func_110577_a(Gui.field_110324_m);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.viewport.mx() - 7, this.viewport.my() - 7, 0, 0, 16, 16);
        }
    }

    public void postOperation(Runnable operation) {
        this.operations.add(operation);
    }

    @SubscribeEvent
    public void onClientEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            while (!this.operations.isEmpty()) {
                this.operations.poll().run();
            }
        }
    }
}

