/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client.gui;

import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import mchorse.aperture.Aperture;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.utils.APIcons;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Icon;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class Flight
implements IGuiElement {
    private IKey stringSpeed = IKey.lang((String)"aperture.gui.editor.speed");
    private IKey stringDistance = IKey.lang((String)"aperture.gui.editor.distance");
    private GuiCameraEditor editor;
    private boolean enabled;
    private MovementType type = MovementType.HORIZONTAL;
    private int speed = 1000;
    private int dragging;
    private int lastX;
    private int lastY;
    private long lastSpeed;
    private Vector3d lastPosition = new Vector3d();
    private float distance;
    private boolean update;

    public Flight(GuiCameraEditor editor) {
        this.editor = editor;
    }

    public boolean isFlightEnabled() {
        return this.enabled;
    }

    public void setFlightEnabled(boolean enabled) {
        this.enabled = enabled;
        this.calculateOrigin();
    }

    public void toggleMovementType() {
        MovementType[] values = MovementType.values();
        int direction = GuiScreen.func_175283_s() ? -1 : 1;
        this.setMovementType(values[MathUtils.cycler((int)(this.type.ordinal() + direction), (int)0, (int)(values.length - 1))]);
    }

    public void setMovementType(MovementType type) {
        this.type = type;
        this.calculateOrigin();
    }

    public MovementType getMovementType() {
        return this.type;
    }

    private void calculateOrigin() {
        if (this.type != MovementType.ORBIT) {
            return;
        }
        Position position = this.editor.position;
        Vec3d vec = new Vec3d(0.0, 0.0, (double)this.distance);
        double x = position.point.x;
        double y = position.point.y;
        double z = position.point.z;
        vec = vec.func_178789_a(-position.angle.pitch / 180.0f * (float)Math.PI);
        vec = vec.func_178785_b(-position.angle.yaw / 180.0f * (float)Math.PI);
        this.lastPosition.set(x += vec.field_72450_a, y += vec.field_72448_b, z += vec.field_72449_c);
    }

    private float getSpeedFactor(int direction) {
        boolean zoomIn;
        float factor = 1000.0f;
        boolean bl = zoomIn = direction > 0;
        if (zoomIn && this.speed <= 10 || !zoomIn && this.speed < 10) {
            factor = 1.0f;
        } else if (zoomIn && this.speed <= 100 || !zoomIn && this.speed < 100) {
            factor = 10.0f;
        } else if (zoomIn && this.speed <= 1000 || !zoomIn && this.speed < 1000) {
            factor = 100.0f;
        }
        return factor;
    }

    public boolean mouseClicked(GuiContext context) {
        this.dragging = context.mouseButton;
        return false;
    }

    public boolean mouseScrolled(GuiContext context) {
        if (!this.enabled) {
            return false;
        }
        boolean isAlt = GuiScreen.func_175283_s();
        if (isAlt && this.type == MovementType.ORBIT) {
            this.distance += Math.copySign(this.getZoomFactor(), context.mouseWheel);
            this.distance = MathUtils.clamp((float)this.distance, (float)0.0f, (float)100.0f);
            this.update = true;
        } else if (!isAlt) {
            this.speed = (int)((float)this.speed - Math.copySign(this.getSpeedFactor(context.mouseWheel), context.mouseWheel));
            this.speed = MathHelper.func_76125_a((int)this.speed, (int)1, (int)50000);
        }
        return false;
    }

    protected float getZoomFactor() {
        if (this.distance < 1.0f) {
            return 0.05f;
        }
        if (this.distance > 30.0f) {
            return 5.0f;
        }
        if (this.distance > 10.0f) {
            return 1.0f;
        }
        if (this.distance > 3.0f) {
            return 0.5f;
        }
        return 0.1f;
    }

    public void mouseReleased(GuiContext context) {
        this.dragging = -1;
    }

    public void animate(GuiContext context, Position position) {
        Vector3d vec;
        if (!this.enabled) {
            this.lastX = context.mouseX;
            this.lastY = context.mouseY;
            return;
        }
        float f = (float)this.speed / 1000.0f;
        float multiplier = 1.0f;
        if (Keyboard.isKeyDown((int)29)) {
            multiplier *= 5.0f;
        } else if (Keyboard.isKeyDown((int)56)) {
            multiplier *= 0.2f;
        }
        double factor = 0.1 * (double)f * (double)multiplier;
        double angleFactor = 0.35 * (double)f * (double)multiplier;
        float yaw = position.angle.yaw;
        float pitch = position.angle.pitch;
        float roll = position.angle.roll;
        float fov = position.angle.fov;
        boolean gotDragged = false;
        if (this.dragging != -1) {
            if (this.dragging == 0) {
                yaw += (float)(context.mouseX - this.lastX) * (multiplier * 0.35f);
                pitch += (float)(context.mouseY - this.lastY) * (multiplier * 0.35f);
            } else if (this.dragging == 1) {
                roll += (float)(context.mouseX - this.lastX) * (multiplier * 0.35f);
            } else if (this.dragging == 2) {
                fov += (float)(context.mouseY - this.lastY) * (multiplier * 0.35f);
            }
            gotDragged = true;
        }
        if (Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraUp.get())) || Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraDown.get()))) {
            pitch = (float)((double)pitch + (Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraUp.get())) ? -angleFactor : angleFactor));
        }
        if (Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraLeft.get())) || Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraRight.get()))) {
            yaw = (float)((double)yaw + (Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraLeft.get())) ? -angleFactor : angleFactor));
        }
        if (Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraRollMinus.get())) || Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraRollPlus.get()))) {
            roll = (float)((double)roll + (Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraRollMinus.get())) ? -angleFactor : angleFactor));
        }
        if (Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraFovMinus.get())) || Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraFovPlus.get()))) {
            fov = (float)((double)fov + (Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraFovMinus.get())) ? -angleFactor : angleFactor));
        }
        double x = position.point.x;
        double y = position.point.y;
        double z = position.point.z;
        double xx = 0.0;
        double yy = 0.0;
        double zz = 0.0;
        if (Keyboard.isKeyDown((int)((Integer)Aperture.flightUp.get())) || Keyboard.isKeyDown((int)((Integer)Aperture.flightDown.get()))) {
            double d = yy = Keyboard.isKeyDown((int)((Integer)Aperture.flightUp.get())) ? factor : -factor;
        }
        if (Keyboard.isKeyDown((int)((Integer)Aperture.flightLeft.get())) || Keyboard.isKeyDown((int)((Integer)Aperture.flightRight.get()))) {
            double d = xx = Keyboard.isKeyDown((int)((Integer)Aperture.flightLeft.get())) ? factor : -factor;
        }
        if (Keyboard.isKeyDown((int)((Integer)Aperture.flightForward.get())) || Keyboard.isKeyDown((int)((Integer)Aperture.flightBackward.get()))) {
            double d = zz = Keyboard.isKeyDown((int)((Integer)Aperture.flightForward.get())) ? factor : -factor;
        }
        if (gotDragged && this.type == MovementType.ORBIT || this.update) {
            vec = new Vector3d(0.0, 0.0, (double)this.distance);
            Matrix3d mat = new Matrix3d();
            mat.rotX((double)(-pitch / 180.0f * (float)Math.PI));
            mat.transform((Tuple3d)vec);
            mat.rotY((double)((180.0f - yaw) / 180.0f * (float)Math.PI));
            mat.transform((Tuple3d)vec);
            position.point.set(this.lastPosition.x + vec.x, this.lastPosition.y + vec.y, this.lastPosition.z + vec.z);
            position.angle.set(yaw, pitch, roll, fov);
            this.update = false;
        } else if (xx != 0.0 || yy != 0.0 || zz != 0.0 || yaw != position.angle.yaw || pitch != position.angle.pitch || roll != position.angle.roll || fov != position.angle.fov) {
            vec = new Vec3d(xx, yy, zz);
            if (this.type == MovementType.VERTICAL || this.type == MovementType.ORBIT) {
                vec = vec.func_178789_a(-pitch / 180.0f * (float)Math.PI);
            }
            vec = vec.func_178785_b(-yaw / 180.0f * (float)Math.PI);
            position.point.set(x += vec.field_72450_a, y += vec.field_72448_b, z += vec.field_72449_c);
            position.angle.set(yaw, pitch, roll, fov);
            this.calculateOrigin();
        }
        int speedFactor = 0;
        int speedDelay = (int)(100.0f / multiplier);
        if (Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraSpeedPlus.get())) || Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraSpeedMinus.get()))) {
            int n = speedFactor = Keyboard.isKeyDown((int)((Integer)Aperture.flightCameraSpeedPlus.get())) ? 1 : -1;
        }
        if (speedFactor != 0 && System.currentTimeMillis() > this.lastSpeed + (long)speedDelay) {
            this.speed = (int)((float)this.speed - Math.copySign(this.getSpeedFactor(speedFactor), speedFactor));
            this.speed = MathHelper.func_76125_a((int)this.speed, (int)1, (int)50000);
            this.lastSpeed = System.currentTimeMillis();
        }
        this.lastX = context.mouseX;
        this.lastY = context.mouseY;
    }

    public void drawSpeed(FontRenderer font, int x, int y) {
        float flightSpeed = (float)this.speed / 1000.0f;
        String speedFormat = "%.0f";
        if (flightSpeed < 0.01f) {
            speedFormat = "%.3f";
        } else if (flightSpeed < 0.1f) {
            speedFormat = "%.2f";
        } else if (flightSpeed < 1.0f) {
            speedFormat = "%.1f";
        }
        String speed = String.format(this.stringSpeed.get() + ": " + speedFormat, Float.valueOf(flightSpeed));
        int width = font.func_78256_a(speed);
        if (this.type == MovementType.ORBIT) {
            y -= 14;
        }
        Gui.func_73734_a((int)(x - width - 2), (int)(y - 3), (int)(x + 2), (int)(y + 10), (int)-1157627904);
        font.func_175063_a(speed, (float)(x - width), (float)y, 0xFFFFFF);
        if (this.type == MovementType.ORBIT) {
            speed = this.stringDistance.get() + ": " + this.distance;
            width = font.func_78256_a(speed);
            Gui.func_73734_a((int)(x - width - 2), (int)((y += 14) - 3), (int)(x + 2), (int)(y + 10), (int)-1157627904);
            font.func_175063_a(speed, (float)(x - width), (float)y, 0xFFFFFF);
        }
    }

    public void resize() {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean keyTyped(GuiContext guiContext) {
        return false;
    }

    public boolean canBeDrawn(Area area) {
        return true;
    }

    public void draw(GuiContext guiContext) {
    }

    public static enum MovementType {
        HORIZONTAL(APIcons.PLANE),
        VERTICAL(APIcons.HELICOPTER),
        ORBIT(APIcons.ORBIT);

        public final Icon icon;

        private MovementType(Icon icon) {
            this.icon = icon;
        }
    }
}

