/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client;

import java.lang.reflect.Field;
import mchorse.aperture.Aperture;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.CameraControl;
import mchorse.aperture.camera.smooth.SmoothCamera;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.events.CameraProfileChangedEvent;
import mchorse.mclib.utils.OpHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class KeyboardHandler {
    public static boolean inReplay;
    private Minecraft mc = Minecraft.func_71410_x();
    private KeyBinding toggleRender;
    private KeyBinding toggleRunning;
    private KeyBinding addPoint;
    public KeyBinding addRoll;
    public KeyBinding reduceRoll;
    private KeyBinding resetRoll;
    public KeyBinding addFov;
    public KeyBinding reduceFov;
    private KeyBinding resetFov;
    private KeyBinding stepUp;
    private KeyBinding stepDown;
    private KeyBinding stepLeft;
    private KeyBinding stepRight;
    private KeyBinding stepFront;
    private KeyBinding stepBack;
    private KeyBinding rotateUp;
    private KeyBinding rotateDown;
    private KeyBinding rotateLeft;
    private KeyBinding rotateRight;
    private KeyBinding cameraEditor;
    private KeyBinding smoothCamera;

    public static boolean checkReplayWorld() {
        try {
            Class<?> replayMod = Class.forName("com.replaymod.replay.ReplayModReplay");
            Field replayField = replayMod.getField("instance");
            Field replayHandlerField = replayMod.getDeclaredField("replayHandler");
            replayHandlerField.setAccessible(true);
            if (replayHandlerField.get(replayField.get(null)) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void setSmoothCamera(boolean enabled) {
        SmoothCamera camera = ClientProxy.renderer.smooth;
        camera.enabled.set((Object)enabled);
        if (((Boolean)camera.enabled.get()).booleanValue()) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            camera.set(player.field_70177_z, -player.field_70125_A);
        }
    }

    public KeyboardHandler() {
        String camera = "key.aperture.camera";
        String profile = "key.aperture.profile.title";
        String control = "key.aperture.control.title";
        String misc = "key.aperture.misc";
        this.toggleRender = new KeyBinding("key.aperture.profile.toggle", 25, profile);
        this.toggleRunning = new KeyBinding("key.aperture.profile.playback", 44, profile);
        this.addPoint = new KeyBinding("key.aperture.profile.point", 0, profile);
        ClientRegistry.registerKeyBinding((KeyBinding)this.toggleRender);
        ClientRegistry.registerKeyBinding((KeyBinding)this.toggleRunning);
        ClientRegistry.registerKeyBinding((KeyBinding)this.addPoint);
        this.addRoll = new KeyBinding("key.aperture.roll.add", 0, camera);
        this.reduceRoll = new KeyBinding("key.aperture.roll.reduce", 0, camera);
        this.resetRoll = new KeyBinding("key.aperture.roll.reset", 0, camera);
        ClientRegistry.registerKeyBinding((KeyBinding)this.addRoll);
        ClientRegistry.registerKeyBinding((KeyBinding)this.reduceRoll);
        ClientRegistry.registerKeyBinding((KeyBinding)this.resetRoll);
        this.addFov = new KeyBinding("key.aperture.fov.add", 0, camera);
        this.reduceFov = new KeyBinding("key.aperture.fov.reduce", 0, camera);
        this.resetFov = new KeyBinding("key.aperture.fov.reset", 0, camera);
        ClientRegistry.registerKeyBinding((KeyBinding)this.addFov);
        ClientRegistry.registerKeyBinding((KeyBinding)this.reduceFov);
        ClientRegistry.registerKeyBinding((KeyBinding)this.resetFov);
        this.stepUp = new KeyBinding("key.aperture.control.stepUp", 0, control);
        this.stepDown = new KeyBinding("key.aperture.control.stepDown", 0, control);
        this.stepLeft = new KeyBinding("key.aperture.control.stepLeft", 0, control);
        this.stepRight = new KeyBinding("key.aperture.control.stepRight", 0, control);
        this.stepFront = new KeyBinding("key.aperture.control.stepFront", 0, control);
        this.stepBack = new KeyBinding("key.aperture.control.stepBack", 0, control);
        ClientRegistry.registerKeyBinding((KeyBinding)this.stepUp);
        ClientRegistry.registerKeyBinding((KeyBinding)this.stepDown);
        ClientRegistry.registerKeyBinding((KeyBinding)this.stepLeft);
        ClientRegistry.registerKeyBinding((KeyBinding)this.stepRight);
        ClientRegistry.registerKeyBinding((KeyBinding)this.stepFront);
        ClientRegistry.registerKeyBinding((KeyBinding)this.stepBack);
        this.rotateUp = new KeyBinding("key.aperture.control.rotateUp", 0, control);
        this.rotateDown = new KeyBinding("key.aperture.control.rotateDown", 0, control);
        this.rotateLeft = new KeyBinding("key.aperture.control.rotateLeft", 0, control);
        this.rotateRight = new KeyBinding("key.aperture.control.rotateRight", 0, control);
        ClientRegistry.registerKeyBinding((KeyBinding)this.rotateUp);
        ClientRegistry.registerKeyBinding((KeyBinding)this.rotateDown);
        ClientRegistry.registerKeyBinding((KeyBinding)this.rotateLeft);
        ClientRegistry.registerKeyBinding((KeyBinding)this.rotateRight);
        this.cameraEditor = new KeyBinding("key.aperture.camera_editor", 46, misc);
        this.smoothCamera = new KeyBinding("key.aperture.smooth_camera", 0, misc);
        ClientRegistry.registerKeyBinding((KeyBinding)this.cameraEditor);
        ClientRegistry.registerKeyBinding((KeyBinding)this.smoothCamera);
    }

    @SubscribeEvent
    public void onUserLogIn(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (Loader.isModLoaded((String)"replaymod")) {
            inReplay = KeyboardHandler.checkReplayWorld();
        }
    }

    @SubscribeEvent
    public void onUserLogOut(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        ClientProxy.cameraEditor = null;
        ClientProxy.control.reset();
        ClientProxy.server = false;
        if (Loader.isModLoaded((String)"replaymod")) {
            inReplay = false;
        }
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        EntityPlayerSP player = this.mc.field_71439_g;
        if (inReplay) {
            return;
        }
        try {
            this.handleCameraBindings((EntityPlayer)player);
        }
        catch (CommandException e) {
            Aperture.l10n.error((ICommandSender)player, e.getMessage(), e.func_74844_a());
        }
        if (this.cameraEditor.func_151468_f() && ClientProxy.canUseCameraEditor()) {
            ClientProxy.openCameraEditor();
        }
        if (this.addPoint.func_151468_f() && ClientProxy.canUseCameraEditor()) {
            ClientProxy.getCameraEditor().addPathPoint();
        }
        if (this.smoothCamera.func_151468_f()) {
            KeyboardHandler.setSmoothCamera((Boolean)ClientProxy.renderer.smooth.enabled.get() == false);
        }
    }

    private void handleCameraBindings(EntityPlayer player) throws CommandException {
        CameraControl control = ClientProxy.control;
        if (this.toggleRender.func_151468_f()) {
            ClientProxy.renderer.toggleRender();
        }
        if (this.toggleRunning.func_151468_f() && ClientProxy.canUseCameraEditor()) {
            ClientProxy.runner.toggle(ClientProxy.control.currentProfile, 0L);
        }
        if (this.resetRoll.func_151468_f()) {
            control.resetRoll();
        }
        if (this.resetFov.func_151468_f()) {
            control.resetFOV();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = this.mc.field_71439_g;
        if (player != null) {
            if (inReplay) {
                return;
            }
            if (!((Boolean)ClientProxy.renderer.smooth.enabled.get()).booleanValue()) {
                CameraControl control = ClientProxy.control;
                if (this.addRoll.func_151470_d()) {
                    control.roll += 0.5f;
                } else if (this.reduceRoll.func_151470_d()) {
                    control.roll -= 0.5f;
                }
                if (this.addFov.func_151470_d()) {
                    Minecraft.func_71410_x().field_71474_y.field_74334_X += 0.25f;
                } else if (this.reduceFov.func_151470_d()) {
                    Minecraft.func_71410_x().field_71474_y.field_74334_X += -0.25f;
                }
            }
            double factor = ((Float)Aperture.stepFactor.get()).floatValue();
            double angleFactor = ((Float)Aperture.rotateFactor.get()).floatValue();
            float yaw = player.field_70177_z;
            float pitch = player.field_70125_A;
            if (this.rotateUp.func_151470_d() || this.rotateDown.func_151470_d()) {
                pitch = (float)((double)pitch + (this.rotateUp.func_151470_d() ? -angleFactor : angleFactor));
            }
            if (this.rotateLeft.func_151470_d() || this.rotateRight.func_151470_d()) {
                yaw = (float)((double)yaw + (this.rotateLeft.func_151470_d() ? -angleFactor : angleFactor));
            }
            double x = player.field_70165_t;
            double y = player.field_70163_u;
            double z = player.field_70161_v;
            double xx = 0.0;
            double yy = 0.0;
            double zz = 0.0;
            if (this.stepUp.func_151470_d() || this.stepDown.func_151470_d()) {
                double d = yy = this.stepUp.func_151470_d() ? factor : -factor;
            }
            if (this.stepLeft.func_151470_d() || this.stepRight.func_151470_d()) {
                double d = xx = this.stepLeft.func_151470_d() ? factor : -factor;
            }
            if (this.stepFront.func_151470_d() || this.stepBack.func_151470_d()) {
                double d = zz = this.stepFront.func_151470_d() ? factor : -factor;
            }
            if (!OpHelper.isPlayerOp()) {
                return;
            }
            if (xx != 0.0 || yy != 0.0 || zz != 0.0 || yaw != player.field_70177_z || pitch != player.field_70125_A) {
                Vec3d vec = new Vec3d(xx, yy, zz);
                vec = vec.func_178785_b(-yaw / 180.0f * (float)Math.PI);
                player.func_70080_a(x += vec.field_72450_a, y += vec.field_72448_b, z += vec.field_72449_c, yaw, pitch);
                player.func_70016_h(0.0, 0.0, 0.0);
            }
        }
    }

    @SubscribeEvent
    public void onCameraProfileChanged(CameraProfileChangedEvent event) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiCameraEditor) {
            ((GuiCameraEditor)screen).updateSaveButton(event.profile);
        }
    }
}

