/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mchorse.aperture.Aperture;
import mchorse.aperture.utils.CodelineParser;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.config.ShaderOptionVariable;
import net.optifine.shaders.config.ShaderOptionVariableConst;
import net.optifine.shaders.config.ShaderPackParser;
import net.optifine.shaders.uniform.ShaderUniform1f;
import net.optifine.shaders.uniform.ShaderUniform1i;

public class AsmShaderHandler {
    public static final String owner = "mchorse/aperture/client/AsmShaderHandler";
    public static final String uniformPrefix = "_uniform_";
    public static final Pattern PATTERN_DEFINE = Pattern.compile("^\\s*#define\\s", 2);
    public static final Pattern PATTERN_IF = Pattern.compile("^\\s*#(?:el)?(?:if)\\s", 2);
    public static final Pattern PATTERN_CONST = Pattern.compile("^\\s*const\\s");
    public static final Pattern PATTERN_CASE = Pattern.compile("^\\s*case\\s");
    public static final Pattern PATTERN_ARRAY = Pattern.compile("\\[\\s*[_A-Za-z].*\\s*\\]");
    public static final Map<String, Integer> uniform1i = new HashMap<String, Integer>();
    public static final Map<String, Float> uniform1f = new HashMap<String, Float>();
    public static final Map<String, ShaderUniform1i> option1i = new LinkedHashMap<String, ShaderUniform1i>();
    public static final Map<String, ShaderUniform1f> option1f = new LinkedHashMap<String, ShaderUniform1f>();
    public static final Map<String, String> cachedShaders = new HashMap<String, String>();
    public static final Map<String, List<String>> cachedIncludes = new HashMap<String, List<String>>();
    public static CodelineParser caseParser = new CodelineParser(':');
    public static CodelineParser constParser = new CodelineParser(';');
    public static float sunPathRotation;

    public static void setProgramUniform1i(ShaderUniform1i su, int value) {
        if (uniform1i.get(su.getName()) != null) {
            value = uniform1i.get(su.getName());
        }
        su.setValue(value);
    }

    public static void setProgramUniform1f(ShaderUniform1f su, float value) {
        if (uniform1f.get(su.getName()) != null) {
            value = uniform1f.get(su.getName()).floatValue();
        } else if ("sunPathRotation".equals(su.getName()) && sunPathRotation != value) {
            Shaders.sunPathRotation = sunPathRotation = value;
        }
        su.setValue(value);
    }

    public static void updateOptionUniforms() {
        for (Map.Entry<String, ShaderUniform1i> entry : option1i.entrySet()) {
            entry.getValue().setProgram(Shaders.activeProgramID);
            AsmShaderHandler.setProgramUniform1i(entry.getValue(), Integer.parseInt(Shaders.getShaderOption((String)entry.getKey()).getValue()));
        }
        for (Map.Entry<String, ShaderUniform1i> entry : option1f.entrySet()) {
            ((ShaderUniform1f)entry.getValue()).setProgram(Shaders.activeProgramID);
            AsmShaderHandler.setProgramUniform1f((ShaderUniform1f)entry.getValue(), Float.parseFloat(Shaders.getShaderOption((String)entry.getKey()).getValue()));
        }
    }

    public static void afterInit() {
        for (ShaderUniform1i shaderUniform1i : option1i.values()) {
            shaderUniform1i.reset();
        }
        for (ShaderUniform1f shaderUniform1f : option1f.values()) {
            shaderUniform1f.reset();
        }
        sunPathRotation = Shaders.sunPathRotation;
    }

    public static void loadShaderPack() {
        cachedShaders.clear();
        cachedIncludes.clear();
        option1i.clear();
        option1f.clear();
    }

    public static void collectShaderOptions() {
        caseParser.reset();
    }

    public static ShaderOption getShaderOption(String line, String path, ShaderOption option, Map<String, ShaderOption> mapOptions) {
        block4: {
            block6: {
                block5: {
                    if (option != null || Aperture.optifineShaderOptionCurve != null && !((Boolean)Aperture.optifineShaderOptionCurve.get()).booleanValue()) break block4;
                    if (!PATTERN_IF.matcher(line).find()) break block5;
                    for (ShaderOption so : mapOptions.values()) {
                        ShaderUniformOption uniform;
                        if (!(so instanceof ShaderUniformOption) || !(uniform = (ShaderUniformOption)so).isUniform()) continue;
                        uniform.checkMacro(line);
                    }
                    break block4;
                }
                if (AsmShaderHandler.caseParser.cache.length() <= 0 && !PATTERN_CASE.matcher(line).find()) break block6;
                caseParser.parseLine(line);
                if (!AsmShaderHandler.caseParser.isEnd) break block4;
                String caseLine = AsmShaderHandler.caseParser.cache.toString();
                for (ShaderOption so : mapOptions.values()) {
                    ShaderUniformOption uniform;
                    if (!(so instanceof ShaderUniformOption) || !(uniform = (ShaderUniformOption)so).isUniform()) continue;
                    uniform.checkCase(caseLine);
                }
                caseParser.reset();
                break block4;
            }
            if (PATTERN_ARRAY.matcher(line).find()) {
                for (ShaderOption so : mapOptions.values()) {
                    ShaderUniformOption uniform;
                    if (!(so instanceof ShaderUniformOption) || !(uniform = (ShaderUniformOption)so).isUniform()) continue;
                    uniform.checkArray(line);
                }
            }
        }
        return option;
    }

    public static BufferedReader convert(Object obj) throws IOException {
        if (obj instanceof Iterable) {
            Iterator iterator = ((Iterable)obj).iterator();
            StringBuilder builder = new StringBuilder();
            while (iterator.hasNext()) {
                builder.append((String)iterator.next()).append('\n');
            }
            return new BufferedReader(new StringReader(builder.toString()));
        }
        return (BufferedReader)obj;
    }

    public static BufferedReader callResolveIncludes(Object reader, String filePath, IShaderPack shaderPack, int fileIndex, List<String> listFiles, int includeLevel) throws IOException {
        try {
            Method method = ShaderPackParser.class.getMethod("resolveIncludes", reader.getClass(), String.class, IShaderPack.class, Integer.TYPE, List.class, Integer.TYPE);
            return AsmShaderHandler.convert(method.invoke(null, reader, filePath, shaderPack, fileIndex, listFiles, includeLevel));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Aperture.LOGGER.error("Do not support this version of Optifine!", (Throwable)e);
            return null;
        }
    }

    public static void addOptionUniform(ShaderUniformOption option) {
        if (option.isUniform()) {
            switch (option.uniformType) {
                case 1: {
                    if (option1i.containsKey(option.getName())) break;
                    option1i.put(option.getName(), new ShaderUniform1i(uniformPrefix + option.getName()));
                    break;
                }
                case 2: {
                    if (option1f.containsKey(option.getName())) break;
                    option1f.put(option.getName(), new ShaderUniform1f(uniformPrefix + option.getName()));
                }
            }
        }
    }

    public static void addOptionUniformConst(ShaderUniformConstOption option) {
        if (option.isUniform()) {
            switch (option.type) {
                case "int": {
                    if (option1i.containsKey(option.getName())) break;
                    option1i.put(option.getName(), new ShaderUniform1i(option.getName()));
                    break;
                }
                case "float": {
                    if (option1f.containsKey(option.getName())) break;
                    option1f.put(option.getName(), new ShaderUniform1f(option.getName()));
                }
            }
        }
    }

    public static String getConstLine(String line, BufferedReader reader, StringBuilder origin) throws IOException {
        origin.setLength(0);
        origin.append(line);
        constParser.reset();
        constParser.parseLine(line);
        while (!AsmShaderHandler.constParser.isEnd && (line = reader.readLine()) != null) {
            constParser.parseLine(line);
            origin.append('\n').append(line);
        }
        return AsmShaderHandler.constParser.cache.toString();
    }

    public static BufferedReader getCachedShader(Object reader, String filePath, IShaderPack shaderPack, int fileIndex, List<String> listFiles, int includeLevel) throws IOException {
        if (!cachedShaders.containsKey(filePath)) {
            String line;
            BufferedReader resolved = AsmShaderHandler.callResolveIncludes(reader, filePath, shaderPack, fileIndex, listFiles, includeLevel);
            if (resolved == null) {
                return null;
            }
            if (!((Boolean)Aperture.optifineShaderOptionCurve.get()).booleanValue()) {
                return resolved;
            }
            cachedIncludes.put(filePath, new ArrayList<String>(listFiles));
            StringBuilder builder = new StringBuilder();
            ArrayList<ShaderUniformOption> uniformOptions = new ArrayList<ShaderUniformOption>();
            ArrayList<ShaderUniformConstOption> uniformConstOptions = new ArrayList<ShaderUniformConstOption>();
            HashSet<String> uniforms = new HashSet<String>();
            HashSet<Pattern> definePatterns = new HashSet<Pattern>();
            HashSet<Pattern> constPatterns = new HashSet<Pattern>();
            for (ShaderOption option : Shaders.getShaderPackOptions()) {
                ShaderUniformConstOption shaderUniformConstOption;
                if (option instanceof ShaderUniformOption) {
                    ShaderUniformOption shaderUniformOption = (ShaderUniformOption)option;
                    if (!shaderUniformOption.isEnabled() || !shaderUniformOption.isUniform()) continue;
                    uniformOptions.add(shaderUniformOption);
                    definePatterns.add(Pattern.compile(String.format("^\\s*#\\w+\\s+(\\S+)\\s+(?:.*\\W)?%s(?:\\W.*)?$", option.getName())));
                    constPatterns.add(Pattern.compile(String.format("^\\s*const\\s+\\S+\\s+(\\w+)\\s*=(?:.*\\W)?%s(?:\\W.*)?$", option.getName())));
                    continue;
                }
                if (!(option instanceof ShaderUniformConstOption) || !(shaderUniformConstOption = (ShaderUniformConstOption)option).isEnabled() || !shaderUniformConstOption.isUniform()) continue;
                uniformConstOptions.add(shaderUniformConstOption);
                definePatterns.add(Pattern.compile(String.format("^\\s*#\\w+\\s+(\\S+)\\s+(?:.*\\W)?%s(?:\\W.*)?$", option.getName())));
                constPatterns.add(Pattern.compile(String.format("^\\s*const\\s+\\S+\\s+(\\w+)\\s*=(?:.*\\W)?%s(?:\\W.*)?$", option.getName())));
            }
            ShaderUniformOption.doPatch = true;
            ShaderUniformConstOption.doPatch = true;
            StringBuilder lineBuffer = new StringBuilder();
            while ((line = resolved.readLine()) != null) {
                Matcher result;
                boolean matched = false;
                if (PATTERN_DEFINE.matcher(line).find()) {
                    for (ShaderUniformOption shaderUniformOption : uniformOptions) {
                        matched = shaderUniformOption.matchesLine(line);
                        if (!matched) continue;
                        line = shaderUniformOption.getSourceLine();
                        uniforms.add(String.format("uniform %s %s;\n", shaderUniformOption.uniformType == 1 ? "int" : "float", uniformPrefix + shaderUniformOption.getName()));
                        AsmShaderHandler.addOptionUniform(shaderUniformOption);
                        break;
                    }
                    if (!matched) {
                        Object defVar = null;
                        for (Pattern pattern : definePatterns) {
                            result = pattern.matcher(line);
                            if (!result.find()) continue;
                            defVar = result.group(1);
                            definePatterns.add(Pattern.compile(String.format("^\\s*#\\w+\\s+(\\S+)\\s+(?:.*\\W)?%s(?:\\W.*)?$", defVar)));
                            constPatterns.add(Pattern.compile(String.format("^\\s*const\\s+\\w+\\s+(\\w+)\\s*=(?:.*\\W)?%s(?:\\W.*)?$", defVar)));
                            break;
                        }
                    }
                }
                if (!matched && PATTERN_CONST.matcher(line).find()) {
                    line = AsmShaderHandler.getConstLine(line, resolved, lineBuffer);
                    for (ShaderUniformConstOption shaderUniformConstOption : uniformConstOptions) {
                        matched = shaderUniformConstOption.matchesLine(line);
                        if (!matched) continue;
                        line = shaderUniformConstOption.getSourceLine();
                        uniforms.add(String.format("uniform %s %s;\n/*\n%s\n*/\n", shaderUniformConstOption.type, shaderUniformConstOption.getName(), line));
                        AsmShaderHandler.addOptionUniformConst(shaderUniformConstOption);
                        line = "";
                        break;
                    }
                    if (!matched) {
                        String constVar = null;
                        for (Pattern pattern : constPatterns) {
                            result = pattern.matcher(line);
                            if (!result.find()) continue;
                            constVar = result.group(1);
                            line = lineBuffer.toString().replaceFirst("const\\s", "");
                            break;
                        }
                        if (constVar != null) {
                            definePatterns.add(Pattern.compile(String.format("^\\s*#\\w+\\s+(\\S+)\\s+(?:.*\\W)?%s(?:\\W.*)?$", constVar)));
                            constPatterns.add(Pattern.compile(String.format("^\\s*const\\s+\\w+\\s+(\\w+)\\s*=(?:.*\\W)?%s(?:\\W.*)?$", constVar)));
                        } else {
                            line = lineBuffer.toString();
                        }
                    }
                }
                builder.append(line).append('\n');
            }
            resolved.close();
            ShaderUniformOption.doPatch = false;
            ShaderUniformConstOption.doPatch = false;
            int version = builder.indexOf("#version");
            int pos = builder.indexOf("#line", version);
            for (String uniform3 : uniforms) {
                builder.insert(pos, uniform3);
            }
            cachedShaders.put(filePath, builder.toString());
        }
        if (reader instanceof BufferedReader) {
            ((BufferedReader)reader).close();
        }
        listFiles.clear();
        listFiles.addAll((Collection<String>)cachedIncludes.get(filePath));
        return new BufferedReader(new StringReader(cachedShaders.get(filePath)));
    }

    public static class ShaderUniformConstOption
    extends ShaderOptionVariableConst {
        public static boolean doPatch = false;
        public final boolean isUniform;
        public final String type;

        public ShaderUniformConstOption(String name, String type, String description, String value, String[] values, String path) {
            super(name, type, description, value, values, path);
            this.isUniform = "sunPathRotation".equals(name);
            this.type = type;
        }

        public boolean matchesLine(String line) {
            if (this.isUniform() && !doPatch) {
                return false;
            }
            return super.matchesLine(line);
        }

        public boolean isUniform() {
            return this.isUniform && (Aperture.optifineShaderOptionCurve == null || (Boolean)Aperture.optifineShaderOptionCurve.get() != false);
        }
    }

    public static class ShaderUniformOption
    extends ShaderOptionVariable {
        public static final int NOT_SUPPORT = 0;
        public static final int INTEGER = 1;
        public static final int FLOAT = 2;
        public static boolean doPatch = false;
        public final Pattern defineChecker;
        public final Pattern caseChecker;
        public final Pattern arrayChecker;
        public int uniformType;

        public ShaderUniformOption(String name, String description, String value, String[] values, String path) {
            super(name, description, value, values, path);
            this.defineChecker = Pattern.compile(String.format(".*\\W%s(?:\\W.*)?", name));
            this.caseChecker = Pattern.compile(String.format("^\\s*case\\s+%s\\s*:", name));
            this.arrayChecker = Pattern.compile(String.format("\\[(?:.*\\W)?%s(?:\\W.*)?\\]", name));
            if (value != null && !this.checkReversedName(name)) {
                boolean isInteger = true;
                boolean isFloat = true;
                for (String val : values) {
                    isInteger = isInteger && this.checkInt(val);
                    isFloat = isFloat && this.checkFloat(val);
                }
                this.uniformType = isInteger ? 1 : (isFloat ? 2 : 0);
            } else {
                this.uniformType = 0;
            }
        }

        public boolean matchesLine(String line) {
            if (this.isUniform() && !doPatch) {
                return false;
            }
            return super.matchesLine(line);
        }

        public String getSourceLine() {
            if (this.isUniform()) {
                return "#define " + this.getName() + " " + AsmShaderHandler.uniformPrefix + this.getName();
            }
            return super.getSourceLine();
        }

        public boolean isUniform() {
            return this.uniformType != 0 && (Aperture.optifineShaderOptionCurve == null || (Boolean)Aperture.optifineShaderOptionCurve.get() != false);
        }

        public void checkMacro(String line) {
            if (this.defineChecker.matcher(line).matches()) {
                this.uniformType = 0;
            }
        }

        public void checkCase(String line) {
            if (this.caseChecker.matcher(line).find()) {
                this.uniformType = 0;
            }
        }

        public void checkArray(String line) {
            if (this.arrayChecker.matcher(line).find()) {
                this.uniformType = 0;
            }
        }

        private boolean checkInt(String str) {
            try {
                Integer.parseInt(str);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        private boolean checkFloat(String str) {
            try {
                Float.parseFloat(str);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        private boolean checkReversedName(String name) {
            return name == null || name.contains("__") || name.toLowerCase().startsWith("gl_");
        }
    }
}

