/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.client;

import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldProvider;

public class AsmRenderingHandler {
    public static final String owner = "mchorse/aperture/client/AsmRenderingHandler";
    public static final HashMap<Curve, Double> values = new HashMap();

    public static Vec3d getSkyColor(WorldProvider provider, Entity entity, float partialTicks) {
        Vec3d sky = provider.getSkyColor(entity, partialTicks);
        double skyR = AsmRenderingHandler.getOption(Curve.SkyR, sky.field_72450_a);
        double skyG = AsmRenderingHandler.getOption(Curve.SkyG, sky.field_72448_b);
        double skyB = AsmRenderingHandler.getOption(Curve.SkyB, sky.field_72449_c);
        return new Vec3d(skyR, skyG, skyB);
    }

    public static Vec3d getCloudColor(WorldProvider provider, float partialTicks) {
        Vec3d cloud = provider.getCloudColor(partialTicks);
        double cloudR = AsmRenderingHandler.getOption(Curve.CloudR, cloud.field_72450_a);
        double cloudG = AsmRenderingHandler.getOption(Curve.CloudG, cloud.field_72448_b);
        double cloudB = AsmRenderingHandler.getOption(Curve.CloudB, cloud.field_72449_c);
        return new Vec3d(cloudR, cloudG, cloudB);
    }

    public static Vec3d getFogColor(WorldProvider provider, float celestialAngle, float partialTicks) {
        Vec3d fog = provider.func_76562_b(celestialAngle, partialTicks);
        double fogR = AsmRenderingHandler.getOption(Curve.FogR, fog.field_72450_a);
        double fogG = AsmRenderingHandler.getOption(Curve.FogG, fog.field_72448_b);
        double fogB = AsmRenderingHandler.getOption(Curve.FogB, fog.field_72449_c);
        return new Vec3d(fogR, fogG, fogB);
    }

    public static float getCelestialAngle(WorldProvider provider, long worldTime, float partialTicks) {
        double angle = AsmRenderingHandler.getOption(Curve.CelestialAngle, (double)provider.func_76563_a(worldTime, partialTicks) * 360.0);
        if ((angle %= 360.0) < 0.0) {
            angle += 360.0;
        }
        return (float)angle / 360.0f;
    }

    public static float getFogDensity(float density) {
        return (float)AsmRenderingHandler.getOption(Curve.FogDensity, density);
    }

    public static float getFogStart(float start) {
        return (float)AsmRenderingHandler.getOption(Curve.FogStart, start);
    }

    public static float getFogEnd(float end) {
        return (float)AsmRenderingHandler.getOption(Curve.FogEnd, end);
    }

    public static double getOption(Curve option, double defaultValue) {
        Double value = values.get((Object)option);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static enum Curve {
        SkyR,
        SkyG,
        SkyB,
        CloudR,
        CloudG,
        CloudB,
        FogR,
        FogG,
        FogB,
        FogStart,
        FogEnd,
        FogDensity,
        CelestialAngle;

    }
}

