/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.capabilities;

import mchorse.aperture.camera.CameraUtils;
import mchorse.aperture.capabilities.camera.Camera;
import mchorse.aperture.capabilities.camera.CameraProvider;
import mchorse.aperture.capabilities.camera.ICamera;
import mchorse.aperture.network.Dispatcher;
import mchorse.aperture.network.common.PacketAperture;
import mchorse.mclib.utils.OpHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CapabilityHandler {
    public static final ResourceLocation CAMERA_CAP = new ResourceLocation("aperture", "camera_capability");

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer)) {
            return;
        }
        event.addCapability(CAMERA_CAP, (ICapabilityProvider)new CameraProvider());
    }

    @SubscribeEvent
    public void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        ICamera camera = Camera.get(player);
        if (camera != null && camera.hasProfile() && OpHelper.isPlayerOp((EntityPlayerMP)((EntityPlayerMP)player))) {
            CameraUtils.sendProfileToPlayer(camera.currentProfile(), (EntityPlayerMP)player, false, true);
            camera.setCurrentProfileTimestamp(System.currentTimeMillis());
        }
        Dispatcher.sendTo(new PacketAperture(), (EntityPlayerMP)player);
    }
}

