/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.values;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.values.ValuePosition;
import mchorse.mclib.config.values.Value;

public class ValuePositions
extends Value {
    private List<Position> positions = new ArrayList<Position>();

    public ValuePositions(String id) {
        super(id);
    }

    public void add(Position position) {
        this.positions.add(position);
        this.addSubValue(new ValuePosition(String.valueOf(this.positions.size() - 1), position));
    }

    public Position get(int index) {
        return this.positions.get(index);
    }

    public int size() {
        return this.positions.size();
    }

    public void sync() {
        this.removeAllSubValues();
        int i = 0;
        for (Position position : this.positions) {
            this.addSubValue(new ValuePosition(String.valueOf(i), position));
            ++i;
        }
    }

    public void set(List<Position> positions) {
        this.reset();
        for (Position position : positions) {
            this.add(position.copy());
        }
    }

    public Object getValue() {
        ArrayList<Position> positions = new ArrayList<Position>();
        for (Position position : this.positions) {
            positions.add(position.copy());
        }
        return positions;
    }

    public void setValue(Object value) {
        List list;
        if (value instanceof List && ((list = (List)value).isEmpty() || list.get(0) instanceof Position)) {
            this.set(list);
        }
    }

    public void reset() {
        this.positions.clear();
        this.removeAllSubValues();
    }

    public void fromJSON(JsonElement element) {
        if (element.isJsonArray()) {
            this.reset();
            JsonArray array = element.getAsJsonArray();
            for (JsonElement child : array) {
                if (!child.isJsonObject()) continue;
                Position position = new Position();
                position.fromJSON(child.getAsJsonObject());
                this.add(position);
            }
        }
    }

    public JsonElement toJSON() {
        JsonArray array = new JsonArray();
        for (Position position : this.positions) {
            array.add((JsonElement)position.toJSON());
        }
        return array;
    }

    public void copy(Value value) {
        if (value instanceof ValuePositions) {
            this.set(((ValuePositions)value).positions);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.reset();
        int c = buffer.readInt();
        for (int i = 0; i < c; ++i) {
            this.add(Position.fromBytes(buffer));
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.positions.size());
        for (Position position : this.positions) {
            position.toBytes(buffer);
        }
    }
}

